/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.controls;

import com.nxp.swtools.common.uct.controller.AUctController;
import com.nxp.swtools.common.uct.controls.IBaseControl;
import com.nxp.swtools.common.uct.controls.IChildControl;
import com.nxp.swtools.common.uct.controls.IRefreshableBaseControl;
import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.EnumSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.ItemSetting;
import com.nxp.swtools.common.uct.utils.UctLayoutUtils;
import com.nxp.swtools.common.uct.utils.UctUtils;
import com.nxp.swtools.common.uct.validation.IProblemSource;
import com.nxp.swtools.common.uct.validation.IProblemUIContainer;
import com.nxp.swtools.common.ui.utils.perspectives.PerspectivesHelper;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.gtm.controller.GtmController;
import com.nxp.swtools.gtm.controller.validation.GtmProblem;
import com.nxp.swtools.gtm.controls.ListenerHandle;
import com.nxp.swtools.gtm.gui.GtmSceneCreator;
import com.nxp.swtools.gtm.gui.GtmValidatedComboBox;
import com.nxp.swtools.gtm.gui.utils.GtmLayoutUtils;
import com.nxp.swtools.gtm.model.xml.settings.GtmConstraintsTable;
import com.nxp.swtools.gtm.model.xml.settings.GtmEnumSetting;
import com.nxp.swtools.gtm.tasks.GtmRefreshTask;
import com.nxp.swtools.gtm.tasks.GtmUpdateComboBoxStyleTask;
import com.nxp.swtools.gtm.tasks.GtmUpdateDisabledStateComboBoxStyleTask;
import com.nxp.swtools.gtml.controller.utils.StorageGtmUtils;
import com.nxp.swtools.utils.events.IEventListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import org.eclipse.ui.services.IDisposable;

public class EnumSettingControl
extends HBox
implements IRefreshableBaseControl,
IChildControl,
IDisposable {
    private GtmEnumSetting enumSetting;
    protected Parent parent;
    private GtmValidatedComboBox enumCmb;
    private ObservableList<String> items = FXCollections.observableArrayList();
    private ListenerHandle<String> selectionHandle;
    private ListenerHandle<Boolean> disableStateHandle;
    private List<ListenerHandle<Boolean>> itemsVisibleHandles;
    private List<ListenerHandle<Boolean>> itemsDisableHandles;
    private ListenerHandle<Boolean> validationStateHandle;
    private ListenerHandle<Boolean> disableStateComboBoxStyleHandle;
    protected final IEventListener showProblemListener = event -> {
        GtmProblem gtmProblem;
        IProblemUIContainer problemSourceContainer;
        Node currentNode;
        if (event.originator instanceof GtmProblem && (currentNode = (Node)(problemSourceContainer = (gtmProblem = (GtmProblem)event.originator).getSourceContainer())) != null) {
            PerspectivesHelper.showView((String)"com.nxp.swtools.gtm.gui.GtmView");
            GtmLayoutUtils.ensureVisible(currentNode, currentNode);
            UctUtils.runNowOrRunLater(() -> {
                currentNode.setDisable(false);
                currentNode.requestFocus();
            });
        }
    };

    public EnumSettingControl(GtmEnumSetting enumSetting, Parent parent) {
        this.enumSetting = enumSetting;
        this.parent = parent;
        this.enumCmb = new GtmValidatedComboBox();
        this.selectionHandle = new ListenerHandle<String>((ObservableValue<String>)this.enumCmb.getSelectionModel().selectedItemProperty(), this.createSelectionListener());
        this.validationStateHandle = new ListenerHandle<Boolean>((ObservableValue<Boolean>)enumSetting.getIsValueValidProperty(), this.createIsValueValidComboBoxStyleListener());
        this.disableStateComboBoxStyleHandle = new ListenerHandle<Boolean>((ObservableValue<Boolean>)enumSetting.getDisabledProperty(), this.createDisableComboBoxStyleListener());
        this.disableStateHandle = new ListenerHandle<Boolean>((ObservableValue<Boolean>)enumSetting.getDisabledProperty(), this.createBoolRefreshListener());
        this.itemsVisibleHandles = new LinkedList<ListenerHandle<Boolean>>();
        this.itemsDisableHandles = new LinkedList<ListenerHandle<Boolean>>();
        for (ItemSetting itemSetting : enumSetting.getItems()) {
            this.itemsVisibleHandles.add(new ListenerHandle<Boolean>((ObservableValue<Boolean>)itemSetting.getVisibleProperty(), this.createBoolRefreshListener()));
            this.itemsDisableHandles.add(new ListenerHandle<Boolean>((ObservableValue<Boolean>)itemSetting.getDisabledProperty(), this.createBoolRefreshListener()));
        }
        this.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateComboBoxfieldStyle() {
        GtmEnumSetting gtmEnumSetting = this.enumSetting;
        synchronized (gtmEnumSetting) {
            List enumProblems = GtmController.getInstance().getProblemsManager().getProblemListForSource((IProblemSource)this.enumSetting);
            if (enumProblems.isEmpty()) {
                this.enumCmb.getStyleClass().remove((Object)"errorField");
            } else {
                if (!this.enumCmb.getStyleClass().contains((Object)"errorField")) {
                    this.enumCmb.getStyleClass().add((Object)"errorField");
                }
                for (GtmProblem problem : enumProblems) {
                    problem.setSourceContainer((IProblemUIContainer)this.enumCmb);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDisabledStateComboBoxStyle() {
        GtmEnumSetting gtmEnumSetting = this.enumSetting;
        synchronized (gtmEnumSetting) {
            List enumProblems = GtmController.getInstance().getProblemsManager().getProblemListForSource((IProblemSource)this.enumSetting);
            if (enumProblems.isEmpty()) {
                this.enumCmb.getStyleClass().remove((Object)"errorField");
            } else {
                if (!this.enumCmb.getStyleClass().contains((Object)"errorField")) {
                    this.enumCmb.getStyleClass().add((Object)"errorField");
                }
                for (GtmProblem problem : enumProblems) {
                    problem.setSourceContainer((IProblemUIContainer)this.enumCmb);
                }
            }
        }
    }

    public void create() {
        GtmConstraintsTable constraints = GtmController.getInstance().getGtmXmlConfig().getConstraints();
        this.enumSetting.checkConstraints(GtmController.getInstance().getGtmMcu(), constraints);
        this.enumCmb.setId(this.enumSetting.getId());
        Label enumSettingLabel = new Label();
        enumSettingLabel.setGraphic((Node)this.enumCmb);
        enumSettingLabel.setContentDisplay(ContentDisplay.RIGHT);
        enumSettingLabel.getStyleClass().add((Object)"default-c-style");
        enumSettingLabel.setText(this.enumSetting.getLabel());
        for (ItemSetting item : this.enumSetting.getItems()) {
            if (!item.isVisible() || item.isDisabled()) continue;
            this.items.add((Object)item.getLabel());
        }
        this.enumCmb.setItems(this.items);
        ItemSetting defaultSelectedItem = this.enumSetting.getItemById(this.enumSetting.getCurrentValue());
        if (defaultSelectedItem != null) {
            this.enumSetting.setCurrentSelection(defaultSelectedItem.getLabel());
            this.enumSetting.setCurrentValue(defaultSelectedItem.getId());
            this.enumCmb.getSelectionModel().select((Object)defaultSelectedItem.getLabel());
        }
        this.getChildren().add((Object)enumSettingLabel);
        this.getChildren().add((Object)this.enumCmb);
        UctLayoutUtils.registerListenerForControl((AUctController)GtmController.getInstance(), (IChildControl)this, (int)4);
        UctLayoutUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.enumSetting);
        GtmSceneCreator.getNodes().add((Node)this);
        GtmSceneCreator.getNodes().add((Node)this.enumCmb);
        GtmSceneCreator.getNodes().add((Node)enumSettingLabel);
        this.selectionHandle.attach();
        this.addRefreshListeners();
        GtmController.getInstance().addListener(1024, this.showProblemListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        GtmEnumSetting gtmEnumSetting = this.enumSetting;
        synchronized (gtmEnumSetting) {
            UctLayoutUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.enumSetting);
            this.updateEnumCmbItems();
            if (!this.enumCmb.getItems().isEmpty()) {
                this.enumCmb.setDisable(false);
                this.enumCmb.getSelectionModel().select((Object)this.enumSetting.getCurrentSelection().getLabel());
            } else {
                this.enumCmb.setDisable(true);
            }
            this.updateComboBoxfieldStyle();
        }
    }

    public void addRefreshListeners() {
        this.disableStateHandle.attach();
        this.selectionHandle.attach();
        this.validationStateHandle.attach();
        this.disableStateComboBoxStyleHandle.attach();
        for (ListenerHandle<Boolean> itemSettingHandle : this.itemsVisibleHandles) {
            itemSettingHandle.attach();
        }
        for (ListenerHandle<Boolean> itemSettingHandle : this.itemsDisableHandles) {
            itemSettingHandle.attach();
        }
    }

    public void removeRefreshListeners() {
        this.disableStateHandle.detach();
        this.selectionHandle.detach();
        this.validationStateHandle.detach();
        this.disableStateComboBoxStyleHandle.detach();
        for (ListenerHandle<Boolean> itemSettingHandle : this.itemsVisibleHandles) {
            itemSettingHandle.detach();
        }
        for (ListenerHandle<Boolean> itemSettingHandle : this.itemsDisableHandles) {
            itemSettingHandle.detach();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEnumCmbItems() {
        int idx = 0;
        Iterator iterator = this.enumSetting.getItems().iterator();
        while (iterator.hasNext()) {
            ItemSetting item;
            ItemSetting itemSetting = item = (ItemSetting)iterator.next();
            synchronized (itemSetting) {
                if ((item.isDisabled() || !item.isVisible()) && this.enumCmb.getItems().contains((Object)item.getLabel())) {
                    this.enumCmb.getItems().remove((Object)item.getLabel());
                } else if (item.isVisible() && !item.isDisabled()) {
                    if (!this.enumCmb.getItems().contains((Object)item.getLabel())) {
                        this.enumCmb.getItems().add(idx, (Object)item.getLabel());
                    }
                    ++idx;
                }
            }
        }
        if (this.enumCmb.getItems().isEmpty()) {
            this.enumCmb.getSelectionModel().clearSelection();
        }
    }

    public Parent getParentControl() {
        return this.parent;
    }

    public void setParentControl(Parent parent) {
        this.parent = parent;
    }

    private ChangeListener<String> createSelectionListener() {
        return (obs, oldValue, newValue) -> {
            if (newValue != null && !this.enumSetting.isDisabled() && !this.enumCmb.getItems().isEmpty()) {
                GtmController.getInstance().changeInCurrentPane();
                GtmEnumSetting gtmEnumSetting = this.enumSetting;
                synchronized (gtmEnumSetting) {
                    this.enumSetting.setCurrentSelection(newValue);
                    this.enumSetting.setCurrentValue(this.enumSetting.getCurrentSelection().getId());
                    StorageGtmUtils.updateStorageForComponent((Object)((Object)this), (ABaseUIComponentSetting)this.enumSetting);
                    this.refresh();
                }
                GtmController.getInstance().checkRemainingVisibleSettings();
                GtmController.getInstance().validate();
                GtmController.getInstance().updateConstraintsDeque();
            }
        };
    }

    private ChangeListener<Boolean> createBoolRefreshListener() {
        return (obs, oldValue, newValue) -> Platform.runLater((Runnable)((Object)new GtmRefreshTask((IBaseControl)this)));
    }

    private ChangeListener<Boolean> createIsValueValidComboBoxStyleListener() {
        return (obs, oldvalue, newValue) -> Platform.runLater((Runnable)((Object)new GtmUpdateComboBoxStyleTask(this)));
    }

    private ChangeListener<Boolean> createDisableComboBoxStyleListener() {
        return (obs, oldvalue, newValue) -> Platform.runLater((Runnable)((Object)new GtmUpdateDisabledStateComboBoxStyleTask(this)));
    }

    public ObservableList<String> getEnumCmbItems() {
        return this.items;
    }

    public ComboBox<String> getEnumCmb() {
        return this.enumCmb;
    }

    public void dispose() {
        this.selectionHandle.detach();
        this.removeRefreshListeners();
        UctLayoutUtils.removeListenerForControl((AUctController)GtmController.getInstance(), (IChildControl)this);
        GtmSceneCreator.getNodes().remove((Object)this);
        GtmSceneCreator.getNodes().remove((Object)this.enumCmb);
        this.items.clear();
        this.getChildren().clear();
    }

    protected @Nullable String getEnumSettingItemIdByLabel(@Nullable String label) {
        if (label == null) {
            return null;
        }
        for (ItemSetting item : this.enumSetting.getItems()) {
            if (!label.equals(item.getLabel())) continue;
            return item.getId();
        }
        return null;
    }

    public EnumSetting getEnumSetting() {
        return this.enumSetting;
    }
}

