/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.controls;

import com.nxp.swtools.common.uct.controller.AUctController;
import com.nxp.swtools.common.uct.controls.IBaseControl;
import com.nxp.swtools.common.uct.controls.IChildControl;
import com.nxp.swtools.common.uct.controls.IRefreshableBaseControl;
import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.BoolSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.SelectionSetting;
import com.nxp.swtools.common.uct.utils.UctLayoutUtils;
import com.nxp.swtools.gtm.controller.GtmController;
import com.nxp.swtools.gtm.controls.ListenerHandle;
import com.nxp.swtools.gtm.gui.GtmSceneCreator;
import com.nxp.swtools.gtm.gui.utils.GtmToolActions;
import com.nxp.swtools.gtm.tasks.GtmRefreshTask;
import com.nxp.swtools.gtml.controller.utils.StorageGtmUtils;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.CheckBox;
import org.eclipse.ui.services.IDisposable;

public class BoolSettingControl
extends CheckBox
implements IRefreshableBaseControl,
IChildControl,
IDisposable {
    private BoolSetting boolSetting;
    protected Parent parent;
    private ListenerHandle<Boolean> selectionHandle;
    private ListenerHandle<Boolean> disableStateHandle;
    private ListenerHandle<Boolean> visibleStateHandle;

    public BoolSettingControl(BoolSetting boolSetting, Parent parent) {
        this.boolSetting = boolSetting;
        this.parent = parent;
        this.selectionHandle = new ListenerHandle<Boolean>((ObservableValue<Boolean>)this.selectedProperty(), this.createSelectionListener());
        this.disableStateHandle = new ListenerHandle<Boolean>((ObservableValue<Boolean>)boolSetting.getDisabledProperty(), this.createBoolRefreshListener());
        this.visibleStateHandle = new ListenerHandle<Boolean>((ObservableValue<Boolean>)boolSetting.getVisibleProperty(), this.createBoolVisibleHandler());
        this.create();
    }

    public void create() {
        this.setId(this.boolSetting.getId());
        this.setMnemonicParsing(false);
        this.setText(this.boolSetting.getLabel());
        this.setSelected("true".equalsIgnoreCase(this.boolSetting.getCurrentValue()));
        this.getStyleClass().add((Object)"default-c-style");
        UctLayoutUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.boolSetting);
        UctLayoutUtils.registerListenerForControl((AUctController)GtmController.getInstance(), (IChildControl)this, (int)4);
        GtmSceneCreator.getNodes().add((Node)this);
        this.selectionHandle.attach();
        this.addRefreshListeners();
        this.visibleStateHandle.attach();
    }

    private ChangeListener<Boolean> createSelectionListener() {
        return (obs, wasOn, isNowOn) -> {
            GtmController.getInstance().changeInCurrentPane();
            BoolSetting boolSetting = this.boolSetting;
            synchronized (boolSetting) {
                String selectionSettingAction;
                String currentValue = this.isSelected() ? "true" : "false";
                this.boolSetting.setCurrentSelection(currentValue.equalsIgnoreCase("true"));
                this.boolSetting.setCurrentValue(currentValue);
                StorageGtmUtils.updateStorageForComponent((Object)((Object)this), (ABaseUIComponentSetting)this.boolSetting);
                SelectionSetting currentSelectionSetting = this.boolSetting.getCurrentSelectionSetting();
                if (currentSelectionSetting != null && !(selectionSettingAction = currentSelectionSetting.getAction()).isEmpty()) {
                    GtmToolActions.executeAction(selectionSettingAction);
                }
                this.refresh();
            }
            GtmController.getInstance().checkRemainingVisibleSettings();
            GtmController.getInstance().validate();
            GtmController.getInstance().updateConstraintsDeque();
        };
    }

    private ChangeListener<Boolean> createBoolRefreshListener() {
        return (obs, oldValue, newValue) -> Platform.runLater((Runnable)((Object)new GtmRefreshTask((IBaseControl)this)));
    }

    private ChangeListener<Boolean> createBoolVisibleHandler() {
        return (obs, wasVisible, isVisible) -> {
            SelectionSetting currentSelectionSetting = this.boolSetting.getSelectionSettingBasedOnValue(isVisible != false && Boolean.parseBoolean(this.boolSetting.getCurrentValue()));
            if (currentSelectionSetting != null) {
                GtmToolActions.executeAction(currentSelectionSetting.getAction());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        BoolSetting boolSetting = this.boolSetting;
        synchronized (boolSetting) {
            UctLayoutUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.boolSetting);
            boolean currentBoolSettingValue = this.boolSetting.getCurrentValue().equals("true");
            if (this.isSelected() != currentBoolSettingValue) {
                this.setSelected(currentBoolSettingValue);
            }
        }
    }

    public void addRefreshListeners() {
        this.disableStateHandle.attach();
    }

    public void removeRefreshListeners() {
        this.disableStateHandle.detach();
    }

    public Parent getParentControl() {
        return this.parent;
    }

    public void setParentControl(Parent parent) {
        this.parent = parent;
    }

    public void dispose() {
        this.selectionHandle.detach();
        this.removeRefreshListeners();
        this.visibleStateHandle.detach();
        UctLayoutUtils.removeListenerForControl((AUctController)GtmController.getInstance(), (IChildControl)this);
        GtmSceneCreator.getNodes().add((Node)this);
        this.getChildren().clear();
    }
}

