/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.condition;

import com.freescale.s32ds.cross.core.ProjectContextSettings;
import com.nxp.s32ds.cle.cdt.sdk.condition.ConditionCheck;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConditionCheckCores
implements ConditionCheck {
    public static final String CONDITION_CHECK_CORES_ATTRIBUTE = "cores";
    private final Set<String> deviceCoreIds;

    ConditionCheckCores(Element conditionCheckElement) {
        this.deviceCoreIds = Arrays.stream(conditionCheckElement.getAttribute(CONDITION_CHECK_CORES_ATTRIBUTE).split(",")).map(String::trim).filter(deviceCoreId -> !deviceCoreId.isEmpty()).collect(Collectors.toSet());
    }

    public boolean check(Object checkCondition) {
        if (checkCondition instanceof IConfiguration) {
            IProject project = ((IConfiguration)checkCondition).getOwner().getProject();
            String projectDeviceCoreId = new ProjectContextSettings(project).getAttributeByKey("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id");
            return this.deviceCoreIds.isEmpty() || projectDeviceCoreId.isEmpty() || this.deviceCoreIds.contains(projectDeviceCoreId);
        }
        return false;
    }

    public void convertToXml(Document document, Element conditionElement) {
        Element checkElement = document.createElement("check");
        checkElement.setAttribute(CONDITION_CHECK_CORES_ATTRIBUTE, String.join((CharSequence)",", this.deviceCoreIds));
        conditionElement.appendChild(checkElement);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.deviceCoreIds == null ? 0 : this.deviceCoreIds.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionCheckCores)) {
            return false;
        }
        ConditionCheckCores other = (ConditionCheckCores)obj;
        return !(this.deviceCoreIds == null ? other.deviceCoreIds != null : !this.deviceCoreIds.equals(other.deviceCoreIds));
    }
}

