/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.action;

import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.ProjectSettingsUpdater;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.ProjectSettingsUpdaters;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.SettingsUpdateData;
import com.nxp.s32ds.cle.cdt.sdk.action.SdkAction;
import com.nxp.s32ds.cle.cdt.sdk.action.SdkActionsExecutionPoint;
import com.nxp.s32ds.cle.cdt.sdk.action.SdkActionsExecutionPointStep;
import com.nxp.s32ds.cle.cdt.sdk.action.SdkActionsGroup;
import com.nxp.s32ds.cle.cdt.sdk.action.SdkActionsHolder;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.MessageAction;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.ProjectBuilderAttributeAction;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.ProjectLaunchConfigurationAction;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.ProjectOptionCleanupAction;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.ProjectOptionUpdateAction;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.ProjectOptionValidateAction;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.resource.ProjectResourceBuildPathExcludeAction;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.resource.ProjectResourceBuildPathIncludeAction;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.resource.ProjectResourceFileBackupAction;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.resource.ProjectResourceFileRemoveAction;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.resource.ProjectResourceFolderBackupAction;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.resource.ProjectResourceFolderCleanupAction;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.resource.ProjectResourceFolderCreateAction;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.resource.ProjectResourceFolderRemoveAction;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.variable.VariablesHelper;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.load.variable.VariablesHolder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SdkActionsGroupImpl
implements SdkActionsGroup {
    private SdkActionsHolder actionsHolder;
    private SdkActionsExecutionPointStep executionPointStep;
    private Set<String> configurationIds;
    private Set<SdkAction> optionUpdateActions = new LinkedHashSet<SdkAction>();
    private Set<SdkAction> launchUpdateActions = new LinkedHashSet<SdkAction>();
    private Set<SdkAction> actions = new LinkedHashSet<SdkAction>();
    private SdkActionsExecutionPoint executionPoint;

    public SdkActionsGroupImpl() {
        this.configurationIds = new HashSet<String>();
    }

    public SdkActionsGroupImpl(SdkActionsHolder actionsHolder, Element actionsElement, VariablesHolder sdkVariables) {
        this();
        this.actionsHolder = actionsHolder;
        VariablesHelper.performSdkVariablesSubstitution(actionsElement, sdkVariables);
        this.initialize(actionsElement, sdkVariables);
    }

    public SdkActionsGroupImpl(SdkActionsExecutionPoint executionPoint, SdkActionsExecutionPointStep executionPointStep) {
        this();
        this.executionPoint = executionPoint;
        this.executionPointStep = executionPointStep;
    }

    public void addAction(SdkAction action) {
        if (action instanceof ProjectOptionUpdateAction) {
            this.optionUpdateActions.add(action);
        } else if (action instanceof ProjectLaunchConfigurationAction) {
            this.launchUpdateActions.add(action);
        } else {
            this.actions.add(action);
        }
    }

    public Set<String> getConfigurationIds() {
        return Collections.unmodifiableSet(this.configurationIds);
    }

    public SdkActionsExecutionPointStep getExecutionPointStep() {
        return this.executionPointStep;
    }

    public SdkActionsExecutionPoint getExecutionPoint() {
        return this.executionPoint;
    }

    public IStatus execute(IProject project, IConfiguration configuration) {
        MultiStatus result = new MultiStatus("com.nxp.s32ds.cle.cdt.sdk.core", 0, "", null);
        result.addAll((IStatus)this.executeOptionUpdateActions(configuration));
        result.addAll((IStatus)this.executeLaunchUpdateActions(configuration));
        this.actions.stream().filter(action -> action.isApplicable(configuration)).forEach(action -> result.add(SdkActionsGroupImpl.executeAction(action, project, configuration)));
        return result;
    }

    public void convertToXml(Document document, Element holderActionsElement) {
        Element actionsElement = null;
        switch (this.executionPoint) {
            case ONLOAD: {
                actionsElement = document.createElement("onloadActions");
                break;
            }
            case ATTACH: {
                actionsElement = document.createElement("attachActions");
                break;
            }
            case DETACH: {
                actionsElement = document.createElement("detachActions");
            }
        }
        if (actionsElement != null) {
            actionsElement.setAttribute("executionStep", this.executionPointStep.getAttributeValue());
            for (SdkAction action : this.optionUpdateActions) {
                action.convertToXml(document, actionsElement);
            }
            for (SdkAction action : this.actions) {
                action.convertToXml(document, actionsElement);
            }
            holderActionsElement.appendChild(actionsElement);
        }
    }

    private void initialize(Element actionsElement, VariablesHolder sdkVariables) {
        this.executionPoint = Objects.requireNonNull(SdkActionsExecutionPoint.getExecutionPoint((String)actionsElement.getNodeName()));
        String executionStep = actionsElement.getAttribute("executionStep");
        this.executionPointStep = Objects.requireNonNull(SdkActionsExecutionPointStep.getExecutionStep((String)executionStep), NLS.bind((String)"Unsupported attribute {0} value: {1}.", (Object)"executionStep", (Object)executionStep));
        this.configurationIds = Arrays.stream(actionsElement.getAttribute("configId").split(",")).map(String::trim).collect(Collectors.toSet());
        NodeList actionElements = actionsElement.getChildNodes();
        int i = 0;
        while (i < actionElements.getLength()) {
            block63: {
                Node actionNode = actionElements.item(i);
                if (!(actionNode instanceof Element)) break block63;
                Element actionElement = (Element)actionNode;
                VariablesHelper.performSdkVariablesSubstitution(actionElement, sdkVariables);
                actionElement.setUserData("action_holder", this.actionsHolder, null);
                switch (actionElement.getNodeName()) {
                    case "createProjectFolder": {
                        this.addAction(new ProjectResourceFolderCreateAction(actionElement));
                        break;
                    }
                    case "removeProjectFolder": {
                        this.addAction(new ProjectResourceFolderRemoveAction(actionElement));
                        break;
                    }
                    case "cleanupProjectFolder": {
                        this.addAction(new ProjectResourceFolderCleanupAction(actionElement));
                        break;
                    }
                    case "backupProjectFolder": {
                        this.addAction(new ProjectResourceFolderBackupAction(actionElement));
                        break;
                    }
                    case "removeProjectFile": {
                        this.addAction(new ProjectResourceFileRemoveAction(actionElement));
                        break;
                    }
                    case "backupProjectFile": {
                        this.addAction(new ProjectResourceFileBackupAction(actionElement));
                        break;
                    }
                    case "includeProjectFolderToBuildPath": 
                    case "includeProjectFileToBuildPath": {
                        this.addAction(new ProjectResourceBuildPathIncludeAction(actionElement));
                        break;
                    }
                    case "excludeProjectFolderFromBuildPath": 
                    case "excludeProjectFileFromBuildPath": {
                        this.addAction(new ProjectResourceBuildPathExcludeAction(actionElement));
                        break;
                    }
                    case "addOptionValue": 
                    case "setOptionValue": 
                    case "removeOptionValue": {
                        this.addAction(new ProjectOptionUpdateAction(actionElement));
                        break;
                    }
                    case "cleanupOptionValue": {
                        this.addAction(new ProjectOptionCleanupAction(actionElement));
                        break;
                    }
                    case "checkOptionValue": {
                        this.addAction(new ProjectOptionValidateAction(actionElement, sdkVariables));
                        break;
                    }
                    case "message": {
                        this.addAction(new MessageAction(actionElement));
                        break;
                    }
                    case "cleanupLaunchValue": 
                    case "addLaunchValue": 
                    case "setLaunchValue": 
                    case "removeLaunchValue": {
                        this.addAction(new ProjectLaunchConfigurationAction(actionElement));
                        break;
                    }
                    case "setBuilderAttribute": 
                    case "cleanupBuilderAttribute": {
                        this.addAction(new ProjectBuilderAttributeAction(actionElement));
                    }
                }
            }
            ++i;
        }
    }

    private static IStatus executeAction(SdkAction action, IProject project, IConfiguration configuration) {
        IStatus preExecuteStatus = action.preExecute(project, configuration);
        if (preExecuteStatus.isOK()) {
            IStatus executeStatus = action.execute(project, configuration);
            action.postExecute(project, configuration);
            return executeStatus;
        }
        return preExecuteStatus;
    }

    private MultiStatus executeOptionUpdateActions(IConfiguration configuration) {
        MultiStatus result = new MultiStatus("com.nxp.s32ds.cle.cdt.sdk.core", 0, "", null);
        LinkedHashSet optionsUpdateData = new LinkedHashSet();
        this.optionUpdateActions.stream().filter(action -> action.isApplicable(configuration)).forEach(action -> {
            boolean bl = optionsUpdateData.add(SdkActionsGroupImpl.newOptionUpdateOperationData((ProjectOptionUpdateAction)action));
        });
        if (!optionsUpdateData.isEmpty()) {
            ProjectSettingsUpdater optionUpdater = ProjectSettingsUpdaters.getOptionUpdater();
            result.addAll(optionUpdater.update(configuration, optionsUpdateData));
        }
        return result;
    }

    private MultiStatus executeLaunchUpdateActions(IConfiguration configuration) {
        MultiStatus result = new MultiStatus("com.nxp.s32ds.cle.cdt.sdk.core", 0, "", null);
        if (configuration != null) {
            IProject project = configuration.getOwner().getProject();
            this.launchUpdateActions.forEach(action -> result.addAll(action.execute(project, configuration)));
        }
        return result;
    }

    private static SettingsUpdateData newOptionUpdateOperationData(ProjectOptionUpdateAction action) {
        return new SettingsUpdateData(action.getOptionId(), action.getOptionValue(), action.getUpdateOperation(action.operation));
    }
}

