/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.filtering;

import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.filtering.SdkFilter;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkVersion;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkType;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class LatestSdkVersionFilter
implements SdkFilter {
    private Map<String, TreeSet<SdkVersion>> sdkVersions;
    private final boolean isGlobal;
    private SdkFilter preFilter;

    public LatestSdkVersionFilter() {
        this(false);
    }

    public LatestSdkVersionFilter(SdkFilter preFilter) {
        this(false);
        this.preFilter = preFilter;
    }

    public LatestSdkVersionFilter(boolean onlyGlobal) {
        this.isGlobal = onlyGlobal;
    }

    public boolean accept(SdkDescriptor sdkDescriptor) {
        TreeSet<SdkVersion> versions = this.getSDKVersions().get(LatestSdkVersionFilter.getVerionsMapKey(sdkDescriptor));
        return versions != null && versions.last().equals(SdkVersion.createVersion(sdkDescriptor.getVersion())) && (!this.isGlobal || SdkType.PROJECT_LOCAL != sdkDescriptor.getType());
    }

    private Map<String, TreeSet<SdkVersion>> getSDKVersions() {
        if (this.sdkVersions == null) {
            this.sdkVersions = new HashMap<String, TreeSet<SdkVersion>>();
            if (this.preFilter != null) {
                SdkManagementUtils.getFilteredSdks(this.preFilter).forEach(this::addVersion);
            } else {
                SdkManagementUtils.getFilteredSdks(sdk -> true).forEach(this::addVersion);
            }
        }
        return this.sdkVersions;
    }

    private void addVersion(SdkDescriptor sdkDescriptor) {
        String key = LatestSdkVersionFilter.getVerionsMapKey(sdkDescriptor);
        TreeSet<SdkVersion> versions = this.sdkVersions.get(key);
        if (versions == null) {
            versions = new TreeSet();
        }
        versions.add(SdkVersion.createVersion(sdkDescriptor.getVersion()));
        this.sdkVersions.put(key, versions);
    }

    private static String getVerionsMapKey(SdkDescriptor sdkDescriptor) {
        return String.valueOf(sdkDescriptor.getName().toLowerCase()) + "@" + sdkDescriptor.getType();
    }
}

