/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.action;

import com.nxp.s32ds.cle.cdt.sdk.action.SdkActionsHolder;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SdkActionsHandler {
    public static final SdkActionsHandler INSTANCE = new SdkActionsHandler();
    private Map<String, List<SdkActionsHolder>> sdkActions = new HashMap<String, List<SdkActionsHolder>>();

    private SdkActionsHandler() {
    }

    public IStatus executeOnloadActions(String sdkId, IProject project, boolean isPreOnload) {
        MultiStatus result = SdkCoreActivator.getInstance().createMultiStatus();
        List<SdkActionsHolder> actionsHolders = this.sdkActions.get(sdkId);
        if (actionsHolders != null) {
            actionsHolders.forEach(ah -> result.addAll(ah.executeOnLoadActions(project, null, isPreOnload)));
        }
        return result;
    }

    public IStatus executeAttachActions(String sdkId, IProject project, IConfiguration configuration, boolean isPreAttach) {
        MultiStatus result = SdkCoreActivator.getInstance().createMultiStatus();
        this.getActionsHolders(sdkId, configuration).forEach(ah -> result.addAll((IStatus)SdkActionsHandler.executeAttachActions(project, configuration, ah, isPreAttach)));
        return result;
    }

    public IStatus executeDetachActions(String sdkId, IProject project, IConfiguration configuration, boolean isPreDetach) {
        MultiStatus result = SdkCoreActivator.getInstance().createMultiStatus();
        this.getActionsHolders(sdkId, configuration).forEach(ah -> result.addAll((IStatus)SdkActionsHandler.executeDetachActions(project, configuration, ah, isPreDetach)));
        return result;
    }

    public IStatus executeAttachActions(String sdkId, IProject project, Iterable<IConfiguration> configurations, boolean isPreAttach) {
        if (configurations == null || !configurations.iterator().hasNext()) {
            return Status.CANCEL_STATUS;
        }
        MultiStatus result = SdkCoreActivator.getInstance().createMultiStatus();
        configurations.forEach(config -> {
            List<SdkActionsHolder> compatibleHolders = this.getActionsHolders(sdkId, (IConfiguration)config);
            compatibleHolders.forEach(actionsHolder -> {
                MultiStatus executeStatuses = SdkActionsHandler.executeAttachActions(project, config, actionsHolder, isPreAttach);
                result.addAll((IStatus)executeStatuses);
            });
        });
        return result;
    }

    public IStatus executeDetachActions(String sdkId, IProject project, Iterable<IConfiguration> configurations, boolean isPreDetach) {
        if (configurations == null || !configurations.iterator().hasNext()) {
            return Status.CANCEL_STATUS;
        }
        MultiStatus result = SdkCoreActivator.getInstance().createMultiStatus();
        this.getActionsHolders(sdkId, configurations.iterator().next()).forEach(ah -> configurations.forEach(config -> result.addAll((IStatus)SdkActionsHandler.executeDetachActions(project, config, ah, isPreDetach))));
        return result;
    }

    public IStatus registerSdkActions(String sdkId, SdkActionsHolder actionsHolder) {
        if (actionsHolder != null && !actionsHolder.isEmpty()) {
            this.sdkActions.computeIfAbsent(sdkId, s -> new ArrayList()).add(actionsHolder);
            String message = NLS.bind((String)Messages.SdkActionsHandler_success_register_sdk_actions, (Object)sdkId);
            SdkCoreActivator.getInstance().logDebugInfo(message);
            return SdkCoreActivator.getInstance().createStatus(0, message);
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus unregisterSdkActions(String sdkId) {
        if (!this.sdkActions.isEmpty() && this.sdkActions.remove(sdkId) != null) {
            String message = NLS.bind((String)Messages.SdkActionsHandler_success_unregister_sdk_actions, (Object)sdkId);
            SdkCoreActivator.getInstance().logDebugInfo(message);
            return SdkCoreActivator.getInstance().createStatus(0, message);
        }
        return Status.CANCEL_STATUS;
    }

    public void convertToXml(String sdkId, String toolChainId, Document document, Element holderElement) {
        List<SdkActionsHolder> actionsHolders = this.sdkActions.get(sdkId);
        if (actionsHolders != null) {
            actionsHolders.stream().filter(actionsHolder -> SdkActionsHandler.isHolderHasSameToolChain(toolChainId, actionsHolder)).forEach(ah -> ah.convertToXml(document, holderElement));
        }
    }

    private static MultiStatus executeAttachActions(IProject project, IConfiguration configuration, SdkActionsHolder actionsHolder, boolean isPreAttach) {
        MultiStatus result = SdkCoreActivator.getInstance().createMultiStatus();
        result.addAll(actionsHolder.executeAttachActions(project, configuration, isPreAttach));
        return result;
    }

    private static MultiStatus executeDetachActions(IProject project, IConfiguration configuration, SdkActionsHolder actionsHolder, boolean isPreDetach) {
        MultiStatus result = SdkCoreActivator.getInstance().createMultiStatus();
        result.addAll(actionsHolder.executeDetachActions(project, configuration, isPreDetach));
        return result;
    }

    private List<SdkActionsHolder> getActionsHolders(String sdkId, IConfiguration configuration) {
        List<SdkActionsHolder> actionsHolders = this.sdkActions.get(sdkId);
        if (actionsHolders != null) {
            LinkedHashSet<String> toolChainsIds = new LinkedHashSet<String>();
            IToolChain toolChain = configuration.getToolChain();
            while (toolChain != null) {
                toolChainsIds.add(toolChain.getBaseId());
                toolChain = toolChain.getSuperClass();
            }
            return actionsHolders.stream().filter(actionHolder -> SdkActionsHandler.isHolderCompatibleWithToolChain(toolChainsIds, actionHolder)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static boolean isHolderCompatibleWithToolChain(Set<String> toolChainsIds, SdkActionsHolder actionsHolder) {
        String holderToolChainId = actionsHolder.getToolChainId();
        if (holderToolChainId != null) {
            if (!toolChainsIds.stream().anyMatch(holderToolChainId::equals)) {
                return false;
            }
        }
        return true;
    }

    private static boolean isHolderHasSameToolChain(String toolChainId, SdkActionsHolder actionsHolder) {
        String holderToolChainId = actionsHolder.getToolChainId();
        if (holderToolChainId == null) {
            return toolChainId == null;
        }
        if (toolChainId == null) {
            return holderToolChainId == null;
        }
        return holderToolChainId.equals(toolChainId);
    }
}

