/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.modular.internal;

import com.nxp.s32ds.ext.rcp.compatibility.data.registry.Archetype;
import com.nxp.s32ds.ext.rcp.compatibility.data.registry.CompatibilitiesDataDescriptor;
import com.nxp.s32ds.ext.rcp.compatibility.data.registry.CompatibilitiesDataRegistry;
import com.nxp.s32ds.ext.rcp.compatibility.data.registry.core.CompatibilitiesData;
import com.nxp.s32ds.rcp.modular.ModularPack;
import com.nxp.s32ds.rcp.modular.ModularPackageCompatibleCategories;
import java.util.Set;
import java.util.function.Predicate;

public final class CompatibilitiesModularUtils {
    private CompatibilitiesModularUtils() {
    }

    public static boolean isCompatiblePackForPlatform(ModularPack modularPack) {
        CompatibilitiesDataRegistry compatibilitiesDataRegistry = CompatibilitiesData.getCompatibilitiesDataRegistry();
        return compatibilitiesDataRegistry.getAllArchetypes().stream().filter(CompatibilitiesModularUtils.filterArchetype()).findAny().map(arch -> CompatibilitiesModularUtils.comparePlatformAttributes(compatibilitiesDataRegistry, modularPack, arch)).orElse(false);
    }

    private static Predicate<Archetype> filterArchetype() {
        return arch -> "s32ds.archetypes.mi.packs".equals(arch.getId());
    }

    private static boolean comparePlatformAttributes(CompatibilitiesDataRegistry compatibilitiesDataRegistry, ModularPack modularPack, Archetype arch) {
        return compatibilitiesDataRegistry.getCompatibilitiesDataDescriptorForArchetype(arch).stream().filter(CompatibilitiesModularUtils.filterPack(modularPack)).findAny().map(p -> true).orElse(false);
    }

    private static Predicate<CompatibilitiesDataDescriptor> filterPack(ModularPack modularPack) {
        return data -> data.getId().equals(modularPack.getId()) && data.getVersion().equals(modularPack.getVersion());
    }

    public static Set<String> getCompatibleCategories(ModularPack modularPack) {
        return ModularPackageCompatibleCategories.getRegistry().getCategoriesByModularPackageId(modularPack.getId());
    }
}

