/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.runtime.ui;

import com.nxp.s32ds.ext.rcp.runtime.RcpBundle;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.BundleContext;

public abstract class RcpUIBundle
extends RcpBundle {
    protected UIPlugin uiPlugin = null;
    private ScopedPreferenceStore preferenceStore;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.uiPlugin = new UIPlugin();
        this.uiPlugin.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.uiPlugin.stop(context);
        this.uiPlugin = null;
    }

    public IDialogSettings getDialogSettings() {
        return this.uiPlugin.getDialogSettings();
    }

    public Image getImage(String key) {
        Image image = this.getImageRegistry().get(key);
        if (image != null) {
            return image;
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
    }

    public void putImage(String key, Image image) throws IllegalArgumentException {
        this.getImageRegistry().put(key, image);
    }

    public void removeImage(String key) {
        this.getImageRegistry().remove(key);
    }

    public ImageDescriptor getImageDescriptor(String key) {
        return this.getImageRegistry().getDescriptor(key);
    }

    public ScopedPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            this.preferenceStore = this.createPreferenceStore();
        }
        return this.preferenceStore;
    }

    protected ScopedPreferenceStore createPreferenceStore() {
        return new ScopedPreferenceStore(InstanceScope.INSTANCE, this.getBundleId());
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
    }

    protected ImageRegistry getImageRegistry() {
        return this.uiPlugin.getImageRegistry();
    }

    private class UIPlugin
    extends AbstractUIPlugin {
        private UIPlugin() {
        }

        protected void initializeImageRegistry(ImageRegistry reg) {
            RcpUIBundle.this.initializeImageRegistry(reg);
        }
    }
}

