/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.sdk.core;

import com.nxp.s32ds.cle.ide.internal.sdk.core.IdeSdkCoreActivator;
import com.nxp.s32ds.cle.ide.internal.sdk.core.Messages;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;

public class MissedSdkMarker {
    public static final String MISSED_SDK_MARKER_TYPE = "com.nxp.s32ds.cle.ide.sdk.MissedSdkMarker";
    private static final String MISSED_SDK_ID_ATTRIBUTE = "sdkId";
    private static final String MISSED_SDK_NAME_ATTRIBUTE = "sdkName";

    private MissedSdkMarker() {
    }

    public static void create(String missedSdkId, IProject project, String message) {
        try {
            IMarker marker = project.createMarker(MISSED_SDK_MARKER_TYPE);
            marker.setAttribute("severity", 2);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("location", (Object)project);
            marker.setAttribute(MISSED_SDK_ID_ATTRIBUTE, (Object)missedSdkId);
        }
        catch (CoreException ce) {
            IdeSdkCoreActivator.getInstance().logError(ce.getMessage());
        }
    }

    public static void create(String missedSdkId, IProject project) {
        try {
            IMarker marker = project.createMarker(MISSED_SDK_MARKER_TYPE);
            marker.setAttribute("severity", 2);
            marker.setAttribute("message", (Object)NLS.bind((String)Messages.MissedSdkMarkerHandler_attached_sdk_not_found_message, (Object)missedSdkId, (Object)project.getName()));
            marker.setAttribute("location", (Object)project);
            marker.setAttribute(MISSED_SDK_NAME_ATTRIBUTE, (Object)missedSdkId);
        }
        catch (CoreException ce) {
            IdeSdkCoreActivator.getInstance().logError(ce.getMessage());
        }
    }

    public static void delete(IProject project) {
        try {
            project.deleteMarkers(MISSED_SDK_MARKER_TYPE, false, 0);
        }
        catch (CoreException ce) {
            IdeSdkCoreActivator.getInstance().logError(ce.getMessage());
        }
    }
}

