/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.query;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.dependencies.DependencyQueryAnnotation;
import com.nxp.swtools.provider.configuration.dependencies.DependencyQueryResult;
import com.nxp.swtools.provider.configuration.dependencies.DependencyResourceAnotation;
import com.nxp.swtools.provider.configuration.dependencies.IDependencyQuery;
import com.nxp.swtools.provider.configuration.dependencies.IDependencyQueryResult;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.query.FrameworkTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

@DependencyQueryAnnotation(resources={@DependencyResourceAnotation(resourceType="CPUCore", features={"count", "name", "id", "exists", "master"})})
public class CPUCoreQuery
implements IDependencyQuery {
    private static final Logger LOGGER = LogManager.getLogger(CPUCoreQuery.class);

    @Override
    public Collection<IDependencyQueryResult> query(ISharedConfiguration configuration, String resourceType, String resourceId, String featureName) {
        ArrayList<@NonNull IDependencyQueryResult> result = new ArrayList<IDependencyQueryResult>();
        if (configuration.isEmpty()) {
            LOGGER.warning("GeneralConfigQuery asked for empty configuration.");
            return result;
        }
        FrameworkTool frameworkTool = FrameworkTool.getInstance();
        if ("CPUCore".equalsIgnoreCase(resourceType)) {
            if ("count".equalsIgnoreCase(featureName)) {
                DependencyQueryResult answer = new DependencyQueryResult(configuration.getCommonConfig().getCores().size(), frameworkTool, frameworkTool.getGlobalConfiguration());
                result.add(answer);
            } else if ("master".equalsIgnoreCase(featureName)) {
                String id = null;
                for (ProcessorCore core : configuration.getCommonConfig().getCores()) {
                    if (!core.isMaster()) continue;
                    id = core.getID();
                    break;
                }
                DependencyQueryResult answer = new DependencyQueryResult(id, frameworkTool, frameworkTool.getGlobalConfiguration());
                result.add(answer);
            } else if ("name".equalsIgnoreCase(featureName)) {
                ProcessorCore core = configuration.getCommonConfig().findCore(resourceId);
                String val = core != null ? core.getName() : null;
                DependencyQueryResult answer = new DependencyQueryResult(val, frameworkTool, frameworkTool.getGlobalConfiguration());
                result.add(answer);
            } else if ("id".equalsIgnoreCase(featureName)) {
                int index = Integer.parseInt(resourceId);
                ArrayList<ProcessorCore> list = new ArrayList<ProcessorCore>(configuration.getCommonConfig().getCores());
                String val = null;
                if (index < 0 || index >= list.size()) {
                    LOGGER.log(Level.WARNING, "Searching for processor core out of index {0}", resourceId);
                } else {
                    ProcessorCore core = list.get(index);
                    val = core.getID();
                }
                DependencyQueryResult answer = new DependencyQueryResult(val, frameworkTool, frameworkTool.getGlobalConfiguration());
                result.add(answer);
            } else if ("exists".equalsIgnoreCase(featureName)) {
                ProcessorCore core = configuration.getCommonConfig().findCore(resourceId);
                DependencyQueryResult answer = new DependencyQueryResult(core != null, frameworkTool, frameworkTool.getGlobalConfiguration());
                result.add(answer);
            }
        } else {
            LOGGER.log(Level.SEVERE, "Unknown resourceType {0}", resourceType);
        }
        return result;
    }
}

