/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.query;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.configuration.SwToolsProductConfiguration;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.dependencies.DependencyQueryAnnotation;
import com.nxp.swtools.provider.configuration.dependencies.DependencyQueryResult;
import com.nxp.swtools.provider.configuration.dependencies.DependencyResourceAnotation;
import com.nxp.swtools.provider.configuration.dependencies.IDependencyQuery;
import com.nxp.swtools.provider.configuration.dependencies.IDependencyQueryResult;
import com.nxp.swtools.provider.processors.KExProcessorsProvider;
import com.nxp.swtools.provider.query.FrameworkTool;
import com.nxp.swtools.provider.query.GeneralConfigQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

@DependencyQueryAnnotation(resources={@DependencyResourceAnotation(resourceType="Application", features={"version", "id"}), @DependencyResourceAnotation(resourceType="Tool", features={"version"})})
public class ApplicationQuery
implements IDependencyQuery {
    private static final Logger LOGGER = LogManager.getLogger(GeneralConfigQuery.class);

    @Override
    public Collection<IDependencyQueryResult> query(ISharedConfiguration configuration, String resourceType, String resourceId, String featureName) {
        ArrayList<@NonNull IDependencyQueryResult> result = new ArrayList<IDependencyQueryResult>();
        FrameworkTool frameworkTool = FrameworkTool.getInstance();
        if ("Application".equalsIgnoreCase(resourceType)) {
            if ("version".equalsIgnoreCase(featureName)) {
                Bundle bundle;
                IProduct product = Platform.getProduct();
                Version val = null;
                if (product != null && (bundle = product.getDefiningBundle()) != null) {
                    val = Version.parseVersion((String)SwToolsProduct.getProductVersion((IProduct)product, (Bundle)bundle));
                }
                DependencyQueryResult answer = new DependencyQueryResult(val, frameworkTool, frameworkTool.getGlobalConfiguration());
                result.add(answer);
            } else if ("id".equalsIgnoreCase(featureName)) {
                String val = KExProcessorsProvider.getProductForProcessorFilter();
                DependencyQueryResult answer = new DependencyQueryResult(val, frameworkTool, frameworkTool.getGlobalConfiguration());
                result.add(answer);
            }
        } else if ("Tool".equalsIgnoreCase(resourceType) && "version".equalsIgnoreCase(featureName)) {
            SwToolsProduct toolProduct = SwToolsProductConfiguration.getRegisteredProduct((String)resourceId);
            if (toolProduct == null) {
                LOGGER.log(Level.WARNING, "Tool ID not found: {0}", resourceId);
            } else {
                DependencyQueryResult answer = new DependencyQueryResult(Version.parseVersion((String)toolProduct.getVersion()), frameworkTool, frameworkTool.getGlobalConfiguration());
                result.add(answer);
            }
        }
        return result;
    }
}

