/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.quadspi;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.yaml.YamlConfigProperty;
import com.nxp.swtools.common.utils.yaml.YamlConfiguration;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.configuration.SwToolsProductConfiguration;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.provider.configuration.storage.StorageToolBaseConfiguration;
import com.nxp.swtools.provider.configuration.storage.quadspi.StorageQuadSPIProfile;
import com.nxp.swtools.provider.configuration.storage.quadspi.StorageQuadSPIRecords;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(name="quadspi", strict=false)
@YamlConfiguration(properties={@YamlConfigProperty(name="dependencies", ignore=true), @YamlConfigProperty(name="update_project_code", ignore=true)})
public class StorageQuadSPITool
extends StorageTool {
    public static final String QUADSPI_TOOL_VERSION;
    @Element(name="quadspi_profile", required=false)
    private StorageQuadSPIProfile quadSpiProfile = new StorageQuadSPIProfile();
    @Element(name="quadspi_records", required=false)
    @Nullable
    private @Element(name="quadspi_records", required=false) @Nullable StorageQuadSPIRecords quadSpiRecords;

    static {
        SwToolsProduct quadspi = SwToolsProductConfiguration.getRegisteredProduct((String)"QuadSPI");
        QUADSPI_TOOL_VERSION = quadspi != null ? quadspi.getVersion() : "";
    }

    public StorageQuadSPITool() {
        super("QuadSPI", QUADSPI_TOOL_VERSION);
    }

    public StorageQuadSPIProfile getQuadSPIProfile() {
        return this.quadSpiProfile;
    }

    public void setQuadSPIProfile(StorageQuadSPIProfile quadSpiProfile) {
        this.quadSpiProfile = quadSpiProfile;
    }

    public @Nullable StorageQuadSPIRecords getQuadSPIRecords() {
        return this.quadSpiRecords;
    }

    public void setQuadSPIRecords(StorageQuadSPIRecords quadSpiRecords) {
        this.quadSpiRecords = quadSpiRecords;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return super.equals(obj);
    }

    @Override
    public boolean equals(@Nullable StorageTool other, @NonNull StorageTool.CompareMode mode) {
        if (other == this) {
            return true;
        }
        if (!super.equals(other, mode)) {
            return false;
        }
        if (!(other instanceof StorageQuadSPITool)) {
            return false;
        }
        StorageQuadSPITool objTool = (StorageQuadSPITool)other;
        StorageQuadSPIRecords currentQuadSpiRecords = this.quadSpiRecords;
        if (!this.quadSpiProfile.equals(objTool.quadSpiProfile)) {
            return false;
        }
        return currentQuadSpiRecords != null && currentQuadSpiRecords.equals(objTool.quadSpiRecords);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = result * 31 + this.quadSpiProfile.hashCode();
        StorageQuadSPIRecords currentQuadSPIRecords = this.quadSpiRecords;
        if (currentQuadSPIRecords != null) {
            result = result * 31 + currentQuadSPIRecords.hashCode();
        }
        return result;
    }

    @Override
    public @Nullable List<? extends @NonNull StorageToolBaseConfiguration> getFunctionalGroups() {
        return null;
    }
}

