/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.pins;

import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;

@NonNullByDefault
@Root(strict=false, name="external_user_signal")
public class StorageExternalUserSignal {
    @Attribute(name="id", required=true)
    protected String id;
    @ElementList(name="pin_connections", entry="pin", required=false)
    protected ArrayList<String> pinConnections = new ArrayList();
    @ElementList(name="property_values", entry="value", required=false)
    protected ArrayList<String> propertyValues = new ArrayList();

    StorageExternalUserSignal() {
        this.id = "";
    }

    public StorageExternalUserSignal(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<String> getPinConnections() {
        return this.pinConnections;
    }

    public void setPinConnections(List<String> pins) {
        this.pinConnections = new ArrayList<String>(pins);
    }

    public List<String> getPropertyValues() {
        return this.propertyValues;
    }

    public void setPropertyValues(List<String> propertyValues) {
        this.propertyValues = new ArrayList<String>(propertyValues);
    }

    public void addPropertyValue(String value) {
        this.propertyValues.add(value);
    }

    public String getPropertyValue(int indexOf) {
        return this.propertyValues.get(indexOf);
    }

    public void removePropertyValue(int index) {
        this.propertyValues.remove(index);
    }

    public void setPropertyValue(int indexOf, String value) {
        this.propertyValues.set(indexOf, value);
    }

    public void addPinConnection(String coords) {
        this.pinConnections.add(coords);
    }

    public void removePinConnection(String coords) {
        this.pinConnections.remove(coords);
    }

    @Commit
    private void fixNullPropertyValues() {
        int i = 0;
        while (i < this.propertyValues.size()) {
            if (this.propertyValues.get(i) == null) {
                this.propertyValues.set(i, "");
            }
            ++i;
        }
    }

    public String toString() {
        return "StorageExternalUserSignal [id=" + this.id + ", pinConnections=" + this.pinConnections + ", propertyValues=" + this.propertyValues + "]";
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageExternalUserSignal other = (StorageExternalUserSignal)obj;
        if (!this.id.equals(other.id)) {
            return false;
        }
        if (!Objects.equals(this.pinConnections, other.pinConnections)) {
            return false;
        }
        return Objects.equals(this.propertyValues, other.propertyValues);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + Objects.hashCode(this.pinConnections);
        result = 31 * result + Objects.hashCode(this.propertyValues);
        return result;
    }
}

