/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.provider.configuration.dependencies.DependencyCreator;
import com.nxp.swtools.provider.configuration.dependencies.IDependency;
import com.nxp.swtools.provider.configuration.dependencies.IDependencyFeature;
import com.nxp.swtools.provider.configuration.storage.StorageDependencyFeature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(strict=false)
public class StorageDependency
implements IDependency {
    @Attribute
    @NonNull
    String resourceType = "";
    @Attribute
    @NonNull
    String resourceId = "";
    @Attribute(required=false, empty="")
    @NonNull
    @Attribute(required=false, empty="") @NonNull String description = "";
    @Attribute(name="problem_level")
    private int problemLevel = 0;
    @Attribute(name="source")
    @NonNull
    private @Attribute(name="source") @NonNull String source = "";
    @ElementList(inline=true, entry="feature", type=StorageDependencyFeature.class)
    @NonNull
    @ElementList(inline=true, entry="feature", type=StorageDependencyFeature.class) @NonNull List<@NonNull IDependencyFeature> features = new ArrayList<IDependencyFeature>();
    @NonNull
    private transient DependencyCreator dependencyCreator = DependencyCreator.UNKNOWN;
    @Attribute(name="boot_init_only", required=false)
    private Boolean bootInitOnly;
    @NonNull
    private static final String ORIGINATOR_ID_SEPARATOR = ".";
    @NonNull
    private transient String originatorId = "";

    public static @NonNull String makeOriginatorId(@NonNull String componentId, @NonNull String settingId) {
        return String.valueOf(componentId) + ORIGINATOR_ID_SEPARATOR + settingId;
    }

    public static @NonNull String extractComponentId(@NonNull String originatorId) {
        int sepPos = originatorId.indexOf(ORIGINATOR_ID_SEPARATOR);
        return sepPos != -1 ? originatorId.substring(0, sepPos) : originatorId;
    }

    @Override
    public @NonNull String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(@NonNull String resourceType) {
        this.resourceType = resourceType;
    }

    @Override
    public @NonNull String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(@NonNull String resourceId) {
        this.resourceId = resourceId;
    }

    @Override
    public @NonNull String getDescription() {
        return this.description;
    }

    public void setDescription(@NonNull String description) {
        this.description = description;
    }

    public void setProblemLevel(int problemLevel) {
        this.problemLevel = problemLevel;
    }

    @Override
    public int getProblemlevel() {
        return this.problemLevel;
    }

    @Override
    public @NonNull String getSource() {
        return this.source;
    }

    public void setSource(@NonNull String source) {
        this.source = source;
    }

    @Override
    public @NonNull Collection<@NonNull IDependencyFeature> getFeatures() {
        return this.features;
    }

    public void setFeatures(@NonNull List<@NonNull IDependencyFeature> features) {
        this.features = features;
    }

    public String toString() {
        return "StorageDependency [resourceType=" + this.resourceType + ", resourceId=" + this.resourceId + ", problemLevel=" + this.problemLevel + ", source=" + this.source + ", originatorId=" + this.originatorId + "]";
    }

    @Override
    public @NonNull DependencyCreator getDependencyCreator() {
        return this.dependencyCreator;
    }

    public void setDependencyCreator(@NonNull DependencyCreator dependencyCreator) {
        this.dependencyCreator = dependencyCreator;
    }

    @Override
    public boolean getBootInitOnly() {
        Boolean bootInitOnlyLoc = this.bootInitOnly;
        if (bootInitOnlyLoc == null) {
            return false;
        }
        return bootInitOnlyLoc;
    }

    public void setBootInitOnly(boolean value) {
        this.bootInitOnly = value ? Boolean.TRUE : null;
    }

    public @NonNull String getOriginatorId() {
        return this.originatorId;
    }

    public void setOriginatorId(@NonNull String originatorId) {
        this.originatorId = originatorId;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.resourceType.hashCode();
        result = 31 * result + this.resourceId.hashCode();
        result = 31 * result + this.description.hashCode();
        result = 31 * result + this.problemLevel;
        result = 31 * result + this.source.hashCode();
        result = 31 * result + this.features.hashCode();
        result = 31 * result + Objects.hashCode(this.bootInitOnly);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageDependency other = (StorageDependency)obj;
        if (!this.resourceType.equals(other.resourceType)) {
            return false;
        }
        if (!this.resourceId.equals(other.resourceId)) {
            return false;
        }
        if (!this.description.equals(other.description)) {
            return false;
        }
        if (this.problemLevel != other.problemLevel) {
            return false;
        }
        if (!this.source.equals(other.source)) {
            return false;
        }
        if (!this.features.equals(other.features)) {
            return false;
        }
        return Objects.equals(this.bootInitOnly, other.bootInitOnly);
    }
}

