/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.memory.spaces.ui.memento;

import com.nxp.s32ds.cle.cdt.memory.spaces.base.MemorySpace;
import com.nxp.s32ds.cle.cdt.memory.spaces.base.MemorySpaces;
import com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui.MemorySpacesUIActivator;
import com.nxp.s32ds.ext.rcp.runtime.ui.memento.RcpMementos;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IMemento;

public class MemorySpaceContextMemento
extends RcpMementos<Map<MemorySpace, List<String>>> {
    private static final String MEMSPACE_CHILD = "memory_space_";
    private static final String MEMSPACE_ID = "id";
    private static final String MEMSPACE_DEVICE = "device";
    private static final String MEMSPACE_CORE = "core";
    private static final String MEMSPACE_NAME = "name";
    private static final String MEMSPACE_BASE_ADDRESS = "base_address";
    private static final String MEMSPACE_BYTES_PER_ADDRESS = "bytes_per_address";
    private static final String MEMSPACE_BYTES_PER_ROW = "bytes_per_row";
    private static final String MEMSPACE_RENDERING_ID = "rendering_id_";
    private static final String MEMSPACE_MAX_ADDRESS = "max_address";
    private static final String MEMSPACE_EXPRESSION_ADDRESS = "expression_address";
    private static final BigInteger DEFAULT_MAX_ADDRESS = BigInteger.ONE.shiftLeft(32).subtract(BigInteger.ONE);

    public MemorySpaceContextMemento(String mementoId) {
        super("MemorySpaceContextMemento", mementoId);
    }

    protected void saveToMemento(IMemento memento, Map<MemorySpace, List<String>> memSpaces) {
        int number = 0;
        for (Map.Entry<MemorySpace, List<String>> entry : memSpaces.entrySet()) {
            MemorySpace memSpace = entry.getKey();
            IMemento memSpaceChild = memento.createChild(MEMSPACE_CHILD + String.valueOf(number++));
            memSpaceChild.putString(MEMSPACE_ID, memSpace.getId());
            memSpaceChild.putString(MEMSPACE_DEVICE, memSpace.getDevice());
            memSpaceChild.putString(MEMSPACE_CORE, memSpace.getCore());
            memSpaceChild.putString(MEMSPACE_NAME, memSpace.getName());
            memSpaceChild.putString(MEMSPACE_BASE_ADDRESS, memSpace.getBaseAddress().toString(16));
            memSpaceChild.putInteger(MEMSPACE_BYTES_PER_ADDRESS, memSpace.getBytesPerAddress());
            memSpaceChild.putInteger(MEMSPACE_BYTES_PER_ROW, memSpace.getBytesPerRow());
            memSpaceChild.putString(MEMSPACE_EXPRESSION_ADDRESS, memSpace.getMemoryExpression().toString());
            memSpaceChild.putString(MEMSPACE_MAX_ADDRESS, memSpace.getMaxAddress().toString());
            int count = 0;
            for (String tabItem : entry.getValue()) {
                memSpaceChild.putString(MEMSPACE_RENDERING_ID + count++, tabItem);
            }
        }
    }

    protected Map<MemorySpace, List<String>> restoreFromMemento(IMemento memento, Map<MemorySpace, List<String>> memSpaces) {
        IMemento[] memorySpaces = memento.getChildren();
        if (memorySpaces.length == 0) {
            return Collections.emptyMap();
        }
        Arrays.stream(memorySpaces).forEach(child -> {
            String rendering;
            BigInteger baseAddress = new BigInteger(child.getString(MEMSPACE_BASE_ADDRESS), 16);
            MemorySpace memSpace = MemorySpaces.createMemorySpace((String)child.getString(MEMSPACE_ID), (String)child.getString(MEMSPACE_NAME), (String)child.getString(MEMSPACE_DEVICE), (String)child.getString(MEMSPACE_CORE), (BigInteger)baseAddress, (int)Objects.requireNonNull(child.getInteger(MEMSPACE_BYTES_PER_ADDRESS)), (int)Objects.requireNonNull(child.getInteger(MEMSPACE_BYTES_PER_ROW)), (String)child.getString(MEMSPACE_EXPRESSION_ADDRESS), (BigInteger)(child.getString(MEMSPACE_MAX_ADDRESS) != null ? new BigInteger(child.getString(MEMSPACE_MAX_ADDRESS)) : DEFAULT_MAX_ADDRESS));
            ArrayList<String> renderings = new ArrayList<String>();
            int count = 0;
            while ((rendering = child.getString(MEMSPACE_RENDERING_ID + count)) != null) {
                renderings.add(rendering);
                ++count;
            }
            memSpaces.put(memSpace, renderings);
        });
        return memSpaces;
    }

    protected IPreferenceStore getPreferenceStore() {
        return MemorySpacesUIActivator.getInstance().getPreferenceStore();
    }
}

