/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui;

import com.nxp.s32ds.cle.cdt.memory.spaces.base.MemorySpace;
import com.nxp.s32ds.cle.cdt.memory.spaces.base.MemorySpaces;
import com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui.MemorySpacesUIActivator;
import com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.memory.spaces.internal.ui.data.MemoryBase;
import com.nxp.s32ds.cle.runtime.memory.spaces.core.DeviceCoreMemorySpaceDescriptor;
import com.nxp.s32ds.ext.cdt.dsf.DsfSessionInactiveException;
import com.nxp.s32ds.ext.cdt.dsf.session.DsfSessionDsfServiceTrackerManager;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.command.commands.MICommand;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MemorySpacesDialog
extends Dialog {
    private Button butOK;
    private String titleText;
    private CCombo cmbMemSpaces;
    Text textAddress;
    private MemorySpace selectedMemSpace;
    private BigInteger currentAddress;
    private String memoryExpression;
    private String initExpression;
    private static final String ADDRESS_EVALUATE_STRING = "-data-evaluate-expression &(*%s)";
    private final List<DeviceCoreMemorySpaceDescriptor> memorySpaces;

    public MemorySpacesDialog(Shell parentShell, String title, List<DeviceCoreMemorySpaceDescriptor> memorySpaces, String initExpressionString) {
        this(parentShell, title, memorySpaces);
        this.initExpression = initExpressionString;
    }

    public MemorySpacesDialog(Shell parentShell, String title, List<DeviceCoreMemorySpaceDescriptor> memorySpaces) {
        super(parentShell);
        this.titleText = title;
        this.memorySpaces = memorySpaces;
        this.currentAddress = null;
        this.memoryExpression = null;
    }

    public Control createDialogArea(Composite parent) {
        Composite innerComposite = new Composite(parent, 2048);
        GridLayout gridLayout = new GridLayout(1, true);
        innerComposite.setLayout((Layout)gridLayout);
        GridData fill = new GridData(4, 4, true, true);
        fill.minimumWidth = 300;
        innerComposite.setLayoutData((Object)fill);
        Group groupGeneral = new Group(innerComposite, 0);
        groupGeneral.setText(Messages.MemorySpacesDialog_settings_text);
        groupGeneral.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        groupGeneral.setLayout((Layout)new GridLayout(2, false));
        Label lblAddress = new Label((Composite)groupGeneral, 0);
        lblAddress.setText(Messages.MemorySpacesDialog_address_hex_text);
        lblAddress.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.textAddress = new Text((Composite)groupGeneral, 2048);
        if (this.initExpression != null) {
            this.textAddress.setText(this.initExpression);
        }
        this.textAddress.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.textAddress.addModifyListener(e -> this.handleUpdate(this.textAddress));
        Label lbl = new Label((Composite)groupGeneral, 0);
        lbl.setText(Messages.MemorySpacesDialog_memory_space_text);
        lbl.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.cmbMemSpaces = new CCombo((Composite)groupGeneral, 2048);
        this.cmbMemSpaces.setEditable(false);
        this.cmbMemSpaces.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.cmbMemSpaces.setItems(this.convertInput(this.memorySpaces));
        this.cmbMemSpaces.select(0);
        this.cmbMemSpaces.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MemorySpacesDialog.this.handleUpdate(MemorySpacesDialog.this.textAddress);
            }
        });
        Composite buttons = new Composite(parent, 0);
        buttons.setLayout((Layout)new GridLayout(3, false));
        buttons.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.getShell().setText(this.titleText);
        parent.pack();
        return innerComposite;
    }

    private void handleUpdate(Text textAddress) {
        if (textAddress.getText().isEmpty()) {
            this.memoryExpression = "";
            this.butOK.setEnabled(false);
            return;
        }
        if (this.isNumeric(textAddress.getText())) {
            this.memoryExpression = "";
            this.butOK.setEnabled(this.isInRange(textAddress.getText(), 10));
            this.currentAddress = new BigInteger(textAddress.getText());
            return;
        }
        if (textAddress.getText().startsWith("0x") && this.isHex(textAddress.getText().substring(2))) {
            this.memoryExpression = "";
            this.currentAddress = new BigInteger(textAddress.getText().substring(2), 16);
            this.butOK.setEnabled(this.isInRange(textAddress.getText().substring(2), 16));
            return;
        }
        this.butOK.setEnabled(true);
        BigInteger address = this.getAddress(textAddress.getText());
        this.memoryExpression = textAddress.getText();
        if (address == null) {
            this.butOK.setEnabled(false);
            return;
        }
        if (address.equals(this.currentAddress)) {
            return;
        }
        this.currentAddress = address;
        if (!this.getCurentSelectedSpace().getMemorySpaceRecognitionDescriptor().needSpaceCheck()) {
            return;
        }
        int id = this.getMemSpacePrefix(address);
        if (id < 0) {
            this.butOK.setEnabled(false);
            return;
        }
        Optional<DeviceCoreMemorySpaceDescriptor> memSpaceDescriptor = this.memorySpaces.stream().filter(memSpace -> memSpace.getPrefix() == id).findAny();
        if (memSpaceDescriptor.isEmpty()) {
            return;
        }
        this.cmbMemSpaces.select(this.cmbMemSpaces.indexOf(memSpaceDescriptor.get().getName()));
    }

    private boolean isInRange(String value, int base) {
        try {
            return this.getCurentSelectedSpace().getMaxAddress().compareTo(new BigInteger(value, base)) >= 0;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean isNumeric(String number) {
        try {
            new BigInteger(number, 10);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private boolean isHex(String address) {
        try {
            new BigInteger(address, 16);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private DeviceCoreMemorySpaceDescriptor getCurentSelectedSpace() {
        return this.memorySpaces.get(this.cmbMemSpaces.getSelectionIndex());
    }

    private String[] convertInput(List<DeviceCoreMemorySpaceDescriptor> memorySpaces) {
        return memorySpaces.stream().map(DeviceCoreMemorySpaceDescriptor::getName).collect(Collectors.toList()).toArray(new String[0]);
    }

    public MemorySpace getMemorySpace() {
        return this.selectedMemSpace;
    }

    protected void okPressed() {
        this.selectedMemSpace = MemorySpaces.createMemorySpace((DeviceCoreMemorySpaceDescriptor)this.getCurentSelectedSpace());
        this.selectedMemSpace.setBaseAddress(this.currentAddress.and(this.getCurentSelectedSpace().getMaxAddress()));
        if (this.memoryExpression != null) {
            this.selectedMemSpace.setMemoryExpression(this.memoryExpression);
        }
        super.okPressed();
    }

    protected Control createButtonBar(Composite parent) {
        Control butBar = super.createButtonBar(parent);
        this.butOK = this.getButton(0);
        this.butOK.setText(Messages.MemorySpacesDialog_select_text);
        this.butOK.setEnabled(false);
        if (!this.textAddress.getText().trim().isEmpty()) {
            this.handleUpdate(this.textAddress);
        }
        return butBar;
    }

    private BigInteger getAddress(String expression) {
        GdbLaunch launch = MemoryBase.getInstance().getMemoryAccessor().getLaunch();
        Query<BigInteger> query = this.getAddressQuery(expression, launch);
        launch.getDsfExecutor().execute(query);
        BigInteger address = null;
        try {
            address = (BigInteger)query.get(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            MemorySpacesUIActivator.getInstance().logError(e.getLocalizedMessage(), e);
        }
        return address;
    }

    private Query<BigInteger> getAddressQuery(final String expression, final GdbLaunch launch) {
        return new Query<BigInteger>(){

            protected void execute(DataRequestMonitor<BigInteger> rm) {
                DsfSession session = launch.getSession();
                IGDBControl gdbControl = null;
                try {
                    gdbControl = (IGDBControl)DsfSessionDsfServiceTrackerManager.getInstance().computeIfAbsent(session).getService(IGDBControl.class);
                }
                catch (DsfSessionInactiveException e) {
                    MemorySpacesUIActivator.getInstance().logError(e.getLocalizedMessage(), e);
                    rm.done(Status.error((String)e.getMessage(), (Throwable)e));
                    return;
                }
                MICommand cliCommand = new MICommand((IDMContext)gdbControl.getContext(), String.format(MemorySpacesDialog.ADDRESS_EVALUATE_STRING, expression));
                gdbControl.queueCommand((ICommand)cliCommand, (DataRequestMonitor)new AddressRequestMonitor(rm));
            }
        };
    }

    private int getMemSpacePrefix(BigInteger address) {
        BigInteger id = address.and(this.getCurentSelectedSpace().getMemorySpaceRecognitionDescriptor().getMask()).shiftRight(this.getCurentSelectedSpace().getMemorySpaceRecognitionDescriptor().getShift());
        return id.intValue();
    }

    private final class AddressRequestMonitor
    extends ImmediateDataRequestMonitor<MIInfo> {
        private final DataRequestMonitor<BigInteger> rm;

        private AddressRequestMonitor(DataRequestMonitor<BigInteger> rm) {
            this.rm = rm;
        }

        protected void handleSuccess() {
            if (((MIInfo)this.getData()).getMIOutput() == null || ((MIInfo)this.getData()).getMIOutput().getMIResultRecord() == null) {
                this.rm.done(this.getStatus());
                return;
            }
            MIResult[] result = ((MIInfo)this.getData()).getMIOutput().getMIResultRecord().getMIResults();
            if (result != null && result.length > 0) {
                try {
                    this.rm.setData((Object)new BigInteger(result[0].getMIValue().toString().split(" ")[0].substring(2), 16));
                }
                catch (NumberFormatException e) {
                    MemorySpacesUIActivator.getInstance().logError(e.getLocalizedMessage(), e);
                    this.rm.done(Status.error((String)e.getMessage(), (Throwable)e));
                    return;
                }
            }
            this.rm.done();
        }

        protected void handleCancel() {
            this.rm.done(this.getStatus());
        }

        protected void handleErrorOrWarning() {
            this.rm.done(this.getStatus());
        }
    }
}

