/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.ui.load.wizard;

import com.nxp.s32ds.cle.cdt.sdk.core.load.LoadSdkException;
import com.nxp.s32ds.cle.cdt.sdk.core.load.parsers.SdkDescriptorParser;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.SdkTreeComposite;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.SdkUiActivator;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.widgets.ButtonFactory;
import org.eclipse.jface.widgets.CompositeFactory;
import org.eclipse.jface.widgets.LabelFactory;
import org.eclipse.jface.widgets.TextFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class ExternalSdkWizardLoadSdkFromDescriptorPage
extends WizardPage {
    static final String PAGE_ID = "com.nxp.s32ds.cle.cdt.sdk.ui.external.sdk.wizard.load.manifest.page";
    private String directoryPath;
    private SdkTreeComposite treeComposite;

    public ExternalSdkWizardLoadSdkFromDescriptorPage() {
        super(PAGE_ID);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layout((Layout)GridLayoutFactory.swtDefaults().create())).layoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, true).create())).create((Widget)parent);
        this.createSelectOriginFileComposite(composite);
        this.createSdksListComposite(composite);
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.freescale.s32ds.cross.sdk.support.SDK_load_manifest");
    }

    private void createSelectOriginFileComposite(Composite parent) {
        Composite composite = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layout((Layout)GridLayoutFactory.swtDefaults().numColumns(3).create())).layoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, false).create())).create((Widget)parent);
        ((LabelFactory)WidgetFactory.label((int)16384).text(Messages.ExternalSdkWizardLoadFromDescriptorPage_label_sdk_folder).layoutData((Object)GridDataFactory.swtDefaults().align(16384, 0x1000000).create())).create((Widget)composite);
        Text directoryPathText = (Text)((TextFactory)WidgetFactory.text((int)2056).layoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create())).create((Widget)composite);
        Button browseFolderButton = (Button)((ButtonFactory)WidgetFactory.button((int)8).text(Messages.SdkDialog_browse_button_text).layoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).create())).onSelect(e -> this.selectDescriptionFiles(directoryPathText)).create((Widget)composite);
        this.setButtonLayoutData(browseFolderButton);
    }

    private void createSdksListComposite(Composite parent) {
        Composite composite = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layout((Layout)GridLayoutFactory.swtDefaults().create())).layoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, true).create())).create((Widget)parent);
        ((LabelFactory)WidgetFactory.label((int)16384).text(Messages.ExternalSdkWizardLoadSdkFromDescriptorPage_label_sdk_list).layoutData((Object)GridDataFactory.swtDefaults().align(16384, 0x1000000).create())).create((Widget)composite);
        this.treeComposite = new SdkTreeComposite(composite);
        this.treeComposite.addSelectionChangeListener(status -> this.setErrorMessage(!status.isOK() ? status.getMessage() : null));
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.freescale.s32ds.cross.sdk.support.SDK_load_manifest");
        super.performHelp();
    }

    public boolean isCurrentPage() {
        return super.isCurrentPage();
    }

    public String getDescription() {
        return Messages.ExternalSdkWizardLoadSdkFromDescriptorPage_description;
    }

    public String getTitle() {
        return Messages.ExternalSdkWizardLoadSdkFromDescriptorPage_title;
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public IWizardPage getPreviousPage() {
        return this.getWizard().getPage("com.nxp.s32ds.cle.cdt.sdk.ui.external.sdk.wizard.select.origin.page");
    }

    public boolean isPageComplete() {
        return !Objects.toString(this.directoryPath, "").isEmpty() && !this.getDescriptorFilePaths().isEmpty();
    }

    protected Map<String, Collection<SdkDescriptor>> getDescriptorFilePaths() {
        return this.treeComposite.getSelectedItems(this.directoryPath);
    }

    private void selectDescriptionFiles(Text directoryPathText) {
        this.setErrorMessage(null);
        FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 0x10001002);
        dialog.setText(Messages.SdkPreferencesPage_load_sdk_dialog_title);
        dialog.setFilterExtensions(new String[]{"*.xml"});
        dialog.open();
        List<String> selectedDescriptorFileNames = Arrays.asList(dialog.getFileNames());
        this.directoryPath = dialog.getFilterPath();
        directoryPathText.setText(this.directoryPath);
        SdkDescriptorParser parser = new SdkDescriptorParser();
        LinkedHashMap<String, Collection<SdkDescriptor>> manifestToSdksMap = new LinkedHashMap<String, Collection<SdkDescriptor>>();
        for (String descriptorFileName : selectedDescriptorFileNames) {
            File descriptorFile = Paths.get(this.directoryPath, descriptorFileName).toFile();
            try {
                Throwable throwable = null;
                Object var10_12 = null;
                try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(descriptorFile));){
                    Collection headers = parser.loadSdksHeaders(SdkManagementUtils.getSdksManifestXml((InputStream)bis)).values();
                    manifestToSdksMap.put(descriptorFileName, headers);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (LoadSdkException | IOException e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.ExternalSdkWizardLoadSdkFromDescriptorPage_problem_occurred, (String)Messages.ExternalSdkWizardLoadSdkFromDescriptorPage_errors_occur, (IStatus)ValidationStatus.error((String)e.getMessage(), (Throwable)e));
                SdkUiActivator.getInstance().logError(String.format("Unable to load SDKs from manifest file %s due to error: %s", descriptorFile.getAbsolutePath(), e.getMessage()), e);
            }
        }
        this.treeComposite.setInput(manifestToSdksMap);
        this.getContainer().updateButtons();
    }
}

