/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.ui.attach.wizard;

import com.nxp.s32ds.cle.cdt.project.configuration.core.ProjectConfigurationUtils;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachStatuses;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachStatusesHolder;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.SdkPageContentProvider;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.SdkPageLabelProvider;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.SdkUiActivator;
import com.nxp.s32ds.cle.cdt.sdk.ui.attach.wizard.SdkAttachWizardDetachPage;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.widgets.CompositeFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class SdkAttachWizardConfigPage
extends WizardPage {
    static final String PAGE_ID = "com.nxp.s32ds.cle.cdt.sdk.ui.attach.wizard.config.page";
    private static final int TABLE_MAX_VISIBLE_ROWS_NUMBER = 8;
    private Collection<SdkDescriptor> sdks;
    private IProject project;
    private Map<String, List<IStatus>> initialSdksToConfigsAttachmentData;
    private Map<String, List<IStatus>> currentSdksToConfigsAttachmentData;
    private Button selectAllButton;
    private Button selectNoneButton;
    private CheckboxTableViewer tableViewer;

    public SdkAttachWizardConfigPage(Collection<SdkDescriptor> sdks, IProject project, Map<String, List<IStatus>> sdksToConfigsAttachmentData) {
        super(PAGE_ID);
        this.sdks = sdks;
        this.project = project;
        this.currentSdksToConfigsAttachmentData = Objects.requireNonNull(sdksToConfigsAttachmentData);
        this.initialSdksToConfigsAttachmentData = SdkAttachWizardConfigPage.copyData(this.currentSdksToConfigsAttachmentData);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite container = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layout((Layout)GridLayoutFactory.swtDefaults().create())).layoutData((Object)GridDataFactory.swtDefaults().grab(true, false).align(4, 4).create())).create((Widget)parent);
        this.createTableComposite(container);
        this.createButtonsComposite(container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "com.freescale.s32ds.cross.sdk.support.SDK_SHOW_ATTACHED_window_one_context");
        this.setControl((Control)container);
    }

    public String getDescription() {
        return Messages.SdkAttachWizardConfigPage_message;
    }

    public String getTitle() {
        return Messages.SdkAttachWizardConfigPage_title;
    }

    public boolean canFlipToNextPage() {
        return !this.getSdksToDetach().isEmpty();
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.freescale.s32ds.cross.sdk.support.SDK_SHOW_ATTACHED_window_one_context");
        super.performHelp();
    }

    public IWizardPage getNextPage() {
        if (this.canFlipToNextPage()) {
            SdkAttachWizardDetachPage page = (SdkAttachWizardDetachPage)this.getWizard().getPage("com.nxp.s32ds.cle.cdt.sdk.ui.attach.wizard.detach.page");
            page.updateSdksToDetachList(this.getSdksToDetach());
            return page;
        }
        return null;
    }

    public boolean isPageComplete() {
        return !this.getSdksToAttach().isEmpty() || !this.getSdksToDetach().isEmpty();
    }

    public boolean isCurrentPage() {
        return super.isCurrentPage();
    }

    Collection<SdkDescriptor> getSdksToAttach() {
        ArrayList<SdkDescriptor> sdksToAttach = new ArrayList<SdkDescriptor>();
        block0: for (Map.Entry<String, List<IStatus>> e : this.initialSdksToConfigsAttachmentData.entrySet()) {
            String sdkId = e.getKey();
            List<IStatus> initialStatuses = e.getValue();
            List<IStatus> currentStatuses = this.currentSdksToConfigsAttachmentData.get(sdkId);
            int i = 0;
            while (i < initialStatuses.size()) {
                if (SdkAttachStatuses.OK_SDK_NOT_ATTACHED.equals(initialStatuses.get(i)) && SdkAttachStatuses.OK_SDK_ATTACHED.equals(currentStatuses.get(i))) {
                    sdksToAttach.add(SdkDescriptors.getSdkDescriptor((String)sdkId));
                    continue block0;
                }
                ++i;
            }
        }
        return sdksToAttach;
    }

    Collection<SdkDescriptor> getSdksToDetach() {
        ArrayList<SdkDescriptor> sdksToDetach = new ArrayList<SdkDescriptor>();
        block0: for (Map.Entry<String, List<IStatus>> e : this.initialSdksToConfigsAttachmentData.entrySet()) {
            String sdkId = e.getKey();
            List<IStatus> initialStatuses = e.getValue();
            List<IStatus> currentStatuses = this.currentSdksToConfigsAttachmentData.get(sdkId);
            int i = 0;
            while (i < initialStatuses.size()) {
                if (SdkAttachStatuses.OK_SDK_ATTACHED.equals(initialStatuses.get(i)) && SdkAttachStatuses.OK_SDK_NOT_ATTACHED.equals(currentStatuses.get(i))) {
                    sdksToDetach.add(SdkDescriptors.getSdkDescriptor((String)sdkId));
                    continue block0;
                }
                ++i;
            }
        }
        return sdksToDetach;
    }

    private EditingSupport getConfigColumnEditingSupport(int configColumnIndex) {
        return new SdkPageLabelProvider.CfgEditingSupport((ColumnViewer)this.tableViewer, configColumnIndex, this.currentSdksToConfigsAttachmentData){

            @Override
            protected void setValue(Object element, Object value) {
                if (Boolean.TRUE.equals(this.getValue(element))) {
                    super.setValue(element, value);
                    SdkAttachWizardConfigPage.this.updateButtons();
                }
            }
        };
    }

    private static CellLabelProvider getConfigColumnLabelProvider(int idx, Map<String, List<IStatus>> data) {
        return new SdkPageLabelProvider.CfgCellLabelProvider(idx, (Map)data){

            @Override
            protected Image getImage(IStatus status) {
                if (SdkAttachStatuses.OK_SDK_ATTACHED.equals(status)) {
                    return SdkUiActivator.getInstance().getImage("SDK_COMMON_CHECK_ICON");
                }
                if (SdkAttachStatuses.OK_SDK_NOT_ATTACHED.equals(status)) {
                    return SdkUiActivator.getInstance().getImage("SDK_COMMON_UNCHECK_ICON");
                }
                return super.getImage(status);
            }
        };
    }

    private void changeAttachStatusesTo(IStatus newStatus) {
        IStatus changeFromStatus = SdkAttachStatuses.OK_SDK_ATTACHED.equals(newStatus) ? SdkAttachStatuses.OK_SDK_NOT_ATTACHED : SdkAttachStatuses.OK_SDK_ATTACHED;
        for (Map.Entry<String, List<IStatus>> e : this.currentSdksToConfigsAttachmentData.entrySet()) {
            List<IStatus> sdkAttachStatuses = e.getValue();
            int i = 0;
            while (i < sdkAttachStatuses.size()) {
                sdkAttachStatuses.set(i, SdkAttachWizardConfigPage.switchAttachStatus(sdkAttachStatuses.get(i), changeFromStatus));
                ++i;
            }
        }
        this.updateButtons();
        this.tableViewer.refresh();
    }

    private static IStatus switchAttachStatus(IStatus currentAttachStatus, IStatus switchFromStatus) {
        if (SdkAttachStatuses.OK_SDK_ATTACHED.equals(switchFromStatus) && SdkAttachStatuses.OK_SDK_ATTACHED.equals(currentAttachStatus)) {
            return SdkAttachStatuses.OK_SDK_NOT_ATTACHED;
        }
        if (SdkAttachStatuses.OK_SDK_NOT_ATTACHED.equals(switchFromStatus) && SdkAttachStatuses.OK_SDK_NOT_ATTACHED.equals(currentAttachStatus)) {
            return SdkAttachStatuses.OK_SDK_ATTACHED;
        }
        return currentAttachStatus;
    }

    private void updateButtons() {
        ArrayList<String> statuses = new ArrayList<String>();
        for (SdkDescriptor crtSdk : this.sdks) {
            List<IStatus> crtSdksStates = this.currentSdksToConfigsAttachmentData.get(crtSdk.getId());
            if (crtSdksStates.stream().allMatch(SdkAttachStatuses.OK_SDK_ATTACHED::equals)) {
                statuses.add(SdkAttachStatuses.OK_SDK_ATTACHED.getMessage());
                continue;
            }
            if (crtSdksStates.stream().allMatch(SdkAttachStatuses.OK_SDK_NOT_ATTACHED::equals)) {
                statuses.add(SdkAttachStatuses.OK_SDK_NOT_ATTACHED.getMessage());
                continue;
            }
            statuses.add(SdkAttachStatuses.OTHER_SDK_STATUS.getMessage());
        }
        if (!statuses.isEmpty() && !statuses.contains(SdkAttachStatuses.OTHER_SDK_STATUS.getMessage())) {
            if (statuses.stream().allMatch(SdkAttachStatuses.OK_SDK_ATTACHED.getMessage()::equals)) {
                this.changeStatusAndSelection(this.selectAllButton, false, true);
                this.changeStatusAndSelection(this.selectNoneButton, true, false);
            } else if (statuses.stream().allMatch(SdkAttachStatuses.OK_SDK_NOT_ATTACHED.getMessage()::equals)) {
                this.changeStatusAndSelection(this.selectAllButton, true, false);
                this.changeStatusAndSelection(this.selectNoneButton, false, true);
            } else {
                this.changeStatusAndSelection(this.selectAllButton, true, false);
                this.changeStatusAndSelection(this.selectNoneButton, true, false);
            }
        } else {
            this.changeStatusAndSelection(this.selectAllButton, true, false);
            this.changeStatusAndSelection(this.selectNoneButton, true, false);
        }
        this.getContainer().updateButtons();
    }

    private void changeStatusAndSelection(Button button, boolean status, boolean selection) {
        button.setEnabled(status);
        button.setSelection(selection);
    }

    private void createTableComposite(Composite container) {
        Composite tableComposite = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layout((Layout)GridLayoutFactory.swtDefaults().create())).layoutData((Object)GridDataFactory.swtDefaults().grab(true, false).align(4, 4).create())).create((Widget)container);
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)tableComposite, (int)68096);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.setComparator(SdkAttachWizardConfigPage.getComparator());
        this.tableViewer.addCheckStateListener(this.getCheckStateListener());
        this.tableViewer.setCheckStateProvider(this.getCheckStateProvider());
        GridData data = new GridData(4, 4, true, false);
        data.heightHint = 8 * this.tableViewer.getTable().getItemHeight();
        tableComposite.setLayoutData((Object)data);
        this.setupTable(tableComposite);
    }

    private void createButtonsComposite(Composite container) {
        Composite buttonsComposite = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create())).layoutData((Object)GridDataFactory.swtDefaults().grab(true, false).align(4, 4).create())).create((Widget)container);
        this.selectAllButton = (Button)WidgetFactory.button((int)32).text(Messages.SdkAttachConfigurationsDialog_button_label_select_all).onSelect(event -> this.changeAttachStatusesTo(SdkAttachStatuses.OK_SDK_ATTACHED)).create((Widget)buttonsComposite);
        this.setButtonLayoutData(this.selectAllButton);
        this.selectNoneButton = (Button)WidgetFactory.button((int)32).text(Messages.SdkAttachConfigurationsDialog_button_label_select_none).onSelect(event -> this.changeAttachStatusesTo(SdkAttachStatuses.OK_SDK_NOT_ATTACHED)).create((Widget)buttonsComposite);
        this.setButtonLayoutData(this.selectNoneButton);
        this.updateButtons();
    }

    private void setupTable(Composite body) {
        TableViewerColumn nameColumn = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        nameColumn.getColumn().setText(Messages.SdkTableViewerHolder_name_column_text);
        nameColumn.setLabelProvider(SdkPageLabelProvider.getNameLabelProvider());
        TableViewerColumn versionColumn = new TableViewerColumn((TableViewer)this.tableViewer, 0);
        versionColumn.getColumn().setText(Messages.SdkTableViewerHolder_version_column_text);
        versionColumn.setLabelProvider(SdkPageLabelProvider.getVersionLabelProvider());
        ArrayList<TableViewerColumn> configColumns = new ArrayList<TableViewerColumn>();
        if (this.project != null && this.project.isAccessible()) {
            List projectConfigurations = ProjectConfigurationUtils.getProjectConfigurations((IProject)this.project);
            int i = 0;
            while (i < projectConfigurations.size()) {
                String configName = ((IConfiguration)projectConfigurations.get(i)).getName();
                TableViewerColumn configColumn = new TableViewerColumn((TableViewer)this.tableViewer, 0x1000000);
                configColumn.getColumn().setAlignment(0x1000000);
                configColumn.getColumn().setText(configName);
                configColumn.getColumn().setToolTipText(configName);
                configColumn.setLabelProvider(SdkAttachWizardConfigPage.getConfigColumnLabelProvider(i, this.currentSdksToConfigsAttachmentData));
                configColumn.setEditingSupport(this.getConfigColumnEditingSupport(i));
                configColumns.add(configColumn);
                ++i;
            }
        }
        TableColumnLayout tableLayout = new TableColumnLayout();
        body.setLayout((Layout)tableLayout);
        tableLayout.setColumnData((Widget)nameColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(170));
        tableLayout.setColumnData((Widget)versionColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(60));
        configColumns.forEach(col -> tableLayout.setColumnData((Widget)col.getColumn(), (ColumnLayoutData)new ColumnWeightData(80)));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
        this.tableViewer.setContentProvider((IContentProvider)SdkPageContentProvider.getStructuredContentProvider());
        this.tableViewer.setInput(this.sdks);
    }

    private ICheckStateListener getCheckStateListener() {
        return event -> {
            Object element = event.getElement();
            if (element instanceof SdkDescriptor) {
                IStatus switchFromStatus = event.getChecked() ? SdkAttachStatuses.OK_SDK_NOT_ATTACHED : SdkAttachStatuses.OK_SDK_ATTACHED;
                List statuses = this.currentSdksToConfigsAttachmentData.getOrDefault(((SdkDescriptor)element).getId(), Collections.emptyList());
                int i = 0;
                while (i < statuses.size()) {
                    statuses.set(i, SdkAttachWizardConfigPage.switchAttachStatus((IStatus)statuses.get(i), switchFromStatus));
                    ++i;
                }
                this.updateButtons();
                this.tableViewer.refresh();
            }
        };
    }

    private ICheckStateProvider getCheckStateProvider() {
        return new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                if (element instanceof SdkDescriptor) {
                    List statuses = SdkAttachWizardConfigPage.this.currentSdksToConfigsAttachmentData.getOrDefault(((SdkDescriptor)element).getId(), Collections.emptyList());
                    return statuses.contains(SdkAttachStatuses.OK_SDK_ATTACHED) && statuses.contains(SdkAttachStatuses.OK_SDK_NOT_ATTACHED);
                }
                return false;
            }

            public boolean isChecked(Object element) {
                if (element instanceof SdkDescriptor) {
                    return !SdkAttachWizardConfigPage.this.currentSdksToConfigsAttachmentData.getOrDefault(((SdkDescriptor)element).getId(), Collections.emptyList()).contains(SdkAttachStatuses.OK_SDK_NOT_ATTACHED);
                }
                return false;
            }
        };
    }

    private static ViewerComparator getComparator() {
        return new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof SdkDescriptor && e2 instanceof SdkDescriptor) {
                    SdkDescriptor sdk1 = (SdkDescriptor)e1;
                    SdkDescriptor sdk2 = (SdkDescriptor)e2;
                    Boolean isSdk1Attached = SdkAttachStatusesHolder.INSTANCE.getSDKAttachStates(sdk1.getId()).contains(SdkAttachStatuses.OK_SDK_ATTACHED);
                    Boolean isSdk2Attached = SdkAttachStatusesHolder.INSTANCE.getSDKAttachStates(sdk2.getId()).contains(SdkAttachStatuses.OK_SDK_ATTACHED);
                    if (isSdk1Attached.booleanValue() && isSdk2Attached.booleanValue()) {
                        return sdk1.getName().toLowerCase().compareTo(sdk2.getName().toLowerCase());
                    }
                    return isSdk2Attached.compareTo(isSdk1Attached);
                }
                return 0;
            }
        };
    }

    private static Map<String, List<IStatus>> copyData(Map<String, List<IStatus>> map) {
        LinkedHashMap<String, List<IStatus>> data = new LinkedHashMap<String, List<IStatus>>();
        for (Map.Entry<String, List<IStatus>> entry : map.entrySet()) {
            String sdkId = entry.getKey();
            ArrayList<IStatus> copyStatuses = new ArrayList<IStatus>();
            for (IStatus status : entry.getValue()) {
                copyStatuses.add(status);
            }
            data.put(sdkId, copyStatuses);
        }
        return data;
    }
}

