/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui.imports;

import com.nxp.s32ds.cle.cdt.sdk.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.SdkUiActivator;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import org.eclipse.cdt.utils.ui.controls.RadioButtonsArea;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ImportSdkPathResolveDialog
extends TitleAreaDialog {
    private static final String HELP_CONTEXT = "com.freescale.s32ds.cross.sdk.support.SDK_import_resolve_context";
    private static final String[][] RADIO_BUTONS_LABEL_AND_VALUES = new String[][]{{Messages.ImportSdkPathResolveDialog_label_destination_default_path, "A"}, {Messages.ImportSdkPathResolveDialog_label_destination_sdk_base_path, "B"}};
    private RadioButtonsArea radio;
    private final String standardMessage;
    private String defaultLocation;
    private String selectedLocation;
    private Text locationText;
    private Label resolvedLocationLabel;
    private Label resolvedLocationPath;
    private String sdkBasePathLocation;
    private boolean isDefaultLocation;

    public ImportSdkPathResolveDialog(Shell parent, String defaultLocation, Map<String, String> parameters) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.defaultLocation = defaultLocation;
        this.sdkBasePathLocation = Objects.requireNonNull(parameters.get("basePath"));
        this.selectedLocation = defaultLocation;
        this.standardMessage = NLS.bind((String)Messages.ImportSdkPathResolveDialog_message, (Object)Objects.requireNonNull(parameters.get("name")));
        this.isDefaultLocation = true;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.ImportSdkDialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)parentComposite);
        Composite contents = this.createComposite(parentComposite);
        Dialog.applyDialogFont((Control)parentComposite);
        return contents;
    }

    private Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().hint(500, -1).applyTo((Control)composite);
        this.radio = new RadioButtonsArea(composite, Messages.ImportSdkPathResolveDialog_label_select_destination_path, 2, RADIO_BUTONS_LABEL_AND_VALUES);
        GridDataFactory.fillDefaults().grab(true, false).hint(500, -1).span(2, 0).applyTo((Control)this.radio);
        this.radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportSdkPathResolveDialog.this.isDefaultLocation = ImportSdkPathResolveDialog.this.radio.getSeletedIndex() == 0;
                ImportSdkPathResolveDialog.this.toggle();
            }
        });
        this.radio.setSelectedButton(0);
        Label locationLabel = new Label(composite, 0);
        locationLabel.setText("Location:");
        this.locationText = new Text(composite, 18498);
        this.locationText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.locationText.setText(this.defaultLocation);
        this.locationText.setEnabled(false);
        this.setTitle("Select path to SDK source files");
        this.setMessage(this.standardMessage);
        this.resolvedLocationLabel = new Label(composite, 0);
        this.resolvedLocationLabel.setText("Resolved location:");
        this.resolvedLocationLabel.setVisible(false);
        this.resolvedLocationPath = new Label(composite, 64);
        this.resolvedLocationPath.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.resolvedLocationPath.setVisible(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, HELP_CONTEXT);
        return composite;
    }

    private void toggle() {
        this.selectedLocation = this.isDefaultLocation ? this.defaultLocation : this.sdkBasePathLocation;
        this.locationText.setText(this.selectedLocation);
        this.showResolvedLocation();
    }

    private void showResolvedLocation() {
        this.resolvedLocationLabel.setVisible(false);
        this.resolvedLocationPath.setVisible(false);
        this.setErrorMessage(null);
        if (!this.selectedLocation.isEmpty()) {
            try {
                File f = new File(VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(this.selectedLocation));
                String aPath = f.getAbsolutePath();
                this.getButton(0).setEnabled(f.exists());
                if (!f.exists()) {
                    this.setErrorMessage("Path does not exist: " + aPath);
                }
                if (!aPath.equals(this.selectedLocation)) {
                    this.resolvedLocationLabel.setVisible(true);
                    this.resolvedLocationPath.setText(aPath);
                    this.resolvedLocationPath.setVisible(true);
                }
            }
            catch (CoreException ce) {
                SdkUiActivator.getInstance().logError(NLS.bind((String)"Unable to resolve location {0} path", (Object)this.selectedLocation), ce);
            }
        } else {
            this.getButton(0).setEnabled(false);
        }
    }

    public String getDefaultLocation() {
        return this.defaultLocation;
    }

    public String getSelectedLocation() {
        return this.selectedLocation;
    }

    public boolean isDefaultLocation() {
        return this.isDefaultLocation;
    }
}

