/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.resource;

import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.resource.ExtendedPath;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.resource.SdkFileResource;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.resource.SdkFolderResource;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.resource.SdkResource;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.resource.ResourceSdkCore;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkGroup;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkKind;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class SdkResourcesHolder {
    private final String toolChainId;
    private Map<ResourceSdkKind, Set<SdkResource>> resourcesByType;

    public SdkResourcesHolder(String toolChainId) {
        this.toolChainId = toolChainId;
        this.resourcesByType = new EnumMap<ResourceSdkKind, Set<SdkResource>>(ResourceSdkKind.class);
    }

    public void addResource(SdkResource resource) {
        this.resourcesByType.computeIfAbsent(resource.getType().getBaseKind(), s -> new LinkedHashSet()).add(resource);
    }

    public void addResource(Element element, String sdkBasePath) {
        LinkedHashSet<SdkResource> resources = new LinkedHashSet<SdkResource>();
        ResourceSdkKind baseKind = ResourceSdkKind.of((String)element.getNodeName()).getBaseKind();
        if (baseKind.isFolderKind()) {
            PathMatcher pathMatcher = SdkResourcesHolder.getResourcesPathMatcher(baseKind);
            SdkFolderResource resourceFolder = new SdkFolderResource(element, sdkBasePath, pathMatcher);
            resources.add(resourceFolder);
            resources.addAll(resourceFolder.getResources());
        } else {
            resources.add(new SdkFileResource(element, sdkBasePath));
        }
        resources.forEach(this::addResource);
    }

    public void addResource(ExtendedPath path, ResourceSdkKind resourceType) {
        LinkedHashSet<SdkResource> resources = new LinkedHashSet<SdkResource>();
        if (path.toFile().isDirectory()) {
            resources.add(new SdkFolderResource(resourceType, path, SdkResourcesHolder.getResourcesPathMatcher(resourceType)));
        } else {
            resources.add(new SdkFileResource(resourceType, path));
        }
        resources.forEach(this::addResource);
    }

    private static PathMatcher getResourcesPathMatcher(ResourceSdkKind baseKind) {
        PathMatcher pathMatcher = null;
        switch (baseKind) {
            case HEADER_FOLDER: {
                pathMatcher = ResourceSdkCore.headerFilesMatcher;
                break;
            }
            case RESOURCE_FOLDER: {
                pathMatcher = ResourceSdkCore.resourceFilesMatcher;
                break;
            }
            case SOURCE_FOLDER: {
                pathMatcher = ResourceSdkCore.sourceFilesMatcher;
            }
        }
        return pathMatcher;
    }

    public String getToolChainId() {
        return this.toolChainId;
    }

    public Map<ResourceSdkKind, Set<SdkResource>> getResources() {
        return this.resourcesByType;
    }

    public Set<SdkResource> getHeaders() {
        LinkedHashSet<SdkResource> result = new LinkedHashSet<SdkResource>();
        result.addAll(this.getResourcesByType(ResourceSdkKind.HEADER_FOLDER));
        Set<SdkResource> headerFileResources = this.getResourcesByType(ResourceSdkKind.HEADER_FILE);
        headerFileResources.addAll(this.getResourcesByType(ResourceSdkKind.RESOURCE_FILE).stream().filter(resource -> ResourceSdkCore.headerFilesMatcher.matches(Paths.get(resource.getPath().toFile().getAbsolutePath(), new String[0]))).collect(Collectors.toSet()));
        LinkedHashMap resourcesGrouppedByPath = new LinkedHashMap();
        headerFileResources.forEach(resource -> {
            boolean bl = resourcesGrouppedByPath.computeIfAbsent(resource.getPath(), s -> new ArrayList()).add(resource);
        });
        for (Map.Entry e : resourcesGrouppedByPath.entrySet()) {
            List resources = (List)e.getValue();
            if (resources == null || resources.isEmpty()) continue;
            SdkResource resourceToAdd = (SdkResource)resources.get(0);
            if (resources.size() > 1) {
                resourceToAdd = resources.stream().filter(resource -> resource.getPath().isCopy()).findFirst().orElse(resourceToAdd);
            }
            result.add(resourceToAdd);
        }
        return result;
    }

    public Set<SdkResource> getIncludeFiles() {
        return this.getResourcesByType(ResourceSdkKind.INCLUDE_FILE);
    }

    public Set<SdkResource> getBinaryFiles() {
        return this.getResourcesByType(ResourceSdkKind.BINARY_FILE);
    }

    public Set<SdkResource> getLinkerFiles() {
        return this.getResourcesByType(ResourceSdkKind.LINKER_FILE);
    }

    public Set<SdkResource> getResourceFiles() {
        return this.getResourcesByType(ResourceSdkKind.RESOURCE_FILE);
    }

    public Set<SdkResource> getUntypedResources() {
        LinkedHashSet<SdkResource> result = new LinkedHashSet<SdkResource>();
        result.addAll(this.getResourcesByType(ResourceSdkKind.RESOURCE_FOLDER));
        result.addAll(this.getResourcesByType(ResourceSdkKind.RESOURCE_FILE));
        return result;
    }

    public Set<SdkResource> getSources() {
        LinkedHashSet<SdkResource> result = new LinkedHashSet<SdkResource>();
        result.addAll(this.getResourcesByType(ResourceSdkKind.SOURCE_FOLDER));
        result.addAll(this.getResourcesByType(ResourceSdkKind.SOURCE_FILE));
        return result;
    }

    public Set<SdkResource> getResourceByType(ResourceSdkGroup type) {
        switch (type) {
            case BINARY_RESOURCES: {
                return this.getBinaryFiles();
            }
            case HEADER_RESOURCES: {
                return this.getHeaders();
            }
            case INCLUDE_FILE_RESOURCES: {
                return this.getIncludeFiles();
            }
            case LINKER_RESOURCES: {
                return this.getLinkerFiles();
            }
            case UNSPECIFIED_RESOURCES: {
                return this.getUntypedResources();
            }
            case SOURCE_RESOURCES: {
                return this.getSources();
            }
        }
        return Collections.emptySet();
    }

    public List<SdkResource> getAllResources() {
        return this.resourcesByType.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" BINARY FILES = ").append(this.getBinaryFiles());
        sb.append(" HEADERS = ").append(this.getHeaders());
        sb.append(" INCLUDE FILES = ").append(this.getIncludeFiles());
        sb.append(" LINKER FILES = ").append(this.getLinkerFiles());
        sb.append(" RESOURCES = ").append(this.getResourceFiles());
        sb.append(" SOURCES = ").append(this.getSources());
        return sb.toString();
    }

    private Set<SdkResource> getResourcesByType(ResourceSdkKind resourceType) {
        LinkedHashSet resources = this.resourcesByType.get(resourceType);
        return resources != null ? resources : new LinkedHashSet();
    }
}

