/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.module;

import com.nxp.s32ds.cle.cdt.sdk.internal.ui.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.SdkUiActivator;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.SdkDescriptorParser;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.ModelSdk;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.ToolChainHolder;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.module.SdkModule;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.resource.SdkResource;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.edit.model.resource.SdkResourcesHolder;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.module.ModuleSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class SdkModulesHolder {
    private final String sdkId;
    private Set<SdkModule> refModules;
    private Set<SdkResource> duplicatedResources;

    public SdkModulesHolder(String sdkId, String name, String description) {
        this.sdkId = Objects.requireNonNull(sdkId, "Holder SDK id shouldn't be null");
        this.refModules = new LinkedHashSet<SdkModule>();
        this.initRootModule(name, description);
        this.duplicatedResources = new HashSet<SdkResource>();
    }

    public Set<SdkModule> getRefModules() {
        return this.refModules;
    }

    public Set<SdkModule> getRefModules(String toolChainId) {
        if (toolChainId == null || toolChainId.isEmpty()) {
            return this.refModules;
        }
        return this.refModules.stream().filter(m -> m.checkToolChainCompatibility(toolChainId).isOK()).collect(Collectors.toSet());
    }

    public IStatus addRefModule(SdkModule refModule) {
        ModelSdk refModuleSdk = refModule.getSdk();
        if (refModuleSdk == null) {
            return Status.CANCEL_STATUS;
        }
        if (!ModuleSdkDescriptors.getModuleSdkDescriptorsBySdkId((String)refModuleSdk.getHeader().getId()).isEmpty()) {
            IStatus status = SdkUiActivator.getInstance().createError(NLS.bind((String)Messages.SdkModulesHolder_module_sdk_refers_to_other_modules, (Object)refModule.getId()), null);
            SdkUiActivator.getInstance().log(status);
            return status;
        }
        refModule.setHolderSdkId(this.sdkId);
        this.refModules.add(refModule);
        return Status.OK_STATUS;
    }

    @Deprecated
    public List<ModelSdk> getRefModulesSdks() {
        return this.refModules.stream().map(module -> SdkDescriptors.getSdkDescriptor((String)module.getSdkId())).filter(Objects::nonNull).map(SdkDescriptorParser::getSdkByDescriptor).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public boolean hasModules() {
        return !this.refModules.isEmpty();
    }

    public Map<String, List<SdkResourcesHolder>> getRefModulesSdksResources(ResourceSdkGroup resourceType, String toolChainId) {
        if (!this.hasModules()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, List<SdkResourcesHolder>> result = new LinkedHashMap<String, List<SdkResourcesHolder>>();
        for (SdkModule module : this.getRefModules(toolChainId)) {
            ModelSdk moduleSdk = module.getSdk();
            if (moduleSdk == null) continue;
            String moduleSdkId = moduleSdk.getHeader().getId();
            ToolChainHolder moduleSdkRoot = moduleSdk.getRoot();
            if (moduleSdkRoot == null) continue;
            moduleSdkRoot.getResourceByType(resourceType).forEach(resource -> {
                if (result.values().stream().flatMap(Collection::stream).flatMap(rh -> rh.getResourceByType(resourceType).stream()).anyMatch(r -> r.getPath().equals((Object)resource.getPath()))) {
                    this.duplicatedResources.add((SdkResource)resource);
                }
                SdkResourcesHolder moduleSdkResourceHolder = new SdkResourcesHolder(moduleSdkRoot.getTCId());
                moduleSdkRoot.getResourceByType(resourceType).forEach(moduleSdkResourceHolder::addResource);
                result.computeIfAbsent(moduleSdkId, s -> new ArrayList()).add(moduleSdkResourceHolder);
            });
        }
        return result;
    }

    private SdkModule initRootModule(String name, String description) {
        return new SdkModule(this.sdkId, name, description, this.sdkId);
    }
}

