/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.ui;

import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachStatuses;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.internal.ui.SdkUiActivator;
import com.nxp.s32ds.cle.ide.sdk.ProjectSdkDescriptor;
import com.nxp.s32ds.cle.ide.sdk.core.ProjectSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkType;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public abstract class SdkPageLabelProvider
extends CellLabelProvider {
    public static CellLabelProvider getNameLabelProvider() {
        return new SdkPageLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof SdkDescriptor) {
                    cell.setText(((SdkDescriptor)element).getName());
                }
            }
        };
    }

    public static CellLabelProvider getVersionLabelProvider() {
        return new SdkPageLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof SdkDescriptor) {
                    cell.setText(((SdkDescriptor)element).getVersion());
                }
            }
        };
    }

    public static CellLabelProvider getBasePathLabelProvider() {
        return new SdkPageLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof SdkDescriptor) {
                    cell.setText(((SdkDescriptor)element).getBasePath());
                }
            }
        };
    }

    public static CellLabelProvider getDescriptionLabelProvider() {
        return new SdkPageLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof SdkDescriptor) {
                    cell.setText(((SdkDescriptor)element).getDescription());
                }
            }

            public String getToolTipText(Object element) {
                if (element instanceof SdkDescriptor) {
                    return ((SdkDescriptor)element).getDescription();
                }
                return element.toString();
            }

            public boolean useNativeToolTip(Object element) {
                return true;
            }
        };
    }

    public static CellLabelProvider getStatusLabelProvider(Map<String, List<IStatus>> data) {
        return new StatusCellLabelProvider(data);
    }

    public static CellLabelProvider getHardwareLabelProvider(final String hardwareParameter) {
        return new SdkPageLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof SdkDescriptor) {
                    cell.setText(this.getHardwareIds(((SdkDescriptor)element).getId()));
                }
            }

            private String getHardwareIds(String sdkId) {
                return String.join((CharSequence)" ", SdkManagementUtils.getSdkHardwareIds((String)sdkId, (String)hardwareParameter));
            }
        };
    }

    public CellLabelProvider getCfgCellLabelProvider(int idx, Map<String, List<IStatus>> data) {
        return new CfgCellLabelProvider(idx, data);
    }

    public static EditingSupport getCfgEditingSupport(ColumnViewer viewer, int num, Map<String, List<IStatus>> data) {
        return new CfgEditingSupport(viewer, num, data);
    }

    public static class CfgCellLabelProvider
    extends CellLabelProvider {
        private static final Map<IStatus, String> IMAGES_MAP = new HashMap<IStatus, String>();
        private final Map<String, List<IStatus>> data;
        private final int idx;

        public CfgCellLabelProvider(int idx, Map<String, List<IStatus>> data) {
            IMAGES_MAP.put(SdkAttachStatuses.OK_SDK_NOT_ATTACHED, "SDK_COMMON_BLANK_ICON");
            IMAGES_MAP.put(SdkAttachStatuses.OK_SDK_ATTACHED, "SDK_COMMON_PLUS_ICON");
            IMAGES_MAP.put(SdkAttachStatuses.ERROR_SDK_PROCESSOR_CORE, "SDK_ATTACH_HARDWARE_ERROR_ICON");
            IMAGES_MAP.put(SdkAttachStatuses.ERROR_PROJECT_ROOT_FILE_CONFLICT, "SDK_ATTACH_DUPLICATED_FILE_ERROR_ICON");
            IMAGES_MAP.put(SdkAttachStatuses.ERROR_SDK_LANGUAGE, "SDK_ATTACH_LANGUAGE_ERROR_ICON");
            IMAGES_MAP.put(SdkAttachStatuses.ERROR_SDK_TOOLCHAIN, "SDK_ATTACH_TOOLCHAIN_ERROR_ICON");
            IMAGES_MAP.put(SdkAttachStatuses.ERROR_SDK_LOCATION, "SDK_ATTACH_LOCATION_ERROR_ICON");
            IMAGES_MAP.put(SdkAttachStatuses.ERROR_SDK_PLATFORM, "ERROR_PLATFORM_ICON");
            IMAGES_MAP.put(SdkAttachStatuses.ERROR_NO_MODULES_TO_ATTACH, "SDK_COMMON_CROSS_ICON");
            IMAGES_MAP.put(SdkAttachStatuses.ERROR_UNKNOWN, "SDK_COMMON_ERROR_ICON");
            IMAGES_MAP.put(SdkAttachStatuses.ERROR_SDK_PROJECT, "SDK_COMMON_ERROR_ICON");
            IMAGES_MAP.put(SdkAttachStatuses.ERROR_SDK_MISSED, "SDK_COMMON_ERROR_ICON");
            this.idx = idx;
            this.data = data;
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            if (element instanceof SdkDescriptor) {
                List<IStatus> sdkAttachStatuses = this.data.get(((SdkDescriptor)element).getId());
                if (sdkAttachStatuses == null) {
                    cell.setImage(this.getImage(SdkAttachStatuses.OK_SDK_NOT_ATTACHED));
                } else {
                    cell.setImage(this.getImage(sdkAttachStatuses.get(this.idx)));
                }
            }
        }

        public String getToolTipText(Object element) {
            List<IStatus> sdkAttachStatuses;
            if (element instanceof SdkDescriptor && (sdkAttachStatuses = this.data.get(((SdkDescriptor)element).getId())) != null && sdkAttachStatuses.size() > this.idx) {
                return sdkAttachStatuses.get(this.idx).getMessage();
            }
            return element.toString();
        }

        protected Image getImage(IStatus status) {
            return SdkUiActivator.getInstance().getImage(IMAGES_MAP.get(status));
        }
    }

    public static class CfgEditingSupport
    extends EditingSupport {
        private final CheckboxCellEditor editor = new CheckboxCellEditor();
        private final int number;
        private final Map<String, List<IStatus>> data;

        public CfgEditingSupport(ColumnViewer viewer, int num, Map<String, List<IStatus>> map) {
            super(viewer);
            this.number = num;
            this.data = map;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            return this.getValue(element);
        }

        protected Boolean getValue(Object element) {
            if (!(element instanceof SdkDescriptor)) {
                return false;
            }
            List<IStatus> statuses = this.data.get(((SdkDescriptor)element).getId());
            if (statuses == null || this.number >= statuses.size()) {
                return false;
            }
            IStatus status = statuses.get(this.number);
            if (status != null && status.isOK()) {
                return true;
            }
            return false;
        }

        protected void setValue(Object element, Object value) {
            if (this.getValue(element).booleanValue()) {
                String sdkId = ((SdkDescriptor)element).getId();
                List<IStatus> statuses = this.data.get(sdkId);
                IStatus currentStatus = statuses.get(this.number);
                if (currentStatus == null) {
                    return;
                }
                statuses.set(this.number, CfgEditingSupport.getChangedAttachStatus(currentStatus));
                this.data.put(sdkId, statuses);
                this.getViewer().refresh();
            }
        }

        private static IStatus getChangedAttachStatus(IStatus status) {
            if (status != null) {
                if (status.equals(SdkAttachStatuses.OK_SDK_ATTACHED)) {
                    return SdkAttachStatuses.OK_SDK_NOT_ATTACHED;
                }
                if (status.equals(SdkAttachStatuses.OK_SDK_NOT_ATTACHED)) {
                    return SdkAttachStatuses.OK_SDK_ATTACHED;
                }
            }
            return status;
        }
    }

    private static class StatusCellLabelProvider
    extends CellLabelProvider {
        private Map<String, List<IStatus>> data;

        private StatusCellLabelProvider(Map<String, List<IStatus>> data) {
            this.data = data == null ? Collections.emptyMap() : data;
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            if (element instanceof SdkDescriptor) {
                cell.setText(this.getSdkTypeString((SdkDescriptor)element));
            }
        }

        private String getSdkTypeString(SdkDescriptor sdkDescriptor) {
            List<IStatus> statuses = this.data.get(sdkDescriptor.getId());
            if (statuses != null && statuses.contains(SdkAttachStatuses.ERROR_SDK_MISSED)) {
                return SdkType.UNKNOWN.getName();
            }
            SdkType sdkType = sdkDescriptor.getType();
            if (SdkType.PROJECT_LOCAL == sdkType) {
                ProjectSdkDescriptor projectLocalSdk = ProjectSdkDescriptors.getProjectSdkDescriptorBySdkId((String)sdkDescriptor.getId());
                String projectName = "?";
                if (projectLocalSdk != null) {
                    projectName = projectLocalSdk.getProjectName();
                }
                return NLS.bind((String)"{0} ({1})", (Object)sdkType.getName(), (Object)(projectName.isEmpty() ? "?" : projectName));
            }
            return sdkType.getName();
        }
    }
}

