/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.launching;

import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.LaunchUIMessages;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.ILaunchTargetManager;
import org.eclipse.launchbar.core.target.ILaunchTargetWorkingCopy;
import org.eclipse.launchbar.ui.target.LaunchTargetWizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewGdbRemoteTCPTargetWizard
extends LaunchTargetWizard {
    private Button sameAsHostname;
    private Text nameText;
    private Text hostText;
    private Text portText;

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)new TCPPage());
    }

    public boolean performFinish() {
        ILaunchTargetManager manager = GdbUIPlugin.getService(ILaunchTargetManager.class);
        String id = this.nameText.getText();
        ILaunchTarget target = this.getLaunchTarget();
        if (target == null) {
            target = manager.addLaunchTarget("org.eclipse.cdt.dsf.gdb.remoteTCPLaunchTargetType", id);
        }
        ILaunchTargetWorkingCopy wc = target.getWorkingCopy();
        wc.setId(id);
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.HOST", this.hostText.getText());
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.PORT", this.portText.getText());
        wc.save();
        return true;
    }

    public boolean canDelete() {
        return true;
    }

    public void performDelete() {
        ILaunchTargetManager manager = GdbUIPlugin.getService(ILaunchTargetManager.class);
        ILaunchTarget target = this.getLaunchTarget();
        if (target != null) {
            manager.removeLaunchTarget(target);
        }
    }

    private class TCPPage
    extends WizardPage {
        public TCPPage() {
            super(NewGdbRemoteTCPTargetWizard.class.getName());
            this.setTitle(LaunchUIMessages.getString("NewGdbRemoteTCPTargetWizard.Title"));
            this.setDescription(LaunchUIMessages.getString("NewGdbRemoteTCPTargetWizard.Desc"));
        }

        public void createControl(Composite parent) {
            Composite control = new Composite(parent, 0);
            control.setLayout((Layout)new GridLayout());
            Group nameGroup = new Group(control, 0);
            nameGroup.setText(LaunchUIMessages.getString("NewGdbRemoteTCPTargetWizard.NameGroup"));
            nameGroup.setLayout((Layout)new GridLayout(2, false));
            nameGroup.setLayoutData((Object)new GridData(768));
            NewGdbRemoteTCPTargetWizard.this.sameAsHostname = new Button((Composite)nameGroup, 32);
            NewGdbRemoteTCPTargetWizard.this.sameAsHostname.setText(LaunchUIMessages.getString("NewGdbRemoteTCPTargetWizard.SameAsHost"));
            GridData gridData = new GridData();
            gridData.horizontalSpan = 2;
            NewGdbRemoteTCPTargetWizard.this.sameAsHostname.setLayoutData((Object)gridData);
            NewGdbRemoteTCPTargetWizard.this.sameAsHostname.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean same = ((TCPPage)TCPPage.this).NewGdbRemoteTCPTargetWizard.this.sameAsHostname.getSelection();
                    if (same) {
                        ((TCPPage)TCPPage.this).NewGdbRemoteTCPTargetWizard.this.nameText.setText(((TCPPage)TCPPage.this).NewGdbRemoteTCPTargetWizard.this.hostText.getText());
                    }
                    ((TCPPage)TCPPage.this).NewGdbRemoteTCPTargetWizard.this.nameText.setEnabled(!same);
                }
            });
            NewGdbRemoteTCPTargetWizard.this.sameAsHostname.setSelection(true);
            Label nameLabel = new Label((Composite)nameGroup, 0);
            nameLabel.setText(LaunchUIMessages.getString("NewGdbRemoteTCPTargetWizard.TargetName"));
            NewGdbRemoteTCPTargetWizard.this.nameText = new Text((Composite)nameGroup, 2048);
            NewGdbRemoteTCPTargetWizard.this.nameText.setLayoutData((Object)new GridData(768));
            NewGdbRemoteTCPTargetWizard.this.nameText.setEnabled(false);
            NewGdbRemoteTCPTargetWizard.this.nameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TCPPage.this.validatePage();
                }
            });
            Group connGroup = new Group(control, 0);
            connGroup.setText(LaunchUIMessages.getString("NewGdbRemoteTCPTargetWizard.ConnectionGroup"));
            connGroup.setLayout((Layout)new GridLayout(4, false));
            connGroup.setLayoutData((Object)new GridData(768));
            Label hostLabel = new Label((Composite)connGroup, 0);
            hostLabel.setText(LaunchUIMessages.getString("NewGdbRemoteTCPTargetWizard.HostName"));
            NewGdbRemoteTCPTargetWizard.this.hostText = new Text((Composite)connGroup, 2048);
            NewGdbRemoteTCPTargetWizard.this.hostText.setLayoutData((Object)new GridData(768));
            NewGdbRemoteTCPTargetWizard.this.hostText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (((TCPPage)TCPPage.this).NewGdbRemoteTCPTargetWizard.this.sameAsHostname.getSelection()) {
                        ((TCPPage)TCPPage.this).NewGdbRemoteTCPTargetWizard.this.nameText.setText(((TCPPage)TCPPage.this).NewGdbRemoteTCPTargetWizard.this.hostText.getText());
                    }
                    TCPPage.this.validatePage();
                }
            });
            Label portLabel = new Label((Composite)connGroup, 0);
            portLabel.setText(LaunchUIMessages.getString("NewGdbRemoteTCPTargetWizard.Port"));
            NewGdbRemoteTCPTargetWizard.this.portText = new Text((Composite)connGroup, 2048);
            NewGdbRemoteTCPTargetWizard.this.portText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TCPPage.this.validatePage();
                }
            });
            this.setControl((Control)control);
            this.validatePage();
        }

        private void validatePage() {
            this.setPageComplete(false);
            if (NewGdbRemoteTCPTargetWizard.this.hostText.getText().isEmpty()) {
                this.setErrorMessage(LaunchUIMessages.getString("NewGdbRemoteTCPTargetWizard.NoHost"));
                return;
            }
            String port = NewGdbRemoteTCPTargetWizard.this.portText.getText();
            if (port.isEmpty()) {
                this.setErrorMessage(LaunchUIMessages.getString("NewGdbRemoteTCPTargetWizard.NoPort"));
                return;
            }
            try {
                Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                this.setErrorMessage(LaunchUIMessages.getString("NewGdbRemoteTCPTargetWizard.PortNotANumber"));
                return;
            }
            if (NewGdbRemoteTCPTargetWizard.this.nameText.getText().isEmpty()) {
                this.setErrorMessage(LaunchUIMessages.getString("NewGdbRemoteTCPTargetWizard.NoName"));
                return;
            }
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }
}

