/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.memory.spaces.dsf;

import com.nxp.s32ds.cle.cdt.memory.spaces.base.MemoryAccessor;
import com.nxp.s32ds.cle.cdt.memory.spaces.base.MemorySpace;
import com.nxp.s32ds.cle.cdt.memory.spaces.dsf.S32DbgMemoryRetrieval;
import com.nxp.s32ds.cle.cdt.memory.spaces.internal.base.MemorySpaceActivator;
import com.nxp.s32ds.cle.cdt.memory.spaces.internal.base.Messages;
import com.nxp.s32ds.ext.cdt.dsf.DsfResponse;
import java.math.BigInteger;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.cdt.dsf.debug.model.DsfMemoryBlock;
import org.eclipse.cdt.dsf.debug.model.DsfMemoryBlockRetrieval;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.osgi.util.NLS;

public class S32DbgMemoryBlock
extends DsfMemoryBlock {
    private MemorySpace memorySpace;
    private MemoryAccessor memoryAccessor;

    protected S32DbgMemoryBlock(S32DbgMemoryRetrieval retrieval, IMemory.IMemoryDMContext context, String expression, BigInteger address, int word_size) {
        super((DsfMemoryBlockRetrieval)retrieval, context, retrieval.getModelId(), expression, address, word_size, -1L);
    }

    protected MemoryByte[] fetchMemoryBlock(BigInteger bigAddress, long count) throws DebugException {
        if (!this.memorySpace.isEnabled()) {
            return new MemoryByte[0];
        }
        MemorySpace memSpaceLocal = this.memorySpace.getWorkingCopy();
        memSpaceLocal.setBaseAddress(bigAddress);
        memSpaceLocal.setDataSize(count * (long)this.getAddressableSize());
        CompletableFuture<DsfResponse<MemorySpace, MemoryByte[]>> future = this.memoryAccessor.scheduleReadRequest(memSpaceLocal);
        if (future != null) {
            try {
                DsfResponse<MemorySpace, MemoryByte[]> response = future.get();
                if (response == null || response.throwable != null) {
                    return new MemoryByte[0];
                }
                return (MemoryByte[])response.result;
            }
            catch (InterruptedException | ExecutionException e) {
                MemorySpaceActivator.getInstance().logError(NLS.bind((String)Messages.DsfRequest_exception_memory_reading, (Object)e.getMessage()));
            }
        }
        return new MemoryByte[0];
    }

    protected void writeMemoryBlock(long offset, byte[] bytes) throws DebugException {
        MemorySpace memSpaceLocal = this.memorySpace.getWorkingCopy();
        memSpaceLocal.setBaseAddress(this.getBigBaseAddress().add(BigInteger.valueOf(offset)));
        memSpaceLocal.setDataSize(bytes.length);
        CompletableFuture<DsfResponse<MemorySpace, MemoryByte[]>> future = this.memoryAccessor.scheduleWriteRequest(memSpaceLocal, bytes);
        if (future != null) {
            try {
                DsfResponse<MemorySpace, MemoryByte[]> response = future.get();
                if (response != null && response.throwable != null) {
                    return;
                }
                this.handleMemoryChange(memSpaceLocal.getBaseAddress());
            }
            catch (InterruptedException | ExecutionException e) {
                MemorySpaceActivator.getInstance().logError(NLS.bind((String)Messages.DsfRequest_exception_memory_writing, (Object)e.getMessage()));
            }
        }
    }

    public boolean supportsValueModification() {
        return true;
    }

    public void setMemorySpace(MemorySpace memorySpace) {
        this.memorySpace = memorySpace;
    }

    public void setMemoryAccessor(MemoryAccessor accessor) {
        this.memoryAccessor = accessor;
    }

    public MemorySpace getMemorySpace() {
        return this.memorySpace;
    }

    public String getModelIdentifier() {
        return super.getModelIdentifier();
    }
}

