/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.debugger.svd;

import com.nxp.s32ds.cle.ide.debugger.internal.svd.DebuggerSvdActivator;
import com.nxp.s32ds.cle.ide.debugger.internal.svd.Messages;
import com.nxp.s32ds.cle.ide.debugger.svd.SvdSource;
import com.nxp.s32ds.cle.ide.debugger.svd.SvdSourceType;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;

public class SvdPathSource
implements SvdSource {
    private final SvdSourceType type;
    private final Path path;

    public SvdPathSource(SvdSourceType type, String path) throws CoreException {
        this.type = type;
        try {
            Path pathResolved;
            this.path = pathResolved = Paths.get(path, new String[0]);
        }
        catch (InvalidPathException e) {
            throw new CoreException(DebuggerSvdActivator.getInstance().createError(NLS.bind((String)Messages.SvdPathSource_invalid_path_to_svd_0, (Object)path), e));
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream newInputStream = Files.newInputStream(this.path, new OpenOption[0]);
        return newInputStream;
    }

    @Override
    public String getUID() {
        return this.path.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.path.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SvdPathSource other = (SvdPathSource)obj;
        return this.path.equals(other.path);
    }

    @Override
    public SvdSourceType getType() {
        return this.type;
    }
}

