/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.dcd.model.settings;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.dcd.model.settings.IRegisterSetting;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;

public class CustomRegisterSetting
implements IRegisterSetting {
    @Element(name="address")
    protected RegisterCommonElement address;
    @Element(name="mask")
    protected RegisterCommonElement mask;

    public CustomRegisterSetting() {
        this(new RegisterCommonElement(), new RegisterCommonElement());
    }

    public CustomRegisterSetting(RegisterCommonElement address, RegisterCommonElement mask) {
        this.address = address;
        this.mask = mask;
    }

    public RegisterCommonElement getAddress() {
        return this.address;
    }

    @Override
    public int getAddressSize() {
        return this.address.getSize();
    }

    public void setAddress(RegisterCommonElement address) {
        this.address = address;
    }

    public RegisterCommonElement getMask() {
        return this.mask;
    }

    @Override
    public int getValueSize() {
        return this.mask.getSize();
    }

    public void setMask(RegisterCommonElement mask) {
        this.mask = mask;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.address);
        result = 31 * result + Objects.hashCode(this.mask);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomRegisterSetting other = (CustomRegisterSetting)obj;
        return Objects.equals(this.address, other.address) && Objects.equals(this.mask, other.mask);
    }

    public static class RegisterCommonElement {
        @Attribute(name="size")
        private int size;
        @Attribute(name="byte_order", required=false)
        private String byteOrder = "be";

        public RegisterCommonElement() {
            this(0);
        }

        public RegisterCommonElement(int size) {
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public String getByteOrder() {
            return this.byteOrder;
        }

        public void setByteOrder(String byteOrder) {
            this.byteOrder = byteOrder;
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + Objects.hashCode(this.byteOrder);
            return result;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            assert (obj != null);
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RegisterCommonElement other = (RegisterCommonElement)obj;
            return this.size == other.size && Objects.equals(this.byteOrder, other.byteOrder);
        }
    }
}

