/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.examples.core;

import com.nxp.s32ds.ext.ide.examples.core.IExampleObject;
import com.nxp.s32ds.ext.ide.examples.core.IVisualComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class VisualComponent
implements IVisualComponent {
    private String name;
    private List<IVisualComponent> listCategory = new ArrayList<IVisualComponent>();
    private List<IExampleObject> listObjects = new ArrayList<IExampleObject>();

    public VisualComponent() {
    }

    public VisualComponent(String name) {
        this.name = name;
    }

    @Override
    public String getVisualComponentName() {
        return this.name;
    }

    @Override
    public List<IExampleObject> getChildObjects() {
        return this.listObjects;
    }

    @Override
    public List<IVisualComponent> getGroups() {
        return this.listCategory;
    }

    @Override
    public void addChild(IExampleObject child) {
        this.listObjects.add(child);
    }

    @Override
    public void addGroup(VisualComponent subNode) {
        this.listCategory.add(subNode);
    }

    public String toString() {
        return this.name;
    }

    public IVisualComponent findGroupByName(IVisualComponent rootNode, String categoryName) {
        Stack<IVisualComponent> stackElements = new Stack<IVisualComponent>();
        if (rootNode == null) {
            stackElements.add(this);
        } else {
            stackElements.add(rootNode);
        }
        while (!stackElements.isEmpty()) {
            IVisualComponent component = (IVisualComponent)stackElements.pop();
            if (component.getVisualComponentName().equals(categoryName)) {
                return component;
            }
            if (component.getGroups() == null || component.getGroups().isEmpty()) continue;
            stackElements.addAll(component.getGroups());
        }
        return null;
    }

    public void addNewItems(String group, IExampleObject object) {
        String[] groupSection = null;
        if (group.isEmpty()) {
            this.addChild(object);
            return;
        }
        try {
            groupSection = group.split(";");
        }
        catch (Exception exception) {
            groupSection = new String[]{group};
        }
        IVisualComponent nodeGroupComponent = null;
        String[] stringArray = groupSection;
        int n = groupSection.length;
        int n2 = 0;
        while (n2 < n) {
            String groupItemName = stringArray[n2];
            IVisualComponent groupComponent = this.findGroupByName(nodeGroupComponent, groupItemName);
            if (groupComponent == null && nodeGroupComponent == null) {
                nodeGroupComponent = new VisualComponent(groupItemName);
                this.listCategory.add(nodeGroupComponent);
            } else if (groupComponent == null && nodeGroupComponent != null) {
                VisualComponent subNodeGroupComponent = new VisualComponent(groupItemName);
                nodeGroupComponent.addGroup(subNodeGroupComponent);
                nodeGroupComponent = subNodeGroupComponent;
            } else if (groupComponent != null) {
                nodeGroupComponent = groupComponent;
            }
            ++n2;
        }
        if (nodeGroupComponent != null) {
            nodeGroupComponent.addChild(object);
        }
    }
}

