/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.examples.core;

import com.nxp.s32ds.ext.ide.examples.core.IExampleComponent;
import com.nxp.s32ds.ext.ide.examples.internal.core.ExampleComponentBuilder;
import com.nxp.s32ds.ext.ide.examples.internal.core.ExampleCoreActivator;
import com.nxp.s32ds.ext.ide.examples.internal.core.ExampleProjectLoaderUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;

public class ExampleComponentProvider {
    public static final String DESCRIPTION_FILE = "description.txt";
    public static final String SPLITTER = "_";
    private static final List<String> PATH_EXCLUSIONS = Arrays.asList("Vision SDK");
    private static final String FAMILY_ID = "com.nxp.s32ds.cle.runtime.hardware.registry.family.id";
    private static final String DEVICE_ID = "com.nxp.s32ds.cle.runtime.hardware.registry.device.id";
    private static final String CORE_ID = "com.nxp.s32ds.cle.runtime.hardware.registry.core.id";

    private ExampleComponentProvider() {
    }

    public static IExampleComponent getModelObject(File projectFile, String groupFolder) {
        IProjectDescription projectDescription;
        Path path;
        block4: {
            if (!projectFile.exists()) {
                return null;
            }
            try {
                path = new Path(projectFile.getAbsolutePath());
                projectDescription = ExampleProjectLoaderUtils.getProjectDescriptorByPath((IPath)path);
                if (projectDescription != null) break block4;
                return null;
            }
            catch (CoreException e) {
                ExampleCoreActivator.getInstance().log(e.getStatus());
                return null;
            }
        }
        IPath projectDirPath = path.removeLastSegments(1);
        String id = ExampleComponentProvider.extractId(projectDescription, path);
        List<String> descriptions = ExampleComponentProvider.extractDescription(projectDirPath);
        String shortComment = ExampleComponentProvider.extractShortComment(descriptions);
        String familyId = ExampleProjectLoaderUtils.getExamplePropertyByPath(projectDirPath, FAMILY_ID);
        String deviceId = ExampleProjectLoaderUtils.getExamplePropertyByPath(projectDirPath, DEVICE_ID);
        String coreId = ExampleProjectLoaderUtils.getExamplePropertyByPath(projectDirPath, CORE_ID);
        return new ExampleComponentBuilder().with(builder -> {
            builder.setId(id);
            builder.setProjectName(projectDescription.getName());
            builder.setLocation(projectFile.getAbsolutePath());
            builder.setGroup(groupFolder);
            builder.setFamilyId(familyId);
            builder.setDeviceId(deviceId);
            builder.setCoreId(coreId);
            builder.setDescription(descriptions);
            builder.setShortComment(shortComment);
            builder.setRelatedProjects(projectDescription.getReferencedProjects());
            builder.setProjectDescriptor(projectDescription);
        }).createExampleComponent();
    }

    private static String extractId(IProjectDescription projectDescription, Path path) {
        if (projectDescription.getReferencedProjects().length == 0) {
            return projectDescription.getName();
        }
        int fileNameSegment = ExampleComponentProvider.exclusivePath(path) ? 2 : 3;
        int groupSegmentCount = path.segmentCount() - fileNameSegment;
        if (groupSegmentCount > 0) {
            String rootName = path.segment(groupSegmentCount);
            if (ExampleComponentProvider.exclusivePath(path) || projectDescription.getName().startsWith(rootName)) {
                return rootName;
            }
            return ExampleComponentProvider.extractNameByRelatedProjects(projectDescription, rootName);
        }
        return projectDescription.getName();
    }

    private static String extractNameByRelatedProjects(IProjectDescription projectDescription, String rootName) {
        String expected = rootName;
        String[] baseSegments = projectDescription.getName().split(SPLITTER);
        int equalSegmentsCount = baseSegments.length;
        IProject[] iProjectArray = projectDescription.getReferencedProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            String[] localSegments = project.getName().split(SPLITTER);
            int i = 0;
            while (i < localSegments.length) {
                if (!baseSegments[i].equals(localSegments[i])) {
                    if (i >= equalSegmentsCount) break;
                    equalSegmentsCount = i;
                    break;
                }
                ++i;
            }
            ++n2;
        }
        if (equalSegmentsCount > 0) {
            CharSequence[] resSegments = Arrays.copyOf(baseSegments, equalSegmentsCount);
            expected = String.join((CharSequence)SPLITTER, resSegments);
        }
        return expected;
    }

    private static boolean exclusivePath(Path path) {
        return PATH_EXCLUSIONS.stream().anyMatch(p -> path.toString().contains((CharSequence)p));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<String> extractDescription(IPath pathFile) throws CoreException {
        Object path;
        ArrayList<String> multiLineDescription = new ArrayList<String>();
        File descriptionFile = null;
        if (!pathFile.toFile().exists()) return multiLineDescription;
        descriptionFile = ExampleComponentProvider.findDescritionFile(pathFile);
        if (descriptionFile == null) {
            path = pathFile.removeLastSegments(1);
            descriptionFile = ExampleComponentProvider.findDescritionFile((IPath)path);
        }
        if (descriptionFile == null) return multiLineDescription;
        try {
            path = null;
            Object var4_6 = null;
            try {
                FileInputStream is = new FileInputStream(descriptionFile);
                try {
                    try (BufferedReader buf = new BufferedReader(new InputStreamReader((InputStream)is, StandardCharsets.UTF_8));){
                        String line = buf.readLine();
                        while (line != null) {
                            multiLineDescription.add(line);
                            line = buf.readLine();
                        }
                    }
                    if (is == null) return multiLineDescription;
                }
                catch (Throwable throwable) {
                    if (path == null) {
                        path = throwable;
                    } else if (path != throwable) {
                        ((Throwable)path).addSuppressed(throwable);
                    }
                    if (is == null) throw path;
                    ((InputStream)is).close();
                    throw path;
                }
                ((InputStream)is).close();
                return multiLineDescription;
            }
            catch (Throwable throwable) {
                if (path == null) {
                    path = throwable;
                    throw path;
                } else {
                    if (path == throwable) throw path;
                    ((Throwable)path).addSuppressed(throwable);
                }
                throw path;
            }
        }
        catch (IOException e) {
            IStatus status = ExampleCoreActivator.getInstance().createError(e.getMessage(), e);
            throw new CoreException(status);
        }
    }

    private static File findDescritionFile(IPath pathFile) {
        File descriptionFile = null;
        File[] fileArray = pathFile.toFile().listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File iter = fileArray[n2];
            if (iter.getName().equals(DESCRIPTION_FILE)) {
                descriptionFile = iter;
                break;
            }
            ++n2;
        }
        return descriptionFile;
    }

    private static String extractShortComment(List<String> descriptions) {
        if (!descriptions.isEmpty()) {
            return descriptions.get(0);
        }
        return null;
    }
}

