/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.debug.s32debugger.ui.fixes;

import com.nxp.s32ds.cle.debug.s32debugger.internal.ui.ResolverMessages;
import com.nxp.s32ds.cle.debug.s32debugger.ui.fixes.S32DebuggerLaunchConfigurationGenericQuickFix;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;

public class S32DebuggerFlashCapableLaunchConfigurationQuickFix
extends S32DebuggerLaunchConfigurationGenericQuickFix {
    private static final String MARKER_TYPE = "com.nxp.s32ds.cle.debug.s32debugger.flash.validation.capable.launch.marker";
    private static final String ATTR_DEPR_BINARIES_LIST = "com.nxp.s32ds.debug.ide.s32debugger.flash.core.projectBinariesList";
    private static final String ATTR_ID_TO_BINARY_MAP = "com.nxp.s32ds.debug.ide.s32debugger.flash.core.projectIdToBinaryMap";
    private static final String ATTR_DEPR_BINARIES_ENABLED_MAP = "com.nxp.s32ds.debug.ide.s32debugger.flash.core.binariesEnabledMap";
    private static final String ATTR_BINARY_IS_ENABLED_MAP = "com.nxp.s32ds.debug.ide.s32debugger.flash.core.binaryIsEnabledMap";
    private static final String ATTR_DEPR_BINARY_TO_BASE_ADDRESS_MAP = "com.nxp.s32ds.debug.ide.s32debugger.flash.core.binaryToBaseAddressMap";
    private static final String ATTR_BINARY_ID_TO_BASE_ADDRESS_MAP = "com.nxp.s32ds.debug.ide.s32debugger.flash.core.binaryIdToBaseAddressMap";
    private static final String ATTR_DEPR_BINARY_TO_PROJECT_NAME_MAP = "com.nxp.s32ds.debug.ide.s32debugger.flash.core.binaryToProjectNameMap";
    private static final String ATTR_BINARY_ID_TO_PROJECT_NAME_MAP = "com.nxp.s32ds.debug.ide.s32debugger.flash.core.binaryIdToProjectNameMap";

    public S32DebuggerFlashCapableLaunchConfigurationQuickFix(String label, IMarker marker) {
        super(label, marker);
    }

    public String getDescription() {
        return ResolverMessages.S32DebuggerFlashCapableLaunchConfigurationMarker_fixDescription;
    }

    @Override
    protected void resolveLaunchConfiguration(IFile launchConfigFile) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration launchConfig = manager.getLaunchConfiguration(launchConfigFile);
        List binariesList = launchConfig.getAttribute(ATTR_DEPR_BINARIES_LIST, new ArrayList());
        Map binariesEnabledMap = launchConfig.getAttribute(ATTR_DEPR_BINARIES_ENABLED_MAP, new HashMap());
        Map binaryToBaseAddressMap = launchConfig.getAttribute(ATTR_DEPR_BINARY_TO_BASE_ADDRESS_MAP, new HashMap());
        Map binaryToProjectNameMap = launchConfig.getAttribute(ATTR_DEPR_BINARY_TO_PROJECT_NAME_MAP, new HashMap());
        HashMap<String, String> binaryToIdList = new HashMap<String, String>();
        HashMap<String, String> binaryIsEnabledMap = new HashMap<String, String>();
        HashMap<String, String> binaryIdToBaseAddressMap = new HashMap<String, String>();
        HashMap<String, String> binaryIdToProjectNameMap = new HashMap<String, String>();
        int i = 0;
        while (i < binariesList.size()) {
            String key = String.valueOf(i);
            String value = (String)binariesList.get(i);
            binaryToIdList.put(key, value);
            binaryIsEnabledMap.put(key, (String)binariesEnabledMap.get(value));
            binaryIdToBaseAddressMap.put(key, (String)binaryToBaseAddressMap.get(value));
            binaryIdToProjectNameMap.put(key, (String)binaryToProjectNameMap.get(value));
            ++i;
        }
        ILaunchConfigurationWorkingCopy lcCopy = launchConfig.copy(launchConfig.getName());
        lcCopy.removeAttribute(ATTR_DEPR_BINARIES_LIST);
        lcCopy.removeAttribute(ATTR_DEPR_BINARIES_ENABLED_MAP);
        lcCopy.removeAttribute(ATTR_DEPR_BINARY_TO_BASE_ADDRESS_MAP);
        lcCopy.removeAttribute(ATTR_DEPR_BINARY_TO_PROJECT_NAME_MAP);
        lcCopy.setAttribute(ATTR_ID_TO_BINARY_MAP, binaryToIdList);
        lcCopy.setAttribute(ATTR_BINARY_IS_ENABLED_MAP, binaryIsEnabledMap);
        lcCopy.setAttribute(ATTR_BINARY_ID_TO_BASE_ADDRESS_MAP, binaryIdToBaseAddressMap);
        lcCopy.setAttribute(ATTR_BINARY_ID_TO_PROJECT_NAME_MAP, binaryIdToProjectNameMap);
        lcCopy.doSave();
    }

    @Override
    protected String getMarkerType() {
        return MARKER_TYPE;
    }
}

