/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.sdk.registry.core.resource;

import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.Messages;
import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.SdkRegistryCoreActivator;
import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.resource.BinaryResourceSdkDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.resource.ResourceSdkDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkRegistryLogger;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.toolchain.ToolChainSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkGroup;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkKind;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkRegistry;
import com.nxp.s32ds.cle.runtime.sdk.registry.toolchain.ToolChainSdkDescriptor;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ResourceSdkDescriptors {
    private ResourceSdkDescriptors() {
    }

    public static ResourceSdkRegistry getResourceSdkRegistry() {
        return SdkRegistryCoreActivator.getInstance().getResourceSdkRegistry();
    }

    public static List<ResourceSdkDescriptor> getResourceSdkDescriptors() {
        return ResourceSdkDescriptors.getResourceSdkRegistry().getResourceSdkDescriptors();
    }

    public static List<ResourceSdkDescriptor> getResourceSdkDescriptorsByPath(String resourceId) {
        return ResourceSdkDescriptors.getResourceSdkRegistry().getResourceSdkDescriptorsByResourceId(resourceId);
    }

    public static List<ResourceSdkDescriptor> getResourceSdkDescriptorsBySdkId(String sdkId) {
        return ResourceSdkDescriptors.getResourceSdkRegistry().getResourceSdkDescriptorsBySdkId(sdkId);
    }

    public static void addResourceSdkDescriptor(Element element, String sdkId) {
        if (ResourceSdkKind.BINARY_FILE.getXmlElementName().equals(element.getNodeName())) {
            ResourceSdkDescriptors.addResourceSdkDescriptor(new BinaryResourceSdkDescriptorImplementation(element, sdkId));
        } else {
            ResourceSdkDescriptors.addResourceSdkDescriptor(new ResourceSdkDescriptorImplementation(element, sdkId));
        }
    }

    public static void addResourceSdkDescriptor(Element element, String sdkId, String toolChainId) {
        if (ResourceSdkKind.BINARY_FILE.getXmlElementName().equals(element.getNodeName())) {
            ResourceSdkDescriptors.addResourceSdkDescriptor(new BinaryResourceSdkDescriptorImplementation(element, sdkId, toolChainId));
        } else {
            ResourceSdkDescriptors.addResourceSdkDescriptor(new ResourceSdkDescriptorImplementation(element, sdkId, toolChainId));
        }
    }

    public static void addResourceSdkDescriptor(ResourceSdkDescriptor descriptor) {
        ResourceSdkDescriptors.getResourceSdkRegistry().addResourceSdkDescriptor(descriptor);
        SdkRegistryLogger.logDebugInfo(NLS.bind((String)Messages.ResourceSdkDescriptors_register_descriptor_message, (Object)descriptor.getPath(), (Object)descriptor.getSdkId()));
    }

    public static void removeResourceSdkDescriptor(ResourceSdkDescriptor descriptor) {
        ResourceSdkDescriptors.getResourceSdkRegistry().removeResourceSdkDescriptor(descriptor);
        SdkRegistryLogger.logDebugInfo(NLS.bind((String)Messages.ResourceSdkDescriptors_unregister_descriptor_message, (Object)descriptor.getPath(), (Object)descriptor.getSdkId()));
    }

    public static void removeResourceSdkDescriptors(String sdkId) {
        ResourceSdkDescriptors.getResourceSdkRegistry().removeResourceSdkDescriptorsBySdkId(sdkId);
        SdkRegistryLogger.logDebugInfo(NLS.bind((String)Messages.ResourceSdkDescriptors_unregister_descriptors_message, (Object)sdkId));
    }

    public static List<ResourceSdkDescriptor> getBinaryFileSdkDescriptors(String sdkId) {
        return ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndType(sdkId, ResourceSdkKind.BINARY_FILE);
    }

    public static List<ResourceSdkDescriptor> getHeaderFolderSdkDescriptors(String sdkId) {
        return ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndType(sdkId, ResourceSdkKind.HEADER_FOLDER);
    }

    public static List<ResourceSdkDescriptor> getHeaderFileSdkDescriptors(String sdkId) {
        return ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndType(sdkId, ResourceSdkKind.HEADER_FILE);
    }

    public static List<ResourceSdkDescriptor> getIncludeFileSdkDescriptors(String sdkId) {
        return ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndType(sdkId, ResourceSdkKind.INCLUDE_FILE);
    }

    public static List<ResourceSdkDescriptor> getLinkerFileSdkDescriptors(String sdkId) {
        return ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndType(sdkId, ResourceSdkKind.LINKER_FILE);
    }

    public static List<ResourceSdkDescriptor> getResourceFileSdkDescriptors(String sdkId) {
        return ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndType(sdkId, ResourceSdkKind.RESOURCE_FILE);
    }

    public static List<ResourceSdkDescriptor> getResourceFolderSdkDescriptors(String sdkId) {
        return ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndType(sdkId, ResourceSdkKind.RESOURCE_FOLDER);
    }

    public static List<ResourceSdkDescriptor> getSourceFolderSdkDescriptors(String sdkId) {
        return ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndType(sdkId, ResourceSdkKind.SOURCE_FOLDER);
    }

    public static List<ResourceSdkDescriptor> getSourceFileSdkDescriptors(String sdkId) {
        return ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndType(sdkId, ResourceSdkKind.SOURCE_FILE);
    }

    public static List<ResourceSdkDescriptor> getBinaryFileSdkDescriptors(String sdkId, String toolChainId) {
        ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkId(sdkId);
        return ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndToolChainId(sdkId, ResourceSdkDescriptors.adjustParameter(toolChainId)).stream().filter(resource -> ResourceSdkKind.BINARY_FILE == resource.getKind()).collect(Collectors.toList());
    }

    public static List<ResourceSdkDescriptor> getHeaderFolderSdkDescriptors(String sdkId, String toolChainId) {
        return ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndToolChainId(sdkId, ResourceSdkDescriptors.adjustParameter(toolChainId)).stream().filter(resource -> ResourceSdkKind.HEADER_FOLDER == resource.getKind()).collect(Collectors.toList());
    }

    public static List<ResourceSdkDescriptor> getHeaderFileSdkDescriptors(String sdkId, String toolChainId) {
        return ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndToolChainId(sdkId, ResourceSdkDescriptors.adjustParameter(toolChainId)).stream().filter(resource -> ResourceSdkKind.HEADER_FILE == resource.getKind()).collect(Collectors.toList());
    }

    public static List<ResourceSdkDescriptor> getIncludeFileSdkDescriptors(String sdkId, String toolChainId) {
        return ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndToolChainId(sdkId, ResourceSdkDescriptors.adjustParameter(toolChainId)).stream().filter(resource -> ResourceSdkKind.INCLUDE_FILE == resource.getKind()).collect(Collectors.toList());
    }

    public static List<ResourceSdkDescriptor> getLinkerFileSdkDescriptors(String sdkId, String toolChainId) {
        return ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndToolChainId(sdkId, ResourceSdkDescriptors.adjustParameter(toolChainId)).stream().filter(resource -> ResourceSdkKind.LINKER_FILE == resource.getKind()).collect(Collectors.toList());
    }

    public static List<ResourceSdkDescriptor> getResourceFileSdkDescriptors(String sdkId, String toolChainId) {
        return ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndToolChainId(sdkId, ResourceSdkDescriptors.adjustParameter(toolChainId)).stream().filter(resource -> ResourceSdkKind.RESOURCE_FILE == resource.getKind()).collect(Collectors.toList());
    }

    public static List<ResourceSdkDescriptor> getResourceFolderSdkDescriptors(String sdkId, String toolChainId) {
        return ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndToolChainId(sdkId, ResourceSdkDescriptors.adjustParameter(toolChainId)).stream().filter(resource -> ResourceSdkKind.RESOURCE_FOLDER == resource.getKind()).collect(Collectors.toList());
    }

    public static List<ResourceSdkDescriptor> getSourceFolderSdkDescriptors(String sdkId, String toolChainId) {
        return ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndToolChainId(sdkId, ResourceSdkDescriptors.adjustParameter(toolChainId)).stream().filter(resource -> ResourceSdkKind.SOURCE_FOLDER == resource.getKind()).collect(Collectors.toList());
    }

    public static List<ResourceSdkDescriptor> getSourceFileSdkDescriptors(String sdkId, String toolChainId) {
        return ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndToolChainId(sdkId, ResourceSdkDescriptors.adjustParameter(toolChainId)).stream().filter(resource -> ResourceSdkKind.SOURCE_FILE == resource.getKind()).collect(Collectors.toList());
    }

    public static List<ResourceSdkDescriptor> getResourceSdkDescriptorsBySdkIdAndType(String sdkId, ResourceSdkKind kind) {
        Set relatedKinds = kind.getRelatedValues();
        return ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkId(sdkId).stream().filter(resource -> relatedKinds.contains(resource.getKind())).collect(Collectors.toList());
    }

    public static List<ResourceSdkDescriptor> getResourceSdkDescriptorsBySdkIdAndToolChainId(String sdkId, String toolChainId) {
        return ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkId(sdkId).stream().filter(resource -> ResourceSdkDescriptors.matchParameter(toolChainId, resource.getToolChainId())).collect(Collectors.toList());
    }

    public static Map<ResourceSdkGroup, List<ResourceSdkDescriptor>> getResourceSdkDescriptors(String sdkId, String toolChainId, boolean isIncludeRootResources) {
        EnumMap<ResourceSdkGroup, List<ResourceSdkDescriptor>> resources = new EnumMap<ResourceSdkGroup, List<ResourceSdkDescriptor>>(ResourceSdkGroup.class);
        HashSet<String> toolChainsIds = new HashSet<String>();
        if (isIncludeRootResources) {
            toolChainsIds.addAll(ToolChainSdkDescriptors.getToolChainSdkDescriptorsBySdkId(sdkId).stream().filter(ToolChainSdkDescriptor::isRootToolChain).map(ToolChainSdkDescriptor::getToolChainId).collect(Collectors.toSet()));
        }
        toolChainsIds.add(toolChainId);
        resources.put(ResourceSdkGroup.BINARY_RESOURCES, ResourceSdkDescriptors.getBinaryFileSdkDescriptors(sdkId).stream().filter(resource -> toolChainsIds.contains(resource.getToolChainId())).collect(Collectors.toList()));
        List headers = ResourceSdkDescriptors.getHeaderFolderSdkDescriptors(sdkId).stream().filter(resource -> toolChainsIds.contains(resource.getToolChainId())).collect(Collectors.toList());
        headers.addAll(ResourceSdkDescriptors.getHeaderFileSdkDescriptors(sdkId).stream().filter(resource -> toolChainsIds.contains(resource.getToolChainId())).collect(Collectors.toList()));
        resources.put(ResourceSdkGroup.HEADER_RESOURCES, headers);
        resources.put(ResourceSdkGroup.LINKER_RESOURCES, ResourceSdkDescriptors.getLinkerFileSdkDescriptors(sdkId).stream().filter(resource -> toolChainsIds.contains(resource.getToolChainId())).collect(Collectors.toList()));
        List otherResources = ResourceSdkDescriptors.getResourceFolderSdkDescriptors(sdkId).stream().filter(resource -> toolChainsIds.contains(resource.getToolChainId())).collect(Collectors.toList());
        otherResources.addAll(ResourceSdkDescriptors.getResourceFileSdkDescriptors(sdkId).stream().filter(resource -> toolChainsIds.contains(resource.getToolChainId())).collect(Collectors.toList()));
        resources.put(ResourceSdkGroup.UNSPECIFIED_RESOURCES, otherResources);
        List sources = ResourceSdkDescriptors.getSourceFolderSdkDescriptors(sdkId).stream().filter(resource -> toolChainsIds.contains(resource.getToolChainId())).collect(Collectors.toList());
        sources.addAll(ResourceSdkDescriptors.getSourceFileSdkDescriptors(sdkId).stream().filter(resource -> toolChainsIds.contains(resource.getToolChainId())).collect(Collectors.toList()));
        resources.put(ResourceSdkGroup.SOURCE_RESOURCES, sources);
        return resources;
    }

    public static List<ResourceSdkDescriptor> getResourceSdkDescriptorsBySdkIdAndToolChainId(String sdkId, String toolChainId, boolean isIncludeRootToolChainResources) {
        return ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkId(sdkId).stream().filter(resource -> ResourceSdkDescriptors.matchParameter(toolChainId, resource.getToolChainId(), isIncludeRootToolChainResources)).collect(Collectors.toList());
    }

    public static List<ResourceSdkDescriptor> getResourceSdkDescriptors(String sdkId, String toolChainId, String langId, ResourceSdkKind kind) {
        return ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkId(sdkId).stream().filter(resourceSdkDescriptor -> ResourceSdkDescriptors.matchParameter(toolChainId, resourceSdkDescriptor.getToolChainId()) && ResourceSdkDescriptors.matchParameter(langId, resourceSdkDescriptor.getLangId()) && kind == resourceSdkDescriptor.getKind()).collect(Collectors.toList());
    }

    public static void convertToXml(String sdkId, String toolChainId, Document document, Element holderElement) {
        ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndToolChainId(sdkId, toolChainId).forEach(resource -> {
            Element element2 = resource.convertToXml(document, holderElement);
        });
    }

    private static String adjustParameter(String parameter) {
        return Objects.toString(parameter, "");
    }

    private static boolean matchParameter(String parameter, String resourceParameter) {
        return ResourceSdkDescriptors.adjustParameter(parameter).equals(ResourceSdkDescriptors.adjustParameter(resourceParameter));
    }

    private static boolean matchParameter(String parameter, String resourceParameter, boolean matchEmptyParameter) {
        parameter = ResourceSdkDescriptors.adjustParameter(parameter);
        resourceParameter = ResourceSdkDescriptors.adjustParameter(resourceParameter);
        return matchEmptyParameter ? resourceParameter.isEmpty() || parameter.equals(resourceParameter) : parameter.equals(resourceParameter);
    }
}

