/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.sdk.registry.core.hardware;

import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.hardware.AbstractHardwareSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.hardware.CoreSdkDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.hardware.DeviceCoreSdkDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.hardware.DeviceSdkDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.hardware.CoreSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.hardware.DeviceCoreSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.hardware.DeviceSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.hardware.DeviceSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.hardware.HardwareSdkDescriptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HardwareSdkDescriptors {
    private HardwareSdkDescriptors() {
    }

    public static void addHardwareSdkDescriptors(Element element) {
        String hardwareAttribute = element.getAttribute("cores");
        if (hardwareAttribute.isEmpty()) {
            return;
        }
        Set hardwareParamsGroups = Arrays.stream(hardwareAttribute.split(",")).map(String::trim).collect(Collectors.toSet());
        for (String hardwareParamsGroup : hardwareParamsGroups) {
            String[] hardwareParams = hardwareParamsGroup.split(":");
            int hardwareParamsCount = hardwareParams.length;
            if (hardwareParamsCount == 0) continue;
            Element copyElement = (Element)element.cloneNode(false);
            copyElement.setAttribute("cores", hardwareParamsGroup);
            if (hardwareParamsCount >= 1 && !hardwareParams[0].trim().isEmpty()) {
                DeviceSdkDescriptors.addDeviceSdkDescriptor(new DeviceSdkDescriptorImplementation(copyElement));
            }
            if (hardwareParamsCount >= 2 && !hardwareParams[1].trim().isEmpty()) {
                DeviceCoreSdkDescriptors.addDeviceCoreSdkDescriptor(new DeviceCoreSdkDescriptorImplementation(copyElement));
            }
            if (hardwareParamsCount < 3 || hardwareParams[2].trim().isEmpty()) continue;
            CoreSdkDescriptors.addCoreSdkDescriptor(new CoreSdkDescriptorImplementation(copyElement));
        }
    }

    public static void removeHardwareSdkDescriptors(String sdkId) {
        if (!DeviceSdkDescriptors.getDeviceSdkDescriptorsBySdkId(sdkId).isEmpty()) {
            DeviceSdkDescriptors.removeDeviceSdkDescriptors(sdkId);
        }
        if (!DeviceCoreSdkDescriptors.getDeviceCoreSdkDescriptorsBySdkId(sdkId).isEmpty()) {
            DeviceCoreSdkDescriptors.removeDeviceCoreSdkDescriptors(sdkId);
        }
        if (!CoreSdkDescriptors.getCoreSdkDescriptorsBySdkId(sdkId).isEmpty()) {
            CoreSdkDescriptors.removeCoreSdkDescriptors(sdkId);
        }
    }

    public static Map<String, List<HardwareSdkDescriptor>> getHardwareSdkDescriptors(String sdkId) {
        HashMap<String, List<HardwareSdkDescriptor>> result = new HashMap<String, List<HardwareSdkDescriptor>>();
        List deviceSdkDescriptors = DeviceSdkDescriptors.getDeviceSdkDescriptorsBySdkId(sdkId).stream().map(deviceSdkDescriptor -> deviceSdkDescriptor).collect(Collectors.toList());
        result.put("com.nxp.s32ds.cle.runtime.hardware.registry.device.id", deviceSdkDescriptors != null ? deviceSdkDescriptors : Collections.emptyList());
        List deviceCoreSdkDescriptors = DeviceCoreSdkDescriptors.getDeviceCoreSdkDescriptorsBySdkId(sdkId).stream().map(deviceCoreSdkDescriptor -> deviceCoreSdkDescriptor).collect(Collectors.toList());
        result.put("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id", deviceCoreSdkDescriptors != null ? deviceCoreSdkDescriptors : Collections.emptyList());
        List coreSdkDescriptors = CoreSdkDescriptors.getCoreSdkDescriptorsBySdkId(sdkId).stream().map(coreSdkDescriptor -> coreSdkDescriptor).collect(Collectors.toList());
        result.put("com.nxp.s32ds.cle.runtime.hardware.registry.core.id", coreSdkDescriptors != null ? coreSdkDescriptors : Collections.emptyList());
        return result;
    }

    public static Map<String, Set<String>> getHardwareSdkDescriptorsIds(String sdkId) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        Map<String, List<HardwareSdkDescriptor>> hardwareSdkDescriptors = HardwareSdkDescriptors.getHardwareSdkDescriptors(sdkId);
        result.put("com.nxp.s32ds.cle.runtime.hardware.registry.device.id", hardwareSdkDescriptors.get("com.nxp.s32ds.cle.runtime.hardware.registry.device.id").stream().map(HardwareSdkDescriptor::getHardwareParameter).collect(Collectors.toSet()));
        result.put("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id", hardwareSdkDescriptors.get("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id").stream().map(HardwareSdkDescriptor::getHardwareParameter).collect(Collectors.toSet()));
        result.put("com.nxp.s32ds.cle.runtime.hardware.registry.core.id", hardwareSdkDescriptors.get("com.nxp.s32ds.cle.runtime.hardware.registry.core.id").stream().map(HardwareSdkDescriptor::getHardwareParameter).collect(Collectors.toSet()));
        result.put("com.nxp.s32ds.cle.runtime.hardware.registry.device.revision.id", DeviceSdkDescriptors.getDeviceSdkDescriptorsBySdkId(sdkId).stream().map(DeviceSdkDescriptor::getDeviceRevisionId).collect(Collectors.toSet()));
        return result;
    }

    public static String getHardwareString(String sdkId, Map<String, Set<String>> hardwareParams) {
        if (hardwareParams.isEmpty()) {
            return "";
        }
        HashSet hardwareStrings = new HashSet();
        hardwareParams.get("com.nxp.s32ds.cle.runtime.hardware.registry.device.id").stream().flatMap(id -> DeviceSdkDescriptors.getDeviceSdkDescriptorsByDeviceId(id).stream()).filter(dd -> dd.getSdkId().equals(sdkId)).forEach(dd -> {
            boolean bl = hardwareStrings.add(((AbstractHardwareSdkDescriptor)((Object)dd)).getHardwareString());
        });
        hardwareParams.get("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id").stream().flatMap(id -> DeviceCoreSdkDescriptors.getDeviceCoreSdkDescriptorsByDeviceCoreId(id).stream()).filter(dcd -> dcd.getSdkId().equals(sdkId)).forEach(dcd -> {
            boolean bl = hardwareStrings.add(((AbstractHardwareSdkDescriptor)((Object)dcd)).getHardwareString());
        });
        hardwareParams.get("com.nxp.s32ds.cle.runtime.hardware.registry.core.id").stream().flatMap(id -> CoreSdkDescriptors.getCoreSdkDescriptorsByCoreId(id).stream()).filter(cd -> cd.getSdkId().equals(sdkId)).forEach(cd -> {
            boolean bl = hardwareStrings.add(((AbstractHardwareSdkDescriptor)((Object)cd)).getHardwareString());
        });
        return String.join((CharSequence)",", hardwareStrings);
    }

    public static String getHardwareString(String sdkId) {
        HashSet hardwareStrings = new HashSet();
        DeviceSdkDescriptors.getDeviceSdkDescriptorsBySdkId(sdkId).forEach(dd -> {
            boolean bl = hardwareStrings.add(((AbstractHardwareSdkDescriptor)((Object)dd)).getHardwareString());
        });
        DeviceCoreSdkDescriptors.getDeviceCoreSdkDescriptorsBySdkId(sdkId).forEach(dcd -> {
            boolean bl = hardwareStrings.add(((AbstractHardwareSdkDescriptor)((Object)dcd)).getHardwareString());
        });
        CoreSdkDescriptors.getCoreSdkDescriptorsBySdkId(sdkId).forEach(cd -> {
            boolean bl = hardwareStrings.add(((AbstractHardwareSdkDescriptor)((Object)cd)).getHardwareString());
        });
        return String.join((CharSequence)",", hardwareStrings);
    }

    public static void convertToXml(String sdkId, Document document, Element holderElement) {
        Set deviceRevisionIds = HardwareSdkDescriptors.getHardwareSdkDescriptorsIds(sdkId).getOrDefault("com.nxp.s32ds.cle.runtime.hardware.registry.device.revision.id", Collections.emptySet());
        if (!deviceRevisionIds.isEmpty()) {
            holderElement.setAttribute("deviceRevisionId", (String)deviceRevisionIds.iterator().next());
        }
    }
}

