/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.toolchain;

import com.nxp.s32ds.cle.runtime.sdk.registry.core.resource.ResourceSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.symbol.SymbolSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.toolchain.ToolChainSdkDescriptor;
import com.nxp.s32ds.ext.rcp.registry.ElementDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ToolChainSdkDescriptorImplementation
extends ElementDescriptor
implements ToolChainSdkDescriptor {
    private String sdkId;
    private boolean isRootToolChain;

    public ToolChainSdkDescriptorImplementation(Element element, String sdkId) {
        super(element);
        this.addSubstitution("sourceId", "id");
        this.sdkId = sdkId;
    }

    public ToolChainSdkDescriptorImplementation(Element element, String sdkId, boolean isRootToolChain) {
        this(element, sdkId);
        this.isRootToolChain = isRootToolChain;
    }

    public String getToolChainId() {
        String toolChainId = this.getSourceId();
        return toolChainId.isEmpty() && this.isRootToolChain ? this.getAttribute("toolchains") : toolChainId;
    }

    public String getSdkId() {
        return this.getTargetId();
    }

    public String getTargetId() {
        return this.sdkId;
    }

    public String getAlias() {
        return this.getAttribute("alias");
    }

    public boolean isRootToolChain() {
        return this.isRootToolChain;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.isRootToolChain ? 1231 : 1237);
        result = 31 * result + (this.sdkId == null ? 0 : this.sdkId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ToolChainSdkDescriptorImplementation)) {
            return false;
        }
        ToolChainSdkDescriptorImplementation other = (ToolChainSdkDescriptorImplementation)((Object)obj);
        if (this.isRootToolChain != other.isRootToolChain) {
            return false;
        }
        return !(this.sdkId == null ? other.sdkId != null : !this.sdkId.equals(other.sdkId));
    }

    public String toString() {
        return String.format("Tool chain: id=%s alias=%s sdkId=%s isRoot=%s", this.getToolChainId(), this.getAlias(), this.getSdkId(), this.isRootToolChain());
    }

    public Element convertToXml(Document document, Element holderElement) {
        String toolChainId = this.getToolChainId();
        if (toolChainId.isEmpty()) {
            return holderElement;
        }
        if (this.isRootToolChain) {
            String toolChains = holderElement.getAttribute("toolchains");
            toolChains = toolChains.isEmpty() ? toolChains.concat(toolChainId) : toolChains.concat(",").concat(toolChainId);
            holderElement.setAttribute("toolchains", toolChains);
            return holderElement;
        }
        Element toolChainElement = document.createElement("toolchain");
        toolChainElement.setAttribute("id", toolChainId);
        toolChainElement.setAttribute("alias", this.getAlias());
        SymbolSdkDescriptors.convertToXml(this.sdkId, toolChainId, document, toolChainElement);
        ResourceSdkDescriptors.convertToXml(this.sdkId, toolChainId, document, toolChainElement);
        holderElement.appendChild(toolChainElement);
        return toolChainElement;
    }
}

