/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.core.refactoring;

import com.nxp.s32ds.ext.ide.core.refactoring.RefactoringParticipant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class LibResourcesRefactoringParticipant
implements RefactoringParticipant {
    public static final String BUNDLE_ID = "com.nxp.s32ds.ext.ide.ui.refactoring";
    public static final String C_LINKER_TOOL_NAME = ".tool.c.linker";
    public static final String CPP_LINKER_TOOL_NAME = ".tool.cpp.linker";
    public static final String C_LINKER_OPTION_PATH_NAME = "gnu.c.link.option.paths";
    public static final String C_LINKER_OPTION_NAME = "gnu.c.link.option.libs";
    public static final String CPP_LINKER_OPTION_PATH_NAME = "gnu.cpp.link.option.paths";
    public static final String CPP_LINKER_OPTION_NAME = "gnu.cpp.link.option.libs";
    public static final String SET_OPTION_ERROR = "Couldn't set %s option";
    public static final String PATH_PREFIX_ATTRIBUTE = "\"${workspace_loc:/%s";
    public static final String LIBS_ATTRIBUTE = ":lib%s";

    public IStatus apply(IProject target, IProject source, String search, String replace, IProgressMonitor monitor) {
        IConfiguration[] configurations;
        MultiStatus mtStatus = new MultiStatus(BUNDLE_ID, 0, "", null);
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)target);
        if (buildInfo == null) {
            return mtStatus;
        }
        String linkerPathSearchValue = String.format(PATH_PREFIX_ATTRIBUTE, search);
        String linkerPathReplaceValue = String.format(PATH_PREFIX_ATTRIBUTE, replace);
        String linkerLibSearchValue = String.format(LIBS_ATTRIBUTE, search);
        String linkerLibReplaceValue = String.format(LIBS_ATTRIBUTE, replace);
        IConfiguration[] iConfigurationArray = configurations = buildInfo.getManagedProject().getConfigurations();
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            ITool[] tools;
            IConfiguration conf = iConfigurationArray[n2];
            IToolChain toolchain = conf.getToolChain();
            ITool[] iToolArray = tools = toolchain.getTools();
            int n3 = tools.length;
            int n4 = 0;
            while (n4 < n3) {
                ITool tool = iToolArray[n4];
                String toolId = tool.getId();
                try {
                    if (toolId.contains(C_LINKER_TOOL_NAME)) {
                        LibResourcesRefactoringParticipant.setOption(conf, linkerPathSearchValue, linkerPathReplaceValue, tool, C_LINKER_OPTION_PATH_NAME);
                        LibResourcesRefactoringParticipant.setOption(conf, linkerLibSearchValue, linkerLibReplaceValue, tool, C_LINKER_OPTION_NAME);
                    } else if (toolId.contains(CPP_LINKER_TOOL_NAME)) {
                        LibResourcesRefactoringParticipant.setOption(conf, linkerPathSearchValue, linkerPathReplaceValue, tool, CPP_LINKER_OPTION_PATH_NAME);
                        LibResourcesRefactoringParticipant.setOption(conf, linkerLibSearchValue, linkerLibReplaceValue, tool, CPP_LINKER_OPTION_NAME);
                    }
                }
                catch (CoreException e) {
                    mtStatus.add(e.getStatus());
                }
                ++n4;
            }
            ++n2;
        }
        return mtStatus;
    }

    private static List<String> getOptionValues(Object optionObject) {
        if (optionObject instanceof List) {
            return (List)optionObject;
        }
        return Collections.emptyList();
    }

    private static void setOption(IConfiguration config, String oldValue, String newValue, ITool tool, String optionId) throws CoreException {
        IOption option = tool.getOptionBySuperClassId(optionId);
        if (option == null) {
            return;
        }
        List<String> optionValues = LibResourcesRefactoringParticipant.getOptionValues(option.getValue());
        if (optionValues.isEmpty()) {
            return;
        }
        ArrayList<String> listModifiedOptions = new ArrayList<String>();
        for (String optionValue : optionValues) {
            if (optionValue.startsWith(oldValue)) {
                listModifiedOptions.add(optionValue.replace(oldValue, newValue));
                continue;
            }
            listModifiedOptions.add(optionValue);
        }
        try {
            config.setOption((IHoldsOptions)tool, option, listModifiedOptions.toArray(new String[listModifiedOptions.size()]));
        }
        catch (BuildException e) {
            String format = String.format(SET_OPTION_ERROR, optionId);
            throw new CoreException((IStatus)new Status(4, BUNDLE_ID, format, (Throwable)e));
        }
    }
}

