/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.template;

import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import org.eclipse.cdt.core.language.ProjectLanguageConfiguration;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.internal.core.language.LanguageMappingStore;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class SetContentTypeMapping
extends ProcessRunner {
    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        if (args == null || args.length < 3) {
            S32DSWizardPlugin.logWarning("Data for SetContentTypeMapping should contain more input parameters!");
            return;
        }
        String projectName = null;
        String configuration = null;
        String content = null;
        String language = null;
        ProcessArgument[] processArgumentArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessArgument pa = processArgumentArray[n2];
            pa.resolve();
            String name = pa.getName();
            if (pa.getParameterType() == 1) {
                if ("content-type".equals(name)) {
                    content = pa.getSimpleValue();
                } else if ("language".equals(name)) {
                    language = pa.getSimpleValue();
                } else if ("configuration".equals(name)) {
                    configuration = pa.getSimpleValue();
                } else if ("projectName".equals(name)) {
                    projectName = pa.getSimpleValue();
                }
            }
            ++n2;
        }
        if (projectName == null || configuration == null || content == null || language == null) {
            S32DSWizardPlugin.logWarning("input parameters for SetContentTypeMapping are incorrect");
            return;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info == null) {
            throw new ProcessFailureException("This project is not Managed CDT project");
        }
        ICConfigurationDescription configDescription = null;
        ICProjectDescription des = CProjectDescriptionManager.getInstance().getProjectDescription(project);
        ICConfigurationDescription[] iCConfigurationDescriptionArray = des.getConfigurations();
        int n3 = iCConfigurationDescriptionArray.length;
        int n4 = 0;
        while (n4 < n3) {
            ICConfigurationDescription c = iCConfigurationDescriptionArray[n4];
            if (c.getName().equals(configuration)) {
                configDescription = c;
            }
            ++n4;
        }
        LanguageMappingStore mappingStore = new LanguageMappingStore();
        try {
            ProjectLanguageConfiguration projectLanguageConfiguration = mappingStore.decodeMappings(project);
            projectLanguageConfiguration.addContentTypeMapping(configDescription, content, language);
            mappingStore.storeMappings(project, projectLanguageConfiguration);
        }
        catch (CoreException coreException) {
            S32DSWizardPlugin.log((IStatus)new Status(4, "com.freescale.s32ds.cross.wizard", "Can't set content-type language mapping"));
        }
    }
}

