/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.page2;

import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.context.CProjectMasterContext;
import com.freescale.s32ds.cross.core.model.context.ProcessorContext;
import com.freescale.s32ds.cross.core.model.context.ProjectContext;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import com.freescale.s32ds.cross.wizard.S32DSMultiProjectWizard;
import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import com.freescale.s32ds.cross.wizard.page1.S32DSMultiPageOne;
import com.freescale.s32ds.cross.wizard.page2.IPage2Manager;
import com.freescale.s32ds.cross.wizard.page2.MemoryMinimumChecker;
import com.freescale.s32ds.cross.wizard.page2.Page2Tree;
import com.freescale.s32ds.cross.wizard.page2.Page2Utils;
import com.nxp.s32ds.cle.cdt.internal.ui.wizards.Messages;
import com.nxp.s32ds.cle.cdt.sdk.core.filtering.AbstractSdkSmartFilter;
import com.nxp.s32ds.cle.cdt.sdk.core.filtering.FilterOptionsImplementation;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.filtering.FilterOptions;
import com.nxp.s32ds.cle.cdt.sdk.filtering.SdkFilter;
import com.nxp.s32ds.cle.cdt.sdk.filtering.SdkFilteringParameters;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import com.nxp.s32ds.ext.rcp.registry.EntityDescriptor;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class S32DSMultiPageTwo
extends WizardPage {
    private final ProcessorContext processorContext;
    private String projectName = "";
    private IPage2Manager pageManager;
    protected final S32DSMultiPageOne firstPage;

    public S32DSMultiPageTwo(String pageName, S32DSMultiProjectWizard w, ProcessorContext processorContext) {
        super(pageName);
        this.setWizard(w);
        this.setPageComplete(false);
        this.setTitle(NLS.bind((String)Messages.S32DSMultiPageTwo_title, (Object)processorContext.getProcessor().getName()));
        this.setDescription(Messages.S32DSMultiPageTwo_description);
        this.processorContext = processorContext;
        processorContext.initData();
        this.firstPage = this.getWizard().getStartingPage();
        this.initSdksLists();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout());
        this.pageManager = new Page2Tree(this.processorContext, this, composite);
        this.pageManager.createContents();
        this.initializeDialogUnits((Control)parent);
        composite.pack();
        this.setControl((Control)composite);
        this.setPageComplete(this.pageManager.isAnyChecked());
        this.setErrorMessage(null);
        this.setMessage(null);
        Dialog.applyDialogFont((Control)composite);
        boolean fpuSupport = this.processorContext.containsParameter("fpu");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), S32DSWizardPlugin.makeHelpContextId(this.getWizard().getType(), 2, fpuSupport, this.processorContext.getProcessor()));
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public IWizardPage getPreviousPage() {
        return this.getWizard().getStartingPage();
    }

    public S32DSMultiProjectWizard getWizard() {
        return (S32DSMultiProjectWizard)super.getWizard();
    }

    public void disableUI() {
        this.pageManager.setEnabled(false);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.getControl().setFocus();
        }
    }

    public boolean isPageComplete() {
        if (super.isPageComplete()) {
            return this.checkSdkPresence();
        }
        return false;
    }

    public boolean validatePage() {
        String memoryError = MemoryMinimumChecker.getMinMemoryError(this.processorContext);
        if (memoryError != null) {
            this.setErrorMessage(memoryError);
            return false;
        }
        if (!this.pageManager.isAnyChecked()) {
            String coreNatureDescription = this.getWizard().getContext().isExecutable() ? Messages.S32DSMultiPageTwo_core : Messages.S32DSMultiPageTwo_core_type;
            this.setErrorMessage(NLS.bind((String)Messages.S32DSMultiPageTwo_choose_any_core_to_continue, (Object)coreNatureDescription));
            return false;
        }
        for (ProjectContext ctx : this.getWizard().getContext().getResultProjectContexts()) {
            if (!(ctx instanceof CProjectMasterContext)) continue;
            CProjectMasterContext projectContext = (CProjectMasterContext)ctx;
            List sdksList = projectContext.getSdkList().stream().map(SdkDescriptors::getSdkDescriptor).filter(Objects::nonNull).collect(Collectors.toList());
            for (SdkDescriptor sdkDescriptor : sdksList) {
                if (S32DSMultiPageTwo.createFilter(projectContext).acceptOptions(sdkDescriptor)) continue;
                this.setErrorMessage(NLS.bind((String)Messages.S32DSMultiPageTwo_sdk_does_not_fit_to_params, (Object)sdkDescriptor.getName()));
                return false;
            }
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
        if (this.pageManager != null) {
            this.pageManager.update();
        }
    }

    private boolean checkSdkPresence() {
        String processSDKTag = this.getProcessSdkTag();
        if (processSDKTag != null && !processSDKTag.isEmpty()) {
            for (ProjectContext ctx : this.getWizard().getContext().getResultProjectContexts()) {
                CProjectMasterContext pc;
                if (!(ctx instanceof CProjectMasterContext) || !(pc = (CProjectMasterContext)ctx).getSdkList().isEmpty()) continue;
                this.setErrorMessage(Messages.S32DSMultiPageTwo_sdk_not_specified);
                return false;
            }
        }
        return true;
    }

    private void initSdksLists() {
        String processSDKTag = this.getProcessSdkTag();
        if (processSDKTag == null || processSDKTag.isEmpty()) {
            return;
        }
        List contexts = this.getWizard().getContext().getResultProjectContexts().stream().filter(CProjectMasterContext.class::isInstance).map(CProjectMasterContext.class::cast).collect(Collectors.toList());
        for (CProjectMasterContext projectContext : contexts) {
            List sdksList = SdkManagementUtils.getFilteredSdks((SdkFilter)S32DSMultiPageTwo.createFilter(projectContext));
            List sdksWithTag = SdkManagementUtils.getSdksGrouppedByTag((List)sdksList).getOrDefault(processSDKTag, Collections.emptyList());
            List sdkListByProcessTag = sdksWithTag.stream().map(EntityDescriptor::getId).collect(Collectors.toList());
            projectContext.setSdkList(sdkListByProcessTag);
        }
    }

    private String getProcessSdkTag() {
        ProcessorData pd = this.processorContext.getProcessor();
        if (pd != null) {
            return pd.getSdkTag();
        }
        return "";
    }

    private static AbstractSdkSmartFilter createFilter(final CProjectMasterContext pc) {
        return new AbstractSdkSmartFilter(){

            public FilterOptions options() {
                return FilterOptionsImplementation.createFilter((SdkFilteringParameters)Page2Utils.createSDKFilterInfo((CProjectContext)pc));
            }

            public boolean accept(SdkDescriptor sdk) {
                return true;
            }
        };
    }
}

