/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.debugger.connections.registry;

import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnectionDescriptor;
import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnections;
import java.util.Objects;

public class DeviceConnection {
    private static final String CONNECTION_QUALIFIERS_SEPARATOR = "--";
    private static final int CONNECTION_QUALIFIERS_QUANTITY = 3;
    private static final int CONNECTION_ID_QUALIFIER_POSITION = 0;
    private static final int CONNECTION_DATA_QUALIFIER_POSITION = 1;
    private static final int CONNECTION_UI_FRIENDLY_NAME_QUALIFIER_POSITION = 2;
    private final String CONNECTION_ID;
    private final boolean USE_ETHERNET;
    private String uiFriendlyName;
    private String connectionData;

    public static DeviceConnection createFromFullConnectionString(String connectionData) {
        if (connectionData == null || connectionData.isEmpty()) {
            return null;
        }
        String[] connectionQualifiers = connectionData.split(CONNECTION_QUALIFIERS_SEPARATOR, -1);
        if (connectionQualifiers.length != 3) {
            return null;
        }
        String connectionId = connectionQualifiers[0];
        DebuggerConnectionDescriptor descriptor = DebuggerConnections.getDebuggerConnectionDescriptorByConnectionName(connectionId);
        if (connectionId.isEmpty() || descriptor == null) {
            return null;
        }
        boolean useEthernet = DebuggerConnections.getDebuggerConnectionDescriptorByConnectionName(connectionId).isEthernetConnection();
        DeviceConnection toReturn = new DeviceConnection(connectionId, useEthernet);
        toReturn.setDeviceConnectionData(connectionQualifiers[1]);
        toReturn.setDeviceUiFriendlyName(connectionQualifiers[2]);
        return toReturn;
    }

    public DeviceConnection(String connectionId, boolean useEthernet) {
        this.CONNECTION_ID = connectionId != null ? connectionId : "-";
        this.USE_ETHERNET = useEthernet;
        this.uiFriendlyName = "";
        this.connectionData = "";
    }

    public String getDeviceConnectionId() {
        return this.CONNECTION_ID;
    }

    public boolean isUsbConnection() {
        return !this.USE_ETHERNET;
    }

    public void setDeviceUiFriendlyName(String name) {
        if (name != null) {
            this.uiFriendlyName = name;
        }
    }

    public String getDeviceUiFriendlyName() {
        return this.uiFriendlyName;
    }

    public void setDeviceConnectionData(String data) {
        if (data != null) {
            this.connectionData = data;
        }
    }

    public String getDeviceConnectionData() {
        return this.connectionData;
    }

    public String getFullConnectionString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.CONNECTION_ID);
        builder.append(CONNECTION_QUALIFIERS_SEPARATOR);
        builder.append(this.connectionData);
        builder.append(CONNECTION_QUALIFIERS_SEPARATOR);
        builder.append(this.uiFriendlyName);
        return builder.toString();
    }

    public boolean equals(Object toCompare) {
        if (toCompare == null || !(toCompare instanceof DeviceConnection)) {
            return false;
        }
        if (this == toCompare) {
            return true;
        }
        DeviceConnection comparable = (DeviceConnection)toCompare;
        return Objects.equals(this.CONNECTION_ID, comparable.getDeviceConnectionId()) && Objects.equals(!this.USE_ETHERNET, comparable.isUsbConnection()) && Objects.equals(this.connectionData, comparable.getDeviceConnectionData()) && Objects.equals(this.uiFriendlyName, comparable.getDeviceUiFriendlyName());
    }

    public int hashCode() {
        int result = 1;
        result = 29 * result + this.CONNECTION_ID.hashCode();
        result = 29 * result + Boolean.valueOf(this.USE_ETHERNET).hashCode();
        result = 29 * result + this.connectionData.hashCode();
        result = 29 * result + this.uiFriendlyName.hashCode();
        return result;
    }
}

