/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.project.configuration.internal.core.updaters;

import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.UpdateOperation;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.status.LaunchConfigurationAttributeUpdateStatus;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.status.UpdateStatus;
import com.nxp.s32ds.cle.cdt.project.configuration.internal.core.ProjectConfigurationCoreActivator;
import com.nxp.s32ds.cle.cdt.project.configuration.internal.core.updaters.ProjectSettingsUpdaterBase;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.osgi.util.NLS;

public class LaunchConfigurationUpdater
extends ProjectSettingsUpdaterBase {
    @Override
    public IStatus update(IConfiguration configuration, String key, String value, UpdateOperation operation) {
        IStatus status = this.validateArguments(configuration, key, value, operation);
        if (!status.isOK()) {
            return status;
        }
        return this.update(configuration, key, Collections.singletonList(value), operation);
    }

    @Override
    public IStatus update(IConfiguration configuration, String key, Collection<String> values, UpdateOperation operation) {
        IStatus status = this.validateArguments(configuration, key, values, operation);
        if (!status.isOK()) {
            return status;
        }
        String projectName = configuration.getOwner().getProject().getName();
        String configurationId = configuration.getId();
        try {
            ILaunchConfiguration launchConfiguration = LaunchConfigurationUpdater.getLaunchConfiguration(projectName, configurationId);
            if (launchConfiguration == null) {
                return ProjectConfigurationCoreActivator.getInstance().createError(NLS.bind((String)"The launch configuration with id ''{1}'' not found in the project ''{2}''.", (Object)configurationId, (Object)projectName));
            }
            ILaunchConfigurationWorkingCopy launchConfigurationWorkingCopy = launchConfiguration.getWorkingCopy();
            status = ProjectConfigurationCoreActivator.getInstance().createStatus(values.stream().map(v -> LaunchConfigurationUpdater.updateLaunchConfigurationAttributeValue(key, v, launchConfigurationWorkingCopy, configuration.getName(), operation)).collect(Collectors.toList()));
            LaunchConfigurationUpdater.applyLaunchConfigurationChanges(launchConfiguration, launchConfigurationWorkingCopy);
            return status;
        }
        catch (CoreException e) {
            ProjectConfigurationCoreActivator.getInstance().logError(NLS.bind((String)"Unable to update the option ''{0}'' for the launch configuration ''{1}'' in the project ''{2}''.", (Object[])new Object[]{key, configurationId, projectName}), e);
            return e.getStatus();
        }
    }

    private static IStatus updateLaunchConfigurationAttributeValue(String key, String value, ILaunchConfigurationWorkingCopy launchConfigurationWorkingCopy, String configurationName, UpdateOperation operation) {
        try {
            LaunchConfigurationAttributeUpdateStatus updateStatus = new LaunchConfigurationAttributeUpdateStatus(key, configurationName, "");
            switch (operation) {
                case ADD: {
                    return LaunchConfigurationUpdater.addAttributeValue(key, value, launchConfigurationWorkingCopy, updateStatus);
                }
                case REMOVE: {
                    return LaunchConfigurationUpdater.removeAttributeValue(key, value, launchConfigurationWorkingCopy, updateStatus);
                }
                case REPLACE_EXISTING: {
                    return LaunchConfigurationUpdater.replaceAttributeValue(key, value, launchConfigurationWorkingCopy, updateStatus);
                }
                case CLEAN_EXISTING: {
                    return LaunchConfigurationUpdater.cleanupAttributeValue(key, launchConfigurationWorkingCopy, updateStatus);
                }
            }
            throw new IllegalStateException();
        }
        catch (CoreException e) {
            return ProjectConfigurationCoreActivator.getInstance().createError(NLS.bind((String)"Unable to perform the ''{0}'' for launch configuration option ''{1}'' with argument ''{2}''", (Object[])new Object[]{operation.name(), key, value}), e);
        }
    }

    private static UpdateStatus addAttributeValue(String key, String value, ILaunchConfigurationWorkingCopy launchConfigurationWorkingCopy, UpdateStatus updateStatus) throws CoreException {
        Object attributeValue = launchConfigurationWorkingCopy.getAttributes().get(key);
        if (attributeValue == null) {
            updateStatus.setSourceValues(Collections.singletonList(""));
            launchConfigurationWorkingCopy.setAttribute(key, value);
            updateStatus.setTargetValues(Collections.singletonList(value));
        } else if (attributeValue instanceof String) {
            String stringValue = (String)attributeValue;
            updateStatus.setSourceValues(Collections.singletonList(stringValue));
            stringValue = String.valueOf(stringValue) + value;
            launchConfigurationWorkingCopy.setAttribute(key, stringValue);
            updateStatus.setTargetValues(Collections.singletonList(stringValue));
        } else if (attributeValue instanceof List) {
            List values = (List)attributeValue;
            updateStatus.setSourceValues(values);
            values.addAll(Arrays.stream(value.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList()));
            launchConfigurationWorkingCopy.setAttribute(key, values);
            updateStatus.setTargetValues(values);
        } else if (attributeValue instanceof Set) {
            Set values = (Set)attributeValue;
            updateStatus.setSourceValues(values);
            values.addAll(Arrays.stream(value.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet()));
            launchConfigurationWorkingCopy.setAttribute(key, values);
            updateStatus.setTargetValues(values);
        }
        return updateStatus;
    }

    private static UpdateStatus removeAttributeValue(String key, String value, ILaunchConfigurationWorkingCopy launchConfigurationWorkingCopy, UpdateStatus updateStatus) throws CoreException {
        Object attributeValue = launchConfigurationWorkingCopy.getAttributes().get(key);
        if (attributeValue instanceof String) {
            String stringValue = (String)attributeValue;
            updateStatus.setSourceValues(Collections.singletonList(stringValue));
            stringValue = stringValue.replace(value, "");
            launchConfigurationWorkingCopy.setAttribute(key, stringValue);
            updateStatus.setTargetValues(Collections.singletonList(stringValue));
        } else if (attributeValue instanceof List) {
            List values = (List)attributeValue;
            updateStatus.setSourceValues(values);
            values.removeAll(Arrays.stream(value.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList()));
            launchConfigurationWorkingCopy.setAttribute(key, values);
            updateStatus.setTargetValues(values);
        } else if (attributeValue instanceof Set) {
            Set values = (Set)attributeValue;
            updateStatus.setSourceValues(values);
            values.removeAll(Arrays.stream(value.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet()));
            launchConfigurationWorkingCopy.setAttribute(key, values);
            updateStatus.setTargetValues(values);
        }
        return updateStatus;
    }

    private static UpdateStatus replaceAttributeValue(String key, String value, ILaunchConfigurationWorkingCopy launchConfigurationWorkingCopy, UpdateStatus updateStatus) throws CoreException {
        Object attributeValue = launchConfigurationWorkingCopy.getAttributes().get(key);
        if (attributeValue == null) {
            updateStatus.setSourceValues(Collections.singletonList(""));
            launchConfigurationWorkingCopy.setAttribute(key, value);
            updateStatus.setTargetValues(Collections.singletonList(value));
        } else if (attributeValue instanceof String) {
            updateStatus.setSourceValues(Collections.singletonList((String)attributeValue));
            launchConfigurationWorkingCopy.setAttribute(key, value);
            updateStatus.setTargetValues(Collections.singletonList(value));
        } else if (attributeValue instanceof Boolean) {
            updateStatus.setSourceValues(Collections.singletonList(String.valueOf((Boolean)attributeValue)));
            launchConfigurationWorkingCopy.setAttribute(key, Boolean.parseBoolean(value));
            updateStatus.setTargetValues(Collections.singletonList(value));
        } else if (attributeValue instanceof Integer) {
            updateStatus.setSourceValues(Collections.singletonList(String.valueOf((Integer)attributeValue)));
            launchConfigurationWorkingCopy.setAttribute(key, Integer.parseInt(value));
            updateStatus.setTargetValues(Collections.singletonList(value));
        } else if (attributeValue instanceof List) {
            List<String> values = (List<String>)attributeValue;
            updateStatus.setSourceValues((Collection<String>)values);
            values = Arrays.stream(value.split(",")).map(String::trim).filter(v -> !v.isEmpty()).collect(Collectors.toList());
            launchConfigurationWorkingCopy.setAttribute(key, values);
            updateStatus.setTargetValues(values);
        } else if (attributeValue instanceof Set) {
            Set<String> values = (Set<String>)attributeValue;
            updateStatus.setSourceValues((Collection<String>)values);
            values = Arrays.stream(value.split(",")).map(String::trim).filter(v -> !v.isEmpty()).collect(Collectors.toSet());
            launchConfigurationWorkingCopy.setAttribute(key, values);
            updateStatus.setTargetValues(values);
        }
        return updateStatus;
    }

    private static UpdateStatus cleanupAttributeValue(String key, ILaunchConfigurationWorkingCopy launchConfigurationWorkingCopy, UpdateStatus updateStatus) throws CoreException {
        Object attributeValue = launchConfigurationWorkingCopy.getAttributes().get(key);
        if (attributeValue instanceof String) {
            updateStatus.setSourceValues(Collections.singletonList((String)attributeValue));
            launchConfigurationWorkingCopy.setAttribute(key, "");
            updateStatus.setTargetValues(Collections.singletonList(""));
        } else if (attributeValue instanceof List) {
            updateStatus.setSourceValues((List)attributeValue);
            launchConfigurationWorkingCopy.setAttribute(key, Collections.emptyList());
            updateStatus.setTargetValues(Collections.emptyList());
        } else if (attributeValue instanceof Set) {
            updateStatus.setSourceValues((Set)attributeValue);
            launchConfigurationWorkingCopy.setAttribute(key, Collections.emptySet());
            updateStatus.setTargetValues(Collections.emptySet());
        }
        return updateStatus;
    }

    private static ILaunchConfiguration getLaunchConfiguration(String projectName, String configurationId) throws CoreException {
        ILaunchConfiguration[] launchConfigurations;
        ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigurations = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
        int n = launchConfigurations.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration launchConfiguration = iLaunchConfigurationArray[n2];
            if (launchConfiguration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "").equals(projectName) && launchConfiguration.getAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", "").equals(configurationId)) {
                return launchConfiguration;
            }
            ++n2;
        }
        return null;
    }

    private static void applyLaunchConfigurationChanges(ILaunchConfiguration launchConfiguration, ILaunchConfigurationWorkingCopy launchConfigurationWorkingCopy) throws CoreException {
        if (!launchConfiguration.contentsEqual((ILaunchConfiguration)launchConfigurationWorkingCopy)) {
            launchConfigurationWorkingCopy.doSave();
        }
    }
}

