/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.project.configuration.internal.core.checkers;

import com.freescale.s32ds.cross.core.ProjectContextSettings;
import com.nxp.s32ds.cle.cdt.project.configuration.internal.core.ProjectConfigurationCoreActivator;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.ext.cdt.core.checker.IResourceChecker;
import com.nxp.s32ds.ext.ide.validation.core.HardwareSettingsProjectMarker;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class HardwareSettingsProjectResourceChecker
implements IResourceChecker {
    private static final String EMPTY = "";
    private static final String FILE_PATH_IN_NEW_PROJECT = "/.settings/com.nxp.s32ds.cle.runtime.component.prefs";
    private static final String FILE_PATH_IN_OLD_PROJECT = "/.settings/com.freescale.s32ds.cross.wizard.prefs";
    private static final String CORE_PROPERTY = "core";
    private static final String C_NATURE = "c";
    private static final String CC_NATURE = "c++";
    private static final Map<String, String> deviceCoreIdMapping = new HashMap<String, String>();

    static {
        deviceCoreIdMapping.put("S32R274_Z7_1", "S32R274_Z7_2");
        deviceCoreIdMapping.put("S32R274_Z7_2", "S32R274_Z7_3");
        deviceCoreIdMapping.put("S32K116_M0plus_1", "S32K116_M0P");
        deviceCoreIdMapping.put("S32K118_M0plus_1", "S32K118_M0P");
        deviceCoreIdMapping.put("S32K142_M4_1", "S32K142_M4F");
        deviceCoreIdMapping.put("S32K144_M4_1", "S32K144_M4F");
        deviceCoreIdMapping.put("S32K146_M4_1", "S32K146_M4F");
        deviceCoreIdMapping.put("S32K148_M4_1", "S32K148_M4F");
        deviceCoreIdMapping.put("SKEAZN8M4_M0plus_1", "SKEAZN8_M0P");
        deviceCoreIdMapping.put("SKEAZN16M2_M0plus_1", "SKEAZN16_M0P");
        deviceCoreIdMapping.put("SKEAZN32M2_M0plus_1", "SKEAZN32_M0P");
        deviceCoreIdMapping.put("SKEAZN64M2_M0plus_1", "SKEAZN64_M0P");
        deviceCoreIdMapping.put("SKEAZ64M4_M0plus_1", "SKEAZ64_M0P");
        deviceCoreIdMapping.put("SKEAZ128M4_M0plus_1", "SKEAZ128_M0P");
        deviceCoreIdMapping.put("MAC57D54H_A5_1", "MAC57D54H_A5");
        deviceCoreIdMapping.put("MAC57D54H_M4_1", "MAC57D54H_M4F");
        deviceCoreIdMapping.put("MAC57D54H_M0plus_1", "MAC57D54H_M0P");
        deviceCoreIdMapping.put("S32V_CortexM4_M4_1", "S32V234_M4");
        deviceCoreIdMapping.put("S32V_CortexA53_A53_1", "S32V234_A53_0_0");
        deviceCoreIdMapping.put("S32V_CortexA53_A53_2", "S32V234_A53_0_1");
        deviceCoreIdMapping.put("S32V_CortexA53_A53_3", "S32V234_A53_1_0");
        deviceCoreIdMapping.put("S32V_CortexA53_A53_4", "S32V234_A53_1_1");
    }

    public IStatus check(IResource resource, IProgressMonitor monitor) {
        return HardwareSettingsProjectResourceChecker.checkProjectVersion(resource, monitor);
    }

    private static IStatus checkProjectVersion(IResource resource, IProgressMonitor monitor) {
        if (!(resource instanceof IProject)) {
            return Status.OK_STATUS;
        }
        IProject project = (IProject)resource;
        IResource newProjectSettings = project.findMember(FILE_PATH_IN_NEW_PROJECT);
        if (newProjectSettings != null) {
            return Status.OK_STATUS;
        }
        IResource oldProjectSettings = project.findMember(FILE_PATH_IN_OLD_PROJECT);
        if (oldProjectSettings != null) {
            Properties prop = new Properties();
            IFile prefs = project.getFile(oldProjectSettings.getProjectRelativePath());
            try {
                Throwable throwable = null;
                Object var8_11 = null;
                try (InputStream contentStream = prefs.getContents();){
                    prop.load(contentStream);
                    String deviceCoreId = prop.getProperty(CORE_PROPERTY);
                    if (deviceCoreId != null && HardwareSettingsProjectResourceChecker.storeHWSettings(project, deviceCoreId)) {
                        return Status.OK_STATUS;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (CoreException e) {
                ProjectConfigurationCoreActivator.getInstance().log(e.getStatus());
            }
            catch (IOException e) {
                ProjectConfigurationCoreActivator.getInstance().logError("Cannot read file:" + prefs, e);
            }
        }
        return HardwareSettingsProjectResourceChecker.createStatusWithMarker(project);
    }

    private static IStatus createStatusWithMarker(IProject project) {
        if (!HardwareSettingsProjectMarker.containsMarker((IResource)project)) {
            return HardwareSettingsProjectMarker.createMarker((IProject)project);
        }
        return Status.OK_STATUS;
    }

    private static boolean storeHWSettings(IProject project, String deviceCoreId) {
        DeviceCoreDescriptor deviceCoreDescriptor;
        if (deviceCoreIdMapping.containsKey(deviceCoreId)) {
            deviceCoreId = deviceCoreIdMapping.get(deviceCoreId);
        }
        String langId = EMPTY;
        try {
            if (project.hasNature("org.eclipse.cdt.core.cnature")) {
                langId = C_NATURE;
            }
            if (project.hasNature("org.eclipse.cdt.core.ccnature")) {
                langId = CC_NATURE;
            }
        }
        catch (CoreException ex) {
            ProjectConfigurationCoreActivator.getInstance().log(ex.getStatus());
        }
        if (langId.isEmpty()) {
            ProjectConfigurationCoreActivator.getInstance().logWarning(NLS.bind((String)"Cannot detect language id for project {0}", (Object)project.getName()));
        }
        if ((deviceCoreDescriptor = DeviceDescriptors.getDeviceCoreDescriptor((String)deviceCoreId)) == null) {
            ProjectConfigurationCoreActivator.getInstance().logWarning(NLS.bind((String)"Cannot find device core descriptor with id {0}", (Object)deviceCoreId));
            return false;
        }
        String deviceId = deviceCoreDescriptor.getDeviceId();
        List familyDescriptors = DeviceDescriptors.getFamilyDescriptors((String)deviceId);
        if (familyDescriptors.isEmpty()) {
            ProjectConfigurationCoreActivator.getInstance().logWarning(NLS.bind((String)"Cannot find family descriptor for device with id {0}", (Object)deviceId));
            return false;
        }
        String familyId = ((FamilyDescriptor)familyDescriptors.get(0)).getId();
        String coreId = deviceCoreDescriptor.getCoreId();
        ProjectContextSettings projectContextSettings = new ProjectContextSettings(project);
        String platformId = projectContextSettings.getAttributeByKey("com.nxp.s32ds.cle.runtime.component.registry.archetype.platform.id");
        projectContextSettings.storeProjectContext(familyId, deviceId, coreId, deviceCoreId, null, EMPTY, langId, platformId);
        return true;
    }
}

