/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.common.uct.ui.xml.settings;

import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.ItemSetting;
import com.nxp.swtools.common.utils.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="enum", strict=false)
public class EnumSetting
extends ABaseUIComponentSetting {
    @ElementList(inline=true, required=false)
    private List<ItemSetting> items;
    private ItemSetting currentSelection;
    @Nullable
    private ABaseUIComponentSetting parent;

    public EnumSetting() {
        this.items = new ArrayList<ItemSetting>();
        this.currentSelection = new ItemSetting();
    }

    public EnumSetting(EnumSetting enumSetting, ABaseUIComponentSetting parent) {
        super(enumSetting.getId(), enumSetting);
        this.items = new ArrayList<ItemSetting>(enumSetting.getItems());
        this.currentSelection = new ItemSetting();
        this.parent = parent;
    }

    public List<ItemSetting> getItems() {
        return this.items;
    }

    public List<ItemSetting> getVisibleItems() {
        ArrayList<ItemSetting> visibleItems = new ArrayList<ItemSetting>();
        for (ItemSetting item : this.items) {
            if (!item.isVisible()) continue;
            visibleItems.add(item);
        }
        return visibleItems;
    }

    public @Nullable ItemSetting getItemById(String id) {
        for (ItemSetting item : this.items) {
            if (!id.equalsIgnoreCase(item.getId())) continue;
            return item;
        }
        return null;
    }

    public @Nullable ItemSetting getItemByName(String name) {
        for (ItemSetting item : this.items) {
            if (!name.equalsIgnoreCase(item.getLabel())) continue;
            return item;
        }
        return null;
    }

    public ItemSetting getCurrentSelection() {
        return this.currentSelection;
    }

    public void setCurrentSelection(String currentSelection) {
        for (ItemSetting item : this.items) {
            if (!currentSelection.equals(item.getLabel())) continue;
            this.currentSelection = item;
            return;
        }
    }

    public void setCurrentSelection(ItemSetting item) {
        this.currentSelection = item;
    }

    public void setParent(@Nullable ABaseUIComponentSetting parent) {
        this.parent = parent;
    }

    public @Nullable ABaseUIComponentSetting getParent() {
        return this.parent;
    }

    @Override
    public long getValueToWrite() {
        return this.currentSelection.getValueToWrite();
    }
}

