/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject.parsers;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.processors.KExProcessorsProvider;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.sdkproject.SdkComponentInProject;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class GenericPrjAdapterWithParser {
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(GenericPrjAdapterWithParser.class);
    @NonNull
    final File prjFile;
    @NonNull
    final Path prjPath;
    @Nullable
    String detectedProcessor;
    @Nullable
    String detectedPartNumber;
    boolean isDefaultPartNumber;
    @Nullable
    ProcessorCore detectedCore;
    @Nullable
    String differenceInProcessor;
    @Nullable
    String detectedProjectName;
    @NonNull
    final IToolchainProjectWithSdk existingProcessorDetector;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    GenericPrjAdapterWithParser(@NonNull File prjFile, @NonNull File prjDir, @NonNull IToolchainProjectWithSdk existingProcessorDetector) {
        this.prjFile = prjFile;
        this.prjPath = prjDir.toPath().normalize();
        this.existingProcessorDetector = existingProcessorDetector;
        ISharedConfiguration cfg = SharedConfigurationFactory.getSharedConfigurationSingleton();
        @NonNull Collection cores = cfg.getCommonConfig().getCores();
        if (cores.size() == 1) {
            this.detectedCore = (ProcessorCore)CollectionsUtils.first((Collection)cores);
        }
    }

    @NonNull String getToolchainPrjFilePathStr() {
        return this.prjFile.getAbsolutePath();
    }

    public @NonNull Path getToolchainPrjFilePath() {
        return this.prjFile.toPath().normalize();
    }

    public @NonNull Set<Path> getAdditionalPrjFilePathsToWatch() {
        return Collections.emptySet();
    }

    public @NonNull Path getProjectRootPath() {
        return this.prjPath;
    }

    public abstract boolean parse(@NonNull Collection<@NonNull SdkComponentInProject> var1, @NonNull Set<@NonNull Path> var2, @NonNull List<@NonNull Path> var3, @NonNull IProgressMonitor var4);

    boolean detectProcessorCore(@NonNull String coreId, AtomicBoolean isMulticore) {
        Collection cores;
        SWToolsPlatform.CoresInfoLoader coresInfo;
        assert (!isMulticore.get());
        String processor = UtilsText.safeString((String)this.detectedProcessor);
        if (processor.isEmpty()) {
            coresInfo = null;
        } else {
            String sdkVersion = SWToolsPlatform.getSdkVersionForProcessor((String)processor);
            ISupportedDerivativesForSwTools suppDerivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
            coresInfo = SWToolsPlatform.getCoresInfo((String)processor, (String)sdkVersion, (ISupportedDerivativesForSwTools)suppDerivatives);
        }
        if (coresInfo != null) {
            cores = coresInfo.cores;
        } else {
            ISharedConfiguration configuration = SharedConfigurationFactory.getSharedConfigurationSingleton();
            cores = configuration.getCommonConfig().getCores();
        }
        if (cores.size() == 1) {
            this.detectedCore = (ProcessorCore)CollectionsUtils.first(cores);
            return true;
        }
        if (cores.size() > 1) {
            isMulticore.set(true);
        }
        if (!coreId.isEmpty() && !coreId.equals("unknownCore")) {
            for (ProcessorCore aCore : cores) {
                if (!aCore.getID().equals(coreId)) continue;
                this.detectedCore = aCore;
                return true;
            }
            LOGGER.warning(String.format("Core `%s` specified in the project file does not match with any supported core", coreId));
        }
        return false;
    }

    public @Nullable IProcessorMasterToolInfo getProcessorInfo() {
        String processor = this.detectedProcessor;
        if (processor == null) {
            return null;
        }
        return SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools().getProcessorMasterToolInfo(processor, SWToolsPlatform.getSdkVersionForProcessor((String)processor));
    }

    @Nullable IProcessorMasterToolInfo getProcessorInfo(@NonNull String processorId) {
        if (!this.existingProcessorDetector.existsProcessor(processorId)) {
            return null;
        }
        ISupportedDerivativesForSwTools suppDerivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        return suppDerivatives.getProcessorMasterToolInfo(processorId, SWToolsPlatform.getSdkVersionForProcessor((String)processorId));
    }

    boolean setDetectedPartNumber(@NonNull String partNumber) {
        String processor;
        ISupportedDerivativesForSwTools suppDerivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        IProcessorMasterToolInfo processorInfo = suppDerivatives.getProcessorInfoForPartNumber(partNumber);
        if (processorInfo == null) {
            String processorName = KExProcessorsProvider.getProcessorByPackage((String)partNumber, null);
            if (processorName == null) {
                return false;
            }
            if (!this.existingProcessorDetector.existsProcessor(processorName)) {
                return false;
            }
            processorInfo = suppDerivatives.getProcessorInfoForPartNumber(partNumber);
            if (processorInfo == null) {
                return false;
            }
        }
        this.detectedPartNumber = partNumber;
        this.detectedProcessor = processor = processorInfo.getId();
        SWToolsPlatform.CoresInfoLoader info = SWToolsPlatform.getCoresInfo((String)processor, (String)SWToolsPlatform.getSdkVersionForProcessor((String)processor), (ISupportedDerivativesForSwTools)suppDerivatives);
        if (info != null && info.cores.size() == 1) {
            this.detectedCore = (ProcessorCore)info.cores.get(0);
        }
        return true;
    }

    boolean setDetectedCoreFromSuffix(@NonNull String suffix) {
        String processor = this.detectedProcessor;
        assert (processor != null);
        ISupportedDerivativesForSwTools suppDerivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        SWToolsPlatform.CoresInfoLoader info = SWToolsPlatform.getCoresInfo((String)processor, (String)SWToolsPlatform.getSdkVersionForProcessor((String)processor), (ISupportedDerivativesForSwTools)suppDerivatives);
        if (info != null && info.cores.size() > 1) {
            for (ProcessorCore core : info.cores) {
                if (!core.getID().equalsIgnoreCase(suffix)) continue;
                this.detectedCore = core;
                return true;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    boolean setDetectedPartNumberFromSymbol(@NonNull String partNumber) {
        pos = partNumber.lastIndexOf(95);
        if (pos >= 0) ** GOTO lbl9
        return this.setDetectedPartNumber(partNumber);
lbl-1000:
        // 1 sources

        {
            if (partNumber.charAt(pos) == '_' && this.setDetectedPartNumber(partNumber.substring(0, pos))) {
                this.setDetectedCoreFromSuffix(partNumber.substring(pos + 1));
                return true;
            }
            --pos;
lbl9:
            // 2 sources

            ** while (pos > 0)
        }
lbl10:
        // 1 sources

        return this.setDetectedPartNumber(partNumber);
    }

    boolean autoselectPartNumber(@Nullable IProcessorMasterToolInfo processorInfo) {
        assert (this.detectedPartNumber == null);
        String procId = processorInfo != null ? processorInfo.getId() : null;
        ISharedConfiguration configuration = SharedConfigurationFactory.getSharedConfigurationSingleton();
        if (!configuration.isEmpty() && (procId == null || configuration.getCommonConfig().getMcu().equals(procId))) {
            this.detectedPartNumber = configuration.getCommonConfig().getPackage();
            this.detectedProcessor = configuration.getCommonConfig().getMcu();
            return true;
        }
        if (this.detectedPartNumber == null && procId != null) {
            ISupportedDerivativesForSwTools suppDerivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
            this.detectedPartNumber = suppDerivatives.getDefaultVariantForMasterToolName(procId, SWToolsPlatform.getSdkVersionForProcessor((String)procId), null);
            this.detectedProcessor = procId;
            this.isDefaultPartNumber = true;
            return true;
        }
        return false;
    }

    public @Nullable ProcessorCore getDetectedCore() {
        return this.detectedCore;
    }

    public @Nullable String getDetectedPrjName() {
        return this.detectedProjectName;
    }

    public abstract @Nullable String getToolchainId();

    public abstract @Nullable String getToolchainName();

    public @Nullable String getDetectPartNumber() {
        return this.detectedPartNumber;
    }
}

