/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.internal.datacollection;

import com.nxp.s32ds.ext.rcp.datacollection.ArbitrageProcessor;
import com.nxp.s32ds.ext.rcp.datacollection.storage.LogBuilder;
import com.nxp.s32ds.ext.rcp.datacollection.storage.StorageService;
import com.nxp.s32ds.ext.rcp.datacollection.storage.json.JsonBuilder;
import com.nxp.s32ds.ext.rcp.internal.datacollection.ArbitrageService;
import com.nxp.s32ds.ext.rcp.internal.datacollection.DataCollectionActivator;
import com.nxp.s32ds.ext.rcp.internal.datacollection.Messages;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.osgi.util.NLS;

public class StorageServiceImpl
implements StorageService,
ArbitrageProcessor {
    private static final String OPEN_MODE = "rw";
    private static final int LAST_RECORD_OFFSET = 3;
    private static final int FIRST_SLEEP = 1000;
    private static final int SECOND_SLEEP = 1000;
    private static final int THIRD_SLEEP = 1000;
    private String logFilePath = "";
    private LogBuilder jsonBuilder = new JsonBuilder();
    private UUID sessionUuid = UUID.randomUUID();
    private ArbitrageService arbitrage = ArbitrageService.getDataCollectionArbitr();
    private Queue<Map<String, String>> dataQueue = new ConcurrentLinkedQueue<Map<String, String>>();

    @Override
    public void setLocation(String location) {
        Path path = Paths.get(location, new String[0]);
        if (Files.exists(path, LinkOption.NOFOLLOW_LINKS)) {
            this.logFilePath = path.toString();
        } else {
            try {
                Path parentDir = path.getParent();
                if (parentDir != null && !parentDir.toFile().exists()) {
                    Files.createDirectories(parentDir, new FileAttribute[0]);
                }
                this.logFilePath = Files.createFile(path, new FileAttribute[0]).toFile().toString();
            }
            catch (IOException e) {
                this.logFilePath = "";
                DataCollectionActivator.getInstance().logError(NLS.bind((String)Messages.StorageServiceImpl_cannot_create_log_file_by_path, (Object)path), e);
            }
        }
    }

    @Override
    public void storeRecords(Map<String, String> r) {
        block7: {
            this.dataQueue.add(r);
            if (!this.arbitrage.isAccesiable()) {
                try {
                    Thread.sleep(1000L);
                    if (!this.arbitrage.isAccesiable()) {
                        Thread.sleep(1000L);
                        if (!this.arbitrage.isAccesiable()) {
                            Thread.sleep(1000L);
                        } else {
                            this.process();
                        }
                        break block7;
                    }
                    this.process();
                }
                catch (InterruptedException e) {
                    DataCollectionActivator.getInstance().logError(e.getMessage());
                    Thread.currentThread().interrupt();
                }
            } else {
                this.process();
            }
        }
    }

    private void process() {
        this.arbitrage.startProcess(this, Paths.get(this.logFilePath, new String[0]));
    }

    @Override
    public void processUnderArbitrage() {
        while (!this.dataQueue.isEmpty()) {
            this.writeToLog(this.dataQueue.poll());
        }
    }

    private void writeToLog(Map<String, String> map) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (RandomAccessFile fileWriter = new RandomAccessFile(this.logFilePath, OPEN_MODE);){
                long length = fileWriter.length();
                String timestamp = String.valueOf(System.currentTimeMillis());
                String data = this.jsonBuilder.build(map, this.sessionUuid.toString(), timestamp);
                if (length == 0L) {
                    fileWriter.writeBytes(this.jsonBuilder.wrapFirstRecord(data));
                    return;
                }
                fileWriter.seek(length - 3L);
                fileWriter.writeBytes(this.jsonBuilder.wrapNextRecord(data));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            DataCollectionActivator.getInstance().logError(ex.getMessage());
        }
    }
}

