/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.integration.ddr.codegen;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.ddr.codegen.CodeGenerationController;
import com.nxp.swtools.ddr.views.internal.DDRSourcesContentProvider;
import com.nxp.swtools.mem.validation.Activator;
import com.nxp.swtools.mem.validation.IConfigProvider;
import com.nxp.swtools.mem.validation.codgen.MemValSourcesContentProvider;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.integration.ddr.Messages;
import com.nxp.swtools.provider.configuration.sources.ISourceFile;
import com.nxp.swtools.utils.scripting.ScriptResult;
import com.nxp.swtools.utils.sources.ISourcesContentProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DDRPerspectiveSourcesContentProvider
implements ISourcesContentProvider {
    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Collection<@NonNull ISourceFile> getContent() {
        IConfigProvider configController;
        @NonNull Collection content = DDRSourcesContentProvider.getInstance().getContent();
        if ((content.isEmpty() || !CodeGenerationController.getInstance().isResultsUpdateEnabled()) && !CodeGenerationController.getInstance().isConfigurationReloaded() && (configController = ValidationContext.getInstance().getConfigController()) != null && configController.isEnabled()) {
            content = MemValSourcesContentProvider.getInstance().getContent();
        }
        List<@NonNull ISourceFile> contentList = content.stream().collect(Collectors.toList());
        Collections.sort(contentList, new Comparator<ISourceFile>(){

            @Override
            public int compare(ISourceFile o1, ISourceFile o2) {
                return o1.getRelFileName().compareTo(o2.getRelFileName());
            }
        });
        return contentList;
    }

    public @Nullable String getStatus() {
        ArrayList<@NonNull ScriptResult> results = new ArrayList<ScriptResult>();
        this.addScriptResults(results);
        Iterator<@NonNull E> iterator = results.iterator();
        while (iterator.hasNext()) {
            if (!((ScriptResult)iterator.next()).containsAnyError()) continue;
            return Messages.CodeGenerationFailed;
        }
        iterator = results.iterator();
        while (iterator.hasNext()) {
            if (((ScriptResult)iterator.next()).getWarnings().isEmpty()) continue;
            return Messages.CodeGenerationWarnings;
        }
        return Messages.CodeGenerationSuccess;
    }

    public @Nullable String getWarningText() {
        ArrayList<@NonNull ScriptResult> results = new ArrayList<ScriptResult>();
        this.addScriptResults(results);
        String warnings = "";
        Iterator<@NonNull E> iterator = results.iterator();
        while (iterator.hasNext()) {
            String msg = ((ScriptResult)iterator.next()).getWarnings();
            if (msg.isEmpty()) continue;
            warnings = !warnings.isEmpty() ? warnings.concat(UtilsText.platformEOL) : "";
            warnings = warnings.concat(msg);
        }
        return warnings;
    }

    public @Nullable String getErrorText() {
        ArrayList<@NonNull ScriptResult> results = new ArrayList<ScriptResult>();
        this.addScriptResults(results);
        String errors = "";
        Iterator<@NonNull E> iterator = results.iterator();
        while (iterator.hasNext()) {
            String msg = ((ScriptResult)iterator.next()).getErrors();
            if (msg.isEmpty()) continue;
            errors = !errors.isEmpty() ? errors.concat(UtilsText.platformEOL) : "";
            errors = errors.concat(msg);
        }
        return errors;
    }

    public void addScriptResults(Collection<@NonNull ScriptResult> results) {
        if (!DDRSourcesContentProvider.getInstance().getContent().isEmpty() && CodeGenerationController.getInstance().isResultsUpdateEnabled() || CodeGenerationController.getInstance().isConfigurationReloaded()) {
            ScriptResult codeGenResult = CodeGenerationController.getInstance().getScriptResult();
            if (codeGenResult != null) {
                results.add(codeGenResult);
            }
        } else {
            ScriptResult validationResult;
            IConfigProvider configController = ValidationContext.getInstance().getConfigController();
            if (configController != null && configController.isEnabled() && (validationResult = Activator.getDefault().getCgenManager().getScriptResult()) != null) {
                results.add(validationResult);
            }
        }
    }
}

