/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.launching;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.core.cdtvariables.ICdtVariableManager;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.dsf.gdb.IGDBFlatpakLaunchConstants;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.launching.LaunchMessages;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;

public class FlatpakLaunch {
    private static final String LOCAL_HOST = "localhost";
    private static final String FLATPAK_DEBUG_PROCESS_LABEL = "FlatpakDebugProcess_label";

    private String[] getLaunchEnvironment(IProject project, ILaunchConfiguration config) throws CoreException {
        HashMap<String, String> envMap = new HashMap<String, String>();
        ICProjectDescription projDesc = CoreModel.getDefault().getProjectDescription(project, false);
        if (projDesc != null) {
            ICdtVariable[] buildVars;
            IEnvironmentVariable[] vars;
            String buildConfigID = config.getAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", "");
            ICConfigurationDescription cfg = null;
            if (buildConfigID.length() != 0) {
                cfg = projDesc.getConfigurationById(buildConfigID);
            }
            if (cfg == null) {
                cfg = projDesc.getActiveConfiguration();
            }
            IEnvironmentVariable[] iEnvironmentVariableArray = vars = CCorePlugin.getDefault().getBuildEnvironmentManager().getVariables(cfg, true);
            int n = vars.length;
            int n2 = 0;
            while (n2 < n) {
                IEnvironmentVariable var = iEnvironmentVariableArray[n2];
                envMap.put(var.getName(), var.getValue());
                ++n2;
            }
            ICdtVariableManager manager = CCorePlugin.getDefault().getCdtVariableManager();
            ICdtVariable[] iCdtVariableArray = buildVars = manager.getVariables(cfg);
            int n3 = buildVars.length;
            int n4 = 0;
            while (n4 < n3) {
                ICdtVariable var = iCdtVariableArray[n4];
                try {
                    if (!"project_classpath".equals(var.getName())) {
                        String value = manager.resolveValue(var.getStringValue(), "", File.pathSeparator, cfg);
                        envMap.put(var.getName(), value);
                    }
                }
                catch (CdtVariableException cdtVariableException) {
                    // empty catch block
                }
                ++n4;
            }
        }
        ArrayList<String> strings = new ArrayList<String>(envMap.size());
        for (Map.Entry entry : envMap.entrySet()) {
            StringBuilder buffer = new StringBuilder((String)entry.getKey());
            buffer.append('=').append((String)entry.getValue());
            strings.add(buffer.toString());
        }
        return strings.toArray(new String[strings.size()]);
    }

    protected Map<String, String> createProcessAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("org.eclipse.cdt.dsf.gdb.createProcessType", "org.eclipse.cdt.dsf.gdb.inferiorProcess");
        attributes.put("org.eclipse.cdt.dsf.gdb.inferiorExited", "");
        return attributes;
    }

    public int prelaunch(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IPath commandPath = this.getCommandPath(configuration);
        if (commandPath != null) {
            Path workingPath;
            String workingDir;
            String projectName = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            String gdbserverPortNumber = configuration.getAttribute(IGDBFlatpakLaunchConstants.ATTR_GDBSERVER_PORT, "2345");
            String gdbserverPort = String.valueOf(gdbserverPortNumber) + "/tcp";
            String gdbserverCommand = configuration.getAttribute(IGDBFlatpakLaunchConstants.ATTR_GDBSERVER_COMMAND, "gdbserver");
            String commandString = commandPath.toPortableString();
            String commandDir = commandPath.removeLastSegments(1).toPortableString();
            if (commandPath.getDevice() != null) {
                commandDir = "/" + commandDir.replace(':', '/');
                commandString = "/" + commandString.replace(':', '/');
            }
            String commandArguments = ":" + gdbserverPortNumber + " " + this.spaceEscapify(commandString);
            StringBuilder b = new StringBuilder();
            String[] commandArray = new String[]{"/bin/sh", "-c", b.append(gdbserverCommand).append(' ').append(commandArguments).toString()};
            String arguments = this.getProgramArguments(configuration);
            if (arguments.trim().length() > 0) {
                b.append(" ");
                b.append(arguments);
            }
            if ((workingDir = configuration.getAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null)) == null && projectName != null) {
                workingDir = project.getLocation().toOSString();
            }
            if (workingDir != null && (workingPath = new Path(workingDir)).getDevice() != null) {
                workingDir = "/" + workingPath.toPortableString().replace(':', '/');
            }
            String[] envp = this.getLaunchEnvironment(project, configuration);
            boolean gdbserverStarted = false;
            try {
                Process p = ProcessFactory.getFactory().exec(commandArray, envp, new File(workingDir), new PTY(PTY.Mode.TERMINAL));
                IProcess gdbserver = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)LaunchMessages.getString(FLATPAK_DEBUG_PROCESS_LABEL), this.createProcessAttributes());
                Thread.sleep(200L);
                try {
                    int n = gdbserver.getExitValue();
                }
                catch (DebugException e2) {
                    gdbserverStarted = true;
                }
            }
            catch (IOException e) {
                GdbPlugin.log(e);
            }
            catch (InterruptedException e) {
                DebugPlugin.log((Throwable)e);
            }
            if (gdbserverStarted) {
                ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
                wc.setAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TCP", true);
                wc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "remote");
                wc.setAttribute("org.eclipse.cdt.dsf.gdb.HOST", LOCAL_HOST);
                wc.setAttribute("org.eclipse.cdt.dsf.gdb.PORT", gdbserverPort);
                wc.doSave();
                return 0;
            }
            return -1;
        }
        return -1;
    }

    private String getProgramArguments(ILaunchConfiguration config) throws CoreException {
        String args = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", "");
        if (args != null && args.length() > 0) {
            args = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(args);
        }
        return args;
    }

    private IPath getCommandPath(ILaunchConfiguration configuration) throws CoreException {
        String projectName = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
        if (projectName.length() > 0) {
            IProject project = CCorePlugin.getWorkspace().getRoot().getProject(projectName);
            if (project == null) {
                return null;
            }
            String name = configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
            if (name.length() == 0) {
                return null;
            }
            Path exePath = new Path(name);
            if (!exePath.isAbsolute()) {
                IPath location = project.getLocation();
                if (location == null) {
                    return null;
                }
                exePath = location.append(name);
                if (!exePath.toFile().exists()) {
                    IFile projFile = null;
                    try {
                        projFile = project.getFile(name);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (projFile == null || !projFile.exists()) {
                        return null;
                    }
                    exePath = projFile.getLocation();
                }
            }
            if (!exePath.toFile().exists()) {
                return null;
            }
            if (!exePath.toFile().isFile()) {
                return null;
            }
            return exePath;
        }
        return null;
    }

    private String spaceEscapify(String inputString) {
        if (inputString == null) {
            return null;
        }
        return inputString.replaceAll(" ", "\\\\ ");
    }

    public static IProject getProject(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getMappedResources()[0].getProject();
    }
}

