/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.internal.ui.view.wizard;

import com.nxp.s32ds.cdt.svd.internal.ui.CdtSvdUiActivator;
import com.nxp.s32ds.cdt.svd.internal.ui.Messages;
import com.nxp.s32ds.cdt.svd.internal.ui.view.SvdTreeViewer;
import com.nxp.s32ds.cdt.svd.internal.ui.view.SvdTreeViewerInput;
import com.nxp.s32ds.cdt.svd.internal.ui.view.SvdTreeViewerInputs;
import com.nxp.s32ds.cdt.svd.internal.ui.view.watch.SvdUiWatchModelCacheManager;
import com.nxp.s32ds.cdt.svd.internal.ui.view.wizard.SvdImportRegistersWizardPage1;
import com.nxp.s32ds.cdt.svd.internal.ui.view.wizard.SvdImportRegistersWizardPage2;
import com.nxp.s32ds.cdt.svd.internal.ui.view.wizard.SvdImportedRegister;
import com.nxp.s32ds.cdt.svd.model.SvdCompositeModel;
import com.nxp.s32ds.cdt.svd.model.SvdRegister;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class SvdImportRegistersWizard
extends Wizard
implements IExportWizard {
    private SvdImportRegistersWizardPage1 page1;
    private SvdImportRegistersWizardPage2 page2;
    private final SvdTreeViewer viewer;
    private WizardDialog wizardDialog;
    private final ListenerList<IPageChangingListener> pageChangingListeners = new ListenerList();
    private final IPageChangingListener listener = e -> this.firePageChanging(e);

    public SvdImportRegistersWizard(SvdTreeViewer viewer) {
        this.viewer = viewer;
        this.setDialogSettings(CdtSvdUiActivator.getInstance().getDialogSettingsSection(((Object)((Object)this)).getClass()));
        this.setWindowTitle(Messages.SvdImportRegistersWizard_import_registers);
        this.setNeedsProgressMonitor(true);
    }

    public void addPageChangingListener(IPageChangingListener listener) {
        this.pageChangingListeners.add((Object)listener);
    }

    public void removePageChangingListener(IPageChangingListener listener) {
        this.pageChangingListeners.remove((Object)listener);
    }

    protected void firePageChanging(final PageChangingEvent event) {
        for (final IPageChangingListener listener : this.pageChangingListeners) {
            if (!event.doit) break;
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    listener.handlePageChanging(event);
                }
            });
        }
    }

    public void setContainer(IWizardContainer wizardContainer) {
        super.setContainer(wizardContainer);
        if (wizardContainer instanceof WizardDialog) {
            this.wizardDialog = (WizardDialog)wizardContainer;
            this.wizardDialog.addPageChangingListener(this.listener);
        }
    }

    public void addPages() {
        super.addPages();
        this.page1 = new SvdImportRegistersWizardPage1(this.viewer);
        this.page2 = new SvdImportRegistersWizardPage2(this.viewer);
        this.addPage((IWizardPage)this.page1);
        this.addPage((IWizardPage)this.page2);
    }

    public void dispose() {
        super.dispose();
        if (this.wizardDialog != null) {
            this.wizardDialog.removePageChangingListener(this.listener);
        }
    }

    public boolean performFinish() {
        if (!this.page1.finish() || !this.page2.finish()) {
            return false;
        }
        try {
            this.importRegisters(this.page2.getCheckedElements(), this.page2.importValues());
        }
        catch (CoreException e) {
            IStatus status = e.getStatus();
            CdtSvdUiActivator.getInstance().log(status);
            ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)status);
            return false;
        }
        return true;
    }

    private void importRegisters(List<SvdImportedRegister> importedRegisters, boolean importValues) throws CoreException {
        SvdTreeViewerInput input = this.viewer.getInput();
        if (input == null) {
            throw new CoreException(CdtSvdUiActivator.getInstance().createError(Messages.SvdImportRegistersWizard_there_is_no_active_valid_debug_session));
        }
        List registers = importedRegisters.stream().map(r -> r.register).collect(Collectors.toList());
        SvdUiWatchModelCacheManager.getInstance().addToWatch(input.launch.getSession(), registers);
        if (importValues) {
            SvdCompositeModel<?> model = input.model;
            for (SvdImportedRegister importedRegister : importedRegisters) {
                if (!importedRegister.canSetValue()) continue;
                String path = importedRegister.register.getPath();
                SvdRegister watchRegister = (SvdRegister)model.getByPath(path);
                if (watchRegister == null) {
                    CdtSvdUiActivator.getInstance().logError(NLS.bind((String)"Cannot find register with path {0}", (Object)path));
                    continue;
                }
                SvdTreeViewerInputs.setValue(this.viewer, watchRegister, importedRegister.value);
            }
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(Messages.SvdImportRegistersWizard_import_registers);
    }

    public Collection<SvdImportedRegister> getImportedRegisters() {
        return this.page1.getImportedRegisters();
    }

    public boolean canFinish() {
        return super.canFinish() && this.getImportedRegisters() != null;
    }
}

