/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.internal.ui.view.watch.provider;

import com.nxp.s32ds.cdt.svd.internal.ui.view.SvdTreeViewer;
import com.nxp.s32ds.cdt.svd.internal.ui.view.SvdTreeViewerInputs;
import com.nxp.s32ds.cdt.svd.internal.ui.view.provider.SvdColumnLabelProvider;
import com.nxp.s32ds.cdt.svd.model.SvdAccesible;
import com.nxp.s32ds.cdt.svd.model.SvdField;
import com.nxp.s32ds.cdt.svd.model.SvdRegister;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchContext;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchModel;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchReadPolicyType;
import com.nxp.s32ds.cdt.svd.parser.model.AccessType;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public abstract class SvdColumnLabelColoredProvider<T>
extends SvdColumnLabelProvider<T> {
    private static final String FONT = "SvdColumnLabelColoredProviderFont";
    private static volatile boolean initialized = false;
    private static final Object lockObj = new Object();

    public SvdColumnLabelColoredProvider(Class<T> _class) {
        super(_class);
    }

    public void update(ViewerCell cell) {
        super.update(cell);
        Object element = cell.getElement();
        cell.setFont(SvdColumnLabelColoredProvider.getFont(cell.getControl().getFont(), element));
    }

    private static Font getFont(Font font, Object element) {
        if (!(element instanceof SvdAccesible)) {
            return null;
        }
        SvdAccesible accesible = (SvdAccesible)element;
        SvdRegister register = accesible instanceof SvdField ? ((SvdField)accesible).getParent() : (SvdRegister)accesible;
        SvdWatchContext context = ((SvdWatchModel)register.getModel()).getContextManager().getContext(register);
        if (context.getReadPolicy().getType() != SvdWatchReadPolicyType.READ_ON_DEMAND) {
            return null;
        }
        return SvdColumnLabelColoredProvider.getItalicFont(font);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Font getItalicFont(Font font) {
        if (!initialized) {
            Object object = lockObj;
            synchronized (object) {
                if (!initialized) {
                    JFaceResources.getFontRegistry().put(FONT, font.getFontData());
                    initialized = true;
                }
            }
        }
        return JFaceResources.getFontRegistry().getItalic(FONT);
    }

    public Color getForeground(Object element) {
        int foregroundColorCode = SvdColumnLabelColoredProvider.getForegroundColorCode(this.getViewer(), element);
        if (foregroundColorCode == -1) {
            return null;
        }
        return this.getSystemColor(foregroundColorCode);
    }

    static int getForegroundColorCode(SvdTreeViewer input, Object element) {
        if (!(element instanceof SvdAccesible)) {
            return -1;
        }
        SvdAccesible accesible = (SvdAccesible)element;
        AccessType accessType = accesible.getAccessType();
        switch (accessType) {
            case READ_ONLY: {
                return -1;
            }
            case READ_WRITE: {
                return 6;
            }
            case READ_WRITE_ONCE: {
                if (!SvdTreeViewerInputs.canWrite(input, accesible)) {
                    return -1;
                }
                return 6;
            }
            case WRITE_ONLY: {
                return 9;
            }
            case WRITE_ONCE: {
                if (!SvdTreeViewerInputs.canWrite(input, accesible)) {
                    return -1;
                }
                return 9;
            }
        }
        return -1;
    }
}

