/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.internal.ui.view.watch;

import com.nxp.s32ds.cdt.svd.internal.ui.Messages;
import com.nxp.s32ds.cdt.svd.internal.ui.view.SvdTreeViewer;
import com.nxp.s32ds.cdt.svd.internal.ui.view.provider.SvdColumnLabelCompositeProvider;
import com.nxp.s32ds.cdt.svd.internal.ui.view.provider.SvdColumnLabelPeripheralsProviders;
import com.nxp.s32ds.cdt.svd.internal.ui.view.provider.SvdColumnLabelProvider;
import com.nxp.s32ds.cdt.svd.internal.ui.view.provider.SvdContentRegisterProvider;
import com.nxp.s32ds.cdt.svd.internal.ui.view.watch.edit.SvdBinaryColumnEditingSupport;
import com.nxp.s32ds.cdt.svd.internal.ui.view.watch.edit.SvdHexColumnCompositeEditingSupport;
import com.nxp.s32ds.cdt.svd.internal.ui.view.watch.provider.SvdColumnLabelDescriptionProviderDecorator;
import com.nxp.s32ds.cdt.svd.internal.ui.view.watch.provider.SvdColumnLabelPeripheralProviderDecorator;
import com.nxp.s32ds.cdt.svd.internal.ui.view.watch.provider.SvdColumnLabelProviderDecorator;
import com.nxp.s32ds.cdt.svd.internal.ui.view.watch.provider.SvdColumnLabelWatchProviders;
import java.util.stream.IntStream;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.widgets.Composite;

public class SvdWatchTreeViewer
extends SvdTreeViewer {
    private boolean showFullPath;

    public SvdWatchTreeViewer(Composite parent, String mementoId) {
        super(parent, mementoId);
    }

    @Override
    protected ITreeContentProvider createFlatContentProvider() {
        return new SvdContentRegisterProvider();
    }

    @Override
    protected void createColumns() {
        this.createPeripheralsColumn();
        TreeViewerColumn hexColumn = new TreeViewerColumn((TreeViewer)this, 0);
        this.addToColumnsList(hexColumn);
        hexColumn.getColumn().setText(Messages.SvdWatchTreeViewer_hex);
        hexColumn.getColumn().setMoveable(true);
        hexColumn.setLabelProvider((CellLabelProvider)new SvdColumnLabelCompositeProvider(new SvdColumnLabelWatchProviders.RegisterHexLabelProvider(), new SvdColumnLabelWatchProviders.FieldHexLabelProvider()));
        hexColumn.setEditingSupport((EditingSupport)new SvdHexColumnCompositeEditingSupport(this));
        TreeViewerColumn binaryColumn = new TreeViewerColumn((TreeViewer)this, 0);
        this.addToColumnsList(binaryColumn);
        binaryColumn.getColumn().setText(Messages.SvdWatchTreeViewer_binary);
        binaryColumn.getColumn().setMoveable(true);
        binaryColumn.setLabelProvider((CellLabelProvider)new SvdColumnLabelCompositeProvider(new SvdColumnLabelWatchProviders.RegisterBinaryLabelProvider(), new SvdColumnLabelWatchProviders.FieldBinaryLabelProvider()));
        binaryColumn.setEditingSupport((EditingSupport)new SvdBinaryColumnEditingSupport(this));
        this.createAddressColumn();
        this.createDescriptionColumn();
    }

    @Override
    public SvdColumnLabelProvider<?>[] createPeripheralColumnLabelProviders() {
        SvdColumnLabelProvider<?>[] providers = SvdColumnLabelPeripheralsProviders.getProviders();
        SvdColumnLabelProvider[] newProviders = new SvdColumnLabelProvider[providers.length];
        int i = 0;
        while (i < providers.length) {
            newProviders[i] = new SvdColumnLabelPeripheralProviderDecorator(providers[i]);
            ++i;
        }
        return newProviders;
    }

    @Override
    protected SvdColumnLabelProvider<?> createAddressColumnLabelProvider() {
        return new SvdColumnLabelProviderDecorator(super.createAddressColumnLabelProvider());
    }

    @Override
    protected SvdColumnLabelProvider<?> createDescriptionColumnLabelProviders() {
        return new SvdColumnLabelDescriptionProviderDecorator(super.createDescriptionColumnLabelProviders());
    }

    @Override
    public int[] getDefaultColumnMinimumWidth() {
        return IntStream.of(250, 100, 70, 100, 300).toArray();
    }

    public void showFullPath(boolean showFullPath) {
        if (this.showFullPath != showFullPath) {
            this.showFullPath = showFullPath;
            this.refresh(true);
        }
    }

    @Override
    public boolean showFullPath() {
        return !this.showStructure() && this.showFullPath;
    }
}

