/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.internal.ui.view.action;

import com.nxp.s32ds.cdt.svd.internal.ui.CdtSvdUiActivator;
import com.nxp.s32ds.cdt.svd.internal.ui.Messages;
import com.nxp.s32ds.cdt.svd.internal.ui.view.action.SvdActionBase;
import com.nxp.s32ds.cdt.svd.internal.ui.view.watch.SvdUiWatchModelCacheManager;
import com.nxp.s32ds.cdt.svd.internal.ui.view.watch.SvdWatchTreeViewer;
import com.nxp.s32ds.cdt.svd.model.SvdContainer;
import com.nxp.s32ds.cdt.svd.model.SvdField;
import com.nxp.s32ds.cdt.svd.model.SvdRegister;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.jface.viewers.IStructuredSelection;

public class SvdRemoveAction
extends SvdActionBase<SvdWatchTreeViewer> {
    public SvdRemoveAction(SvdWatchTreeViewer viewer) {
        super(viewer);
        this.setText(Messages.SvdRemoveAction_remove);
        this.setImageDescriptor(CdtSvdUiActivator.getInstance().getImageDescriptor("icon_remove"));
        this.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.setId(String.valueOf(CdtSvdUiActivator.getInstance().getBundleId()) + ".SvdRemoveAction");
    }

    public void run() {
        this.update();
        if (!this.isEnabled()) {
            return;
        }
        Optional<DsfSession> opt = ((SvdWatchTreeViewer)this.viewer).getDsfSession();
        if (!opt.isPresent()) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)((SvdWatchTreeViewer)this.viewer).getSelection();
        DsfSession session = opt.get();
        LinkedHashSet<SvdRegister> registers = new LinkedHashSet<SvdRegister>();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof SvdField) {
                SvdRegister parent = ((SvdField)object).getParent();
                registers.add(parent);
            } else if (object instanceof SvdRegister) {
                registers.add((SvdRegister)object);
            } else if (object instanceof SvdContainer) {
                registers.addAll(((SvdContainer)object).flattened().filter(e -> e instanceof SvdRegister).map(e -> (SvdRegister)e).collect(Collectors.toSet()));
            }
            ++n2;
        }
        SvdUiWatchModelCacheManager.getInstance().removeFromWatch(session, registers);
    }

    @Override
    public void update() {
        super.update();
        if (!this.isEnabled()) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)((SvdWatchTreeViewer)this.viewer).getSelection();
        this.setEnabled(!selection.isEmpty());
    }
}

