/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.internal.ui.view;

import com.nxp.s32ds.cdt.internal.svd.SvdActivator;
import com.nxp.s32ds.cdt.svd.internal.ui.view.SvdTreeViewerBase;
import com.nxp.s32ds.cdt.svd.internal.ui.view.SvdTreeViewerInput;
import com.nxp.s32ds.cdt.svd.internal.ui.view.SvdTreeViewerStructureChangedListener;
import com.nxp.s32ds.cdt.svd.internal.ui.view.action.SvdCopyAction;
import com.nxp.s32ds.cdt.svd.internal.ui.view.action.SvdDefaultLayoutAction;
import com.nxp.s32ds.cdt.svd.internal.ui.view.action.SvdFindAction;
import com.nxp.s32ds.cdt.svd.internal.ui.view.action.SvdShowStructureAction;
import com.nxp.s32ds.cdt.svd.internal.ui.view.action.SvdVisible;
import com.nxp.s32ds.cdt.svd.internal.ui.view.memento.SvdPeripheralRegistersViewBaseMemento;
import com.nxp.s32ds.cdt.svd.model.SvdCompositeModel;
import com.nxp.s32ds.cdt.svd.model.SvdDeviceModel;
import com.nxp.s32ds.cdt.svd.parser.cache.SvdLaunchCache;
import com.nxp.s32ds.cdt.svd.parser.cache.SvdLaunchToModelsCache;
import com.nxp.s32ds.cle.ide.debugger.svd.SvdSourceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.texteditor.IUpdate;

public abstract class SvdRegistersViewBase
extends AbstractDebugView
implements IDebugContextListener {
    private static final String DEFAULT_LAYOUT_ACTION = "DEFAULT_LAYOUT_ACTION";
    private static final String SHOW_STRUCTURE_ACTION = "SHOW_STRUCTURE_ACTION";
    private SvdTreeViewerBase treeViewer;
    private GdbLaunch currentLaunch;
    private IDMContext currentIdmContext;
    private final Map<String, IAction> actionsMap = new HashMap<String, IAction>();
    private final ISelectionChangedListener selectionChangedListener = e -> this.updateObjects();
    private final SvdTreeViewerStructureChangedListener structureChangedListener = e -> this.updateObjects();
    protected SvdLaunchCache<GdbLaunch, CompletableFuture<SvdCompositeModel<?>>> launchToModelCache = new SvdLaunchCache(l -> this.createCompositeModelFuture((GdbLaunch)l));

    public SvdTreeViewerBase getTreeViewer() {
        return this.treeViewer;
    }

    protected GdbLaunch getCurrentLaunch() {
        return this.currentLaunch;
    }

    public void partDeactivated(IWorkbenchPart part) {
        if (!part.getSite().getId().equals(this.getSite().getId())) {
            return;
        }
        if (this.treeViewer != null) {
            this.treeViewer.saveToMemento();
        }
        this.saveToMemento();
        super.partDeactivated(part);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.restoreFromMemento();
    }

    private void restoreFromMemento() {
        String id = this.getSite().getId();
        new SvdPeripheralRegistersViewBaseMemento(id).restoreFromMemento((Object)this);
    }

    private void saveToMemento() {
        String id = this.getSite().getId();
        new SvdPeripheralRegistersViewBaseMemento(id).saveToMemento((Object)this);
    }

    public void debugContextChanged(DebugContextEvent event) {
        IAdaptable adaptable = SvdRegistersViewBase.getAdaptable(event.getContext());
        this.updateContext(adaptable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateContext(IAdaptable adaptable) {
        if (adaptable == null) {
            return;
        }
        GdbLaunch launch = SvdRegistersViewBase.getLaunchFromContext(adaptable);
        IDMContext idmContext = SvdRegistersViewBase.getIdmContext(adaptable);
        SvdRegistersViewBase svdRegistersViewBase = this;
        synchronized (svdRegistersViewBase) {
            if (this.currentLaunch == launch && Objects.equals(this.currentIdmContext, idmContext)) {
                return;
            }
            this.currentLaunch = launch;
            this.currentIdmContext = idmContext;
            this.updateViewer();
        }
    }

    private static IDMContext getIdmContext(IAdaptable adaptable) {
        IDMContext idmContext = (IDMContext)adaptable.getAdapter(IDMContext.class);
        if (idmContext == null) {
            return null;
        }
        return DMContexts.getAncestorOfType((IDMContext)idmContext, IMemory.IMemoryDMContext.class);
    }

    private static GdbLaunch getLaunchFromContext(IAdaptable adaptable) {
        ILaunch launch = (ILaunch)adaptable.getAdapter(ILaunch.class);
        if (!(launch instanceof GdbLaunch)) {
            return null;
        }
        if (launch.isTerminated()) {
            return null;
        }
        return (GdbLaunch)launch;
    }

    public static IAdaptable getAdaptable(ISelection context) {
        if (!(context instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection selection = (IStructuredSelection)context;
        if (context.isEmpty()) {
            return null;
        }
        Object elem = selection.getFirstElement();
        if (!(elem instanceof IAdaptable)) {
            return null;
        }
        return (IAdaptable)elem;
    }

    private void updateViewer() {
        GdbLaunch localLaunch = this.currentLaunch;
        IDMContext idmContext = this.currentIdmContext;
        if (localLaunch == null || idmContext == null) {
            this.setInput(null);
            return;
        }
        ((CompletableFuture)((CompletableFuture)this.launchToModelCache.computeIfAbsent((ILaunch)localLaunch)).exceptionally(e -> {
            SvdActivator.getInstance().logError("updateViewer error", e);
            return null;
        })).thenAccept(m -> {
            if (this.treeViewer != null) {
                if (m != null) {
                    this.setInput(new SvdTreeViewerInput((SvdCompositeModel<?>)m, localLaunch, idmContext));
                } else {
                    this.setInput(null);
                }
            }
        });
    }

    protected CompletableFuture<SvdCompositeModel<?>> createCompositeModelFuture(GdbLaunch launch) {
        CompletableFuture future = new CompletableFuture();
        ((CompletableFuture)SvdLaunchToModelsCache.getInstance().getModelFutures((ILaunch)launch, this.getSuportedSvdSourceTypes()).exceptionally(e -> {
            SvdActivator.getInstance().logError("createCompositeModelFuture error", e);
            return null;
        })).thenAccept(models -> {
            if (models != null) {
                future.complete(this.createModel(launch.getSession(), (Collection<SvdDeviceModel>)models));
            } else {
                future.complete(null);
            }
        });
        return future;
    }

    protected abstract SvdCompositeModel<?> createModel(DsfSession var1, Collection<SvdDeviceModel> var2);

    protected abstract EnumSet<SvdSourceType> getSuportedSvdSourceTypes();

    protected void setInput(SvdTreeViewerInput input) {
        Display.getDefault().asyncExec(() -> {
            if (!this.treeViewer.getTree().isDisposed()) {
                this.treeViewer.setInput(input);
                this.updateObjects();
            }
        });
    }

    protected Viewer createViewer(Composite parent) {
        DebugUITools.addPartDebugContextListener((IWorkbenchPartSite)this.getSite(), (IDebugContextListener)this);
        this.treeViewer = this.createSvdViewer(parent);
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        this.treeViewer.addSelectionChangedListener(this.selectionChangedListener);
        this.treeViewer.addStructureChangedListener(this.structureChangedListener);
        this.updateContext(DebugUITools.getDebugContext());
        return this.treeViewer;
    }

    protected abstract SvdTreeViewerBase createSvdViewer(Composite var1);

    public void dispose() {
        DebugUITools.removePartDebugContextListener((IWorkbenchPartSite)this.getSite(), (IDebugContextListener)this);
        this.actionsMap.clear();
        this.treeViewer.removeSelectionChangedListener(this.selectionChangedListener);
        this.treeViewer.removeStructureChangedListener(this.structureChangedListener);
        super.dispose();
    }

    protected String getHelpContextId() {
        return null;
    }

    public void setAction(String actionID, IAction action) {
        super.setAction(actionID, action);
        if (action == null) {
            this.actionsMap.remove(actionID);
        } else {
            this.actionsMap.put(actionID, action);
        }
    }

    public Map<String, IAction> getActionsMap() {
        return Collections.unmodifiableMap(this.actionsMap);
    }

    protected void initializeToolBar() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        this.configureToolBar(toolBarManager);
        this.getViewSite().getActionBars().updateActionBars();
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        this.configureToolBarMenu(menuManager);
        menuManager.update(true);
        this.asyncExec(() -> {
            this.initActionsState((IContributionManager)toolBarManager);
            this.initActionsState((IContributionManager)menuManager);
        });
    }

    protected void createActions() {
        this.setAction(FIND_ACTION, (IAction)new SvdFindAction(this.treeViewer));
        this.setAction(COPY_ACTION, (IAction)new SvdCopyAction(this.treeViewer));
        this.setAction(DEFAULT_LAYOUT_ACTION, (IAction)new SvdDefaultLayoutAction(this.treeViewer));
        this.setAction(SHOW_STRUCTURE_ACTION, (IAction)new SvdShowStructureAction(this.treeViewer));
    }

    protected final void fillContextMenu(IMenuManager menu) {
        List<Object> actionsOrContributions = this.getActionsOrContributions();
        for (Object object : actionsOrContributions) {
            if (object instanceof IAction) {
                IAction action = (IAction)object;
                if (action instanceof IUpdate) {
                    ((IUpdate)action).update();
                }
                if (action instanceof SvdVisible) {
                    if (!((SvdVisible)action).isVisible()) continue;
                    menu.add(action);
                    continue;
                }
                menu.add(action);
                continue;
            }
            if (object instanceof IContributionItem) {
                menu.add((IContributionItem)object);
                continue;
            }
            throw new IllegalStateException("Invalid type of object: " + object.getClass().getCanonicalName());
        }
    }

    protected List<Object> getActionsOrContributions() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.getAction(FIND_ACTION));
        list.add(this.getAction(COPY_ACTION));
        return list;
    }

    protected void configureToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add(this.getAction(SHOW_STRUCTURE_ACTION));
    }

    protected void configureToolBarMenu(IMenuManager menuManager) {
        menuManager.add(this.getAction(DEFAULT_LAYOUT_ACTION));
        menuManager.add((IContributionItem)new Separator());
    }

    private void initActionsState(IContributionManager contributionManager) {
        if (!this.isAvailable()) {
            return;
        }
        IContributionItem[] items = contributionManager.getItems();
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                IAction action;
                if (items[i] instanceof ActionContributionItem && (action = ((ActionContributionItem)items[i]).getAction()).getStyle() == 2) {
                    this.initActionState(action);
                    action.run();
                }
                ++i;
            }
        }
        this.updateObjects();
    }
}

