/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.debug.gdbjtag.internal.pne;

import com.nxp.s32ds.cle.debug.gdbjtag.internal.pne.PeMicroPneActivator;
import com.nxp.s32ds.cle.ide.debugger.registry.LaunchConfigurationCreator;
import com.nxp.s32ds.cle.ide.launch.core.LaunchConfigurationUtil;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class PeMicroPneLaunchConfigurationCreator
implements LaunchConfigurationCreator {
    private static final String ATTR_PNE_DEB = "org.eclipse.cdt.dsf.gdb.DEBUG_NAME";
    private static final String ATTR_PNE_DEV = "com.pemicro.debug.gdbjtag.pne.PE.DEVICE_NAME";
    private static final String ATTR_PNE_NUM = "com.pemicro.debug.gdbjtag.pne.selectedCoreNumber";
    private static final String ATTR_PNE_RESET_DELAY = "com.pemicro.debug.gdbjtag.pne.ml.RESET_DELAY";
    private static final String ATTR_PNE_DO_RESET_DELAY = "com.pemicro.debug.gdbjtag.pne.ml.DO_RESET_DELAY";
    private static final String ATTR_DSF_GDB_PROCESS = "org.eclipse.cdt.dsf.gdb.GdbProcessFactory";

    public ILaunchConfigurationWorkingCopy createLaunchConfigurationWorkingCopy(Map<String, Object> attributes) throws CoreException {
        String component;
        IResource launchResource;
        ILaunchConfigurationType debuggerLaunchType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("com.pemicro.debug.gdbjtag.pne.launchConfigurationType");
        if (debuggerLaunchType == null) {
            IStatus errorStatus = LaunchConfigurationUtil.getUndefinedLaunchConfigurationTypeErrorStatus();
            throw new CoreException(errorStatus);
        }
        IProject project = LaunchConfigurationUtil.extractProject(attributes);
        IFolder container = project.getFolder("Project_Settings/Debugger");
        if (container == null || !container.isAccessible()) {
            container = project;
        }
        if ((launchResource = container.findMember(String.valueOf(component = String.valueOf(project.getName()) + "_" + LaunchConfigurationUtil.extractConfigurationName(attributes)) + ".launch")) != null && launchResource.isAccessible()) {
            IStatus errorStatus = LaunchConfigurationUtil.getLaunchConfigurationExistsErrorStatus();
            throw new CoreException(errorStatus);
        }
        ILaunchConfigurationWorkingCopy workingCopy = debuggerLaunchType.newInstance((IContainer)container, component);
        this.setupLaunchConfigurationWorkingCopy(workingCopy, attributes);
        return workingCopy;
    }

    public void setupLaunchConfigurationWorkingCopy(ILaunchConfigurationWorkingCopy workConfig, Map<String, Object> attributes) throws CoreException {
        IProject project = LaunchConfigurationUtil.extractProject(attributes);
        workConfig.setMappedResources(new IResource[]{project});
        String buildArtifact = LaunchConfigurationUtil.extractProjectExecutable(attributes);
        workConfig.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", project.getName());
        workConfig.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", buildArtifact);
        workConfig.setAttribute("process_factory_id", ATTR_DSF_GDB_PROCESS);
        workConfig.setAttribute(ATTR_PNE_DO_RESET_DELAY, true);
        workConfig.setAttribute(ATTR_PNE_RESET_DELAY, "200");
        workConfig.setAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", LaunchConfigurationUtil.extractConfigurationId(attributes));
        String deviceCoreId = LaunchConfigurationUtil.extractHardwareDeviceCoreId(attributes);
        String toolchainId = LaunchConfigurationUtil.extractHardwareToolchainId(attributes);
        String gdbClientValue = LaunchConfigurationUtil.getGDBClientValue((String)deviceCoreId, (String)"pne", (String)toolchainId);
        workConfig.setAttribute(ATTR_PNE_DEB, gdbClientValue);
        Map parameters = PeMicroPneActivator.getInstance().getService().getParameters(deviceCoreId, "com.pemicro.debug.gdbjtag.pne.launchConfigurationType");
        if (!parameters.containsKey(ATTR_PNE_DEV)) {
            Status errorStatus = new Status(4, PeMicroPneActivator.getInstance().getBundleId(), "devicePneId is undefined. Check launchConfigurationHardwareModel");
            throw new CoreException((IStatus)errorStatus);
        }
        workConfig.setAttribute(ATTR_PNE_DEV, (String)parameters.get(ATTR_PNE_DEV));
        if (parameters.containsKey(ATTR_PNE_NUM)) {
            workConfig.setAttribute(ATTR_PNE_NUM, parameters.get(ATTR_PNE_NUM));
        } else {
            workConfig.setAttribute(ATTR_PNE_NUM, 1);
        }
    }
}

