/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.resources.path;

import com.nxp.s32ds.ext.ide.internal.resources.ResourcesMessages;
import java.io.File;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class FileSystemPathCreationValidator
implements IValidator<String> {
    public static final String ID = "path.file.system.validator";

    public IStatus validate(String path) {
        if (path == null) {
            return new Status(4, "com.nxp.s32ds.ext.ide.resources", ResourcesMessages.ProjectPathValidator_invalid_path);
        }
        if (!FileSystemPathCreationValidator.checkCanCreate(path)) {
            String message = NLS.bind((String)ResourcesMessages.ProjectPathValidator_create_path, (Object)path);
            return new Status(4, "com.nxp.s32ds.ext.ide.resources", message);
        }
        return Status.OK_STATUS;
    }

    private static boolean checkCanCreate(String path) {
        File f = new File(path);
        while (!f.exists()) {
            if ((f = f.getParentFile()) != null) continue;
            return false;
        }
        return f.canWrite() && f.isDirectory();
    }
}

